/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable;

import java.io.Serializable;
import java.util.RandomAccess;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.list.immutable.AbstractImmutableList;

final class ImmutableTripletonList<T>
extends AbstractImmutableList<T>
implements Serializable,
RandomAccess {
    private static final long serialVersionUID = 1L;
    private final T element1;
    private final T element2;
    private final T element3;

    ImmutableTripletonList(T obj1, T obj2, T obj3) {
        this.element1 = obj1;
        this.element2 = obj2;
        this.element3 = obj3;
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        procedure.value(this.element1);
        procedure.value(this.element2);
        procedure.value(this.element3);
    }

    @Override
    public T get(int index) {
        switch (index) {
            case 0: {
                return this.element1;
            }
            case 1: {
                return this.element2;
            }
            case 2: {
                return this.element3;
            }
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    @Override
    public T getOnly() {
        throw new IllegalStateException("Size must be 1 but was " + this.size());
    }

    @Override
    public ImmutableList<T> newWith(T newItem) {
        return Lists.immutable.with(this.element1, this.element2, this.element3, newItem);
    }
}

