/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ByteIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.UnmodifiableByteBag;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedByteCollection;
import org.eclipse.collections.impl.factory.primitive.ByteBags;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;

public class SynchronizedByteBag
extends AbstractSynchronizedByteCollection
implements MutableByteBag {
    private static final long serialVersionUID = 1L;

    public SynchronizedByteBag(MutableByteBag bag) {
        super(bag);
    }

    public SynchronizedByteBag(MutableByteBag bag, Object newLock) {
        super(bag, newLock);
    }

    private MutableByteBag getMutableByteBag() {
        return (MutableByteBag)this.getByteCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedByteBag with(byte element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteBag().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedByteBag without(byte element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteBag().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedByteBag withAll(ByteIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteBag().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedByteBag withoutAll(ByteIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteBag().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOccurrences(byte item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteBag().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeOccurrences(byte item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int occurrencesOf(byte item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachWithOccurrences(ByteIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteBag().forEachWithOccurrences(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteBag select(BytePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteBag selectByOccurrences(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().selectByOccurrences(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteSet selectUnique() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().selectUnique();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<ByteIntPair> topOccurrences(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().topOccurrences(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableList<ByteIntPair> bottomOccurrences(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().bottomOccurrences(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteBag reject(BytePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().collect((ByteToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherBag) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().equals(otherBag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyByteIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyByteIterableAdapter(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteBag asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return new UnmodifiableByteBag(this);
        }
    }

    @Override
    public MutableByteBag asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableByteBag toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return ByteBags.immutable.withAll(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableByteBag newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteBag().newEmpty();
        }
    }
}

