/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.factory.map.primitive.MutableCharCharMapFactory;
import org.eclipse.collections.api.map.primitive.CharCharMap;
import org.eclipse.collections.api.map.primitive.MutableCharCharMap;
import org.eclipse.collections.impl.factory.primitive.CharCharMaps;
import org.eclipse.collections.impl.map.mutable.primitive.CharCharHashMap;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableCharCharMapFactoryImpl implements MutableCharCharMapFactory
{
    INSTANCE;


    @Override
    public MutableCharCharMap empty() {
        return new CharCharHashMap(0);
    }

    @Override
    public MutableCharCharMap of() {
        return this.empty();
    }

    @Override
    public MutableCharCharMap with() {
        return this.empty();
    }

    @Override
    public MutableCharCharMap ofInitialCapacity(int capacity) {
        return this.withInitialCapacity(capacity);
    }

    @Override
    public MutableCharCharMap withInitialCapacity(int capacity) {
        return new CharCharHashMap(capacity);
    }

    @Override
    public MutableCharCharMap ofAll(CharCharMap map) {
        return this.withAll(map);
    }

    @Override
    public MutableCharCharMap withAll(CharCharMap map) {
        if (map.isEmpty()) {
            return this.empty();
        }
        return new CharCharHashMap(map);
    }

    @Override
    public <T> MutableCharCharMap from(Iterable<T> iterable, CharFunction<? super T> keyFunction, CharFunction<? super T> valueFunction) {
        MutableCharCharMap map = CharCharMaps.mutable.empty();
        Iterate.forEach(iterable, each -> map.put(keyFunction.charValueOf(each), valueFunction.charValueOf(each)));
        return map;
    }
}

