/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.notification;

import org.eclipse.capra.ui.notification.CapraNotificationHelper;
import org.eclipse.capra.ui.notification.ChangeQuickFix;
import org.eclipse.capra.ui.notification.DeleteQuickFix;
import org.eclipse.capra.ui.notification.RenameOrMoveQuickFix;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class MarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            String issue = (String)marker.getAttribute("issueType");
            if (issue.equals(CapraNotificationHelper.IssueType.RENAMED.getValue()) || issue.equals(CapraNotificationHelper.IssueType.MOVED.getValue())) {
                return new IMarkerResolution[]{new RenameOrMoveQuickFix("Update the EMF presentation.")};
            }
            if (issue.equals(CapraNotificationHelper.IssueType.DELETED.getValue())) {
                return new IMarkerResolution[]{new DeleteQuickFix("Delete the affected trace link.")};
            }
            if (issue.equals(CapraNotificationHelper.IssueType.CHANGED.getValue())) {
                return new IMarkerResolution[]{new DeleteQuickFix("Delete the affected trace link."), new ChangeQuickFix("Do not update existing trace link.")};
            }
            return null;
        }
        catch (CoreException e) {
            return new IMarkerResolution[0];
        }
    }
}

