/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ModuleCoreUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.common.modulecore.ui";
    public static final String[] ICON_DIRS = new String[]{"icons/full/obj16", "icons/full/cview16", "icons/full/ctool16", "icons/full/clcl16", "icons/full/ovr16", "icons/full/extra", "icons/full/wizban", "icons", ""};
    private static ModuleCoreUIPlugin plugin;

    public static ModuleCoreUIPlugin getInstance() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public Image getImage(String key) {
        ImageDescriptor descriptor;
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if ((image == null || image.isDisposed()) && (descriptor = this.getImageDescriptor(key)) != null) {
            image = descriptor.createImage();
            imageRegistry.put(key, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        URL gifImageURL = this.getImageURL(key, this.getBundle());
        if (gifImageURL != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
        }
        return imageDescriptor;
    }

    public URL getImageURL(String key, Bundle bundle) {
        String gif = "/" + key + ".gif";
        IPath path = null;
        int i = 0;
        while (i < ICON_DIRS.length) {
            path = new Path(ICON_DIRS[i]).append(gif);
            if (Platform.find((Bundle)bundle, (IPath)path) != null) {
                try {
                    return new URL(bundle.getEntry("/"), path.toString());
                }
                catch (MalformedURLException exception) {
                    ModuleCoreUIPlugin.logError(exception);
                }
            }
            ++i;
        }
        return null;
    }

    public static ModuleCoreUIPlugin getDefault() {
        return plugin;
    }

    public static void log(Exception e) {
        ModuleCoreUIPlugin.log(e.getMessage(), e);
    }

    public static void log(String message, Exception e) {
        Status status = new Status(4, PLUGIN_ID, message, (Throwable)e);
        ModuleCoreUIPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static IStatus createStatus(int severity, int aCode, String aMessage, Throwable exception) {
        return new Status(severity, PLUGIN_ID, aCode, aMessage != null ? aMessage : "No message.", exception);
    }

    public static IStatus createErrorStatus(int aCode, String aMessage, Throwable exception) {
        return ModuleCoreUIPlugin.createStatus(4, aCode, aMessage, exception);
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return ModuleCoreUIPlugin.createStatus(severity, message, null);
    }

    public static void logError(Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(ModuleCoreUIPlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(exception.getStatus());
    }
}

