/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.valueexpr;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.IValidator;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.manifest.FunctionExpressionDefinition;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.spec.manifest.SupportedDataSetType;
import org.eclipse.datatools.connectivity.oda.spec.util.ValidatorUtil;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.FunctionValueExpression;

public class CustomFunction
extends FunctionValueExpression
implements IExecutableExtension {
    private static final String QUALIFIER_SEPARATOR = ".";
    private String m_extensionId;
    private String m_id;
    private FunctionExpressionDefinition m_definition;
    private Map<String, Object> m_customData;

    protected CustomFunction(String extensionId, String id) {
        super(null);
        this.m_extensionId = extensionId;
        this.m_id = id;
    }

    protected CustomFunction() {
        super(null);
    }

    public void setInitializationData(IConfigurationElement exprElement, String propertyName, Object data) throws CoreException {
        this.m_extensionId = exprElement.getDeclaringExtension().getUniqueIdentifier();
        try {
            this.m_id = FunctionExpressionDefinition.getIdAttributeValue(exprElement);
        }
        catch (OdaException ex) {
            throw new CoreException((IStatus)new Status(4, exprElement.getContributor().getName(), ex.getLocalizedMessage()));
        }
    }

    public String getId() {
        return this.m_id;
    }

    public String getDeclaringExtensionId() {
        return this.m_extensionId;
    }

    @Override
    public String getQualifiedId() {
        return String.valueOf(this.m_extensionId) + QUALIFIER_SEPARATOR + this.m_id;
    }

    @Override
    public String getName() {
        FunctionExpressionDefinition defn = this.getDefinition();
        if (defn == null) {
            return this.getId();
        }
        return defn.getName();
    }

    public boolean supportsDataSetType(String odaDataSourceId, String odaDataSetId) {
        FunctionExpressionDefinition defn = this.getDefinition();
        if (defn == null) {
            return false;
        }
        return defn.supportsDataSetType(odaDataSourceId, odaDataSetId);
    }

    public boolean supportsDataSetType(SupportedDataSetType dataSetType) {
        if (dataSetType == null) {
            return false;
        }
        return this.supportsDataSetType(dataSetType.getOdaDataSourceId(), dataSetType.getOdaDataSetId());
    }

    public boolean canIgnoreDuplicateValues() {
        FunctionExpressionDefinition defn = this.getDefinition();
        return defn == null ? false : defn.canIgnoreDuplicateValues();
    }

    public FunctionExpressionDefinition getDefinition() {
        if (this.m_definition == null) {
            try {
                this.m_definition = ResultExtensionExplorer.getInstance().getExtensionFunctionDefinition(this.getDeclaringExtensionId(), this.getId());
            }
            catch (OdaException odaException) {
                return null;
            }
        }
        return this.m_definition;
    }

    public Object getData(String key) {
        if (this.m_customData == null) {
            return null;
        }
        return this.m_customData.get(key);
    }

    public void setData(String key, Object value) {
        if (this.m_customData == null) {
            this.m_customData = new HashMap<String, Object>();
        }
        this.m_customData.put(key, value);
    }

    @Override
    public void validateSyntax(ValidationContext context) throws OdaException {
        try {
            FunctionExpressionDefinition defn = this.getDefinition();
            if (defn == null) {
                throw new OdaException(Messages.bind((String)Messages.querySpec_NON_DEFINED_CUSTOM_FUNC, (Object)this.getName()));
            }
            this.validateSyntax(context, defn);
            IValidator customValidator = this.getValidator(context, defn);
            if (customValidator != null) {
                customValidator.validateSyntax(this, context);
            }
        }
        catch (OdaException ex) {
            throw ValidatorUtil.newValueExprException(this, ex);
        }
    }

    protected void validateSyntax(ValidationContext context, FunctionExpressionDefinition defn) throws OdaException {
        int maxArgs;
        int minArgs;
        assert (defn != null);
        int numArgs = this.getArguments().valueCount();
        if (numArgs < (minArgs = defn.getMinArguments().intValue())) {
            throw this.newValueExprException(Messages.bind((String)Messages.querySpec_CUSTOM_FUNC_LESS_THAN_MIN_ARGS, (Object[])new Object[]{this.getName(), numArgs, minArgs}));
        }
        if (!defn.supportsUnboundedMaxArguments() && numArgs > (maxArgs = defn.getMaxArguments().intValue())) {
            throw this.newValueExprException(Messages.bind((String)Messages.querySpec_CUSTOM_FUNC_EXCEED_MAX_ARGS, (Object[])new Object[]{this.getName(), numArgs, maxArgs}));
        }
        if (this.ignoresDuplicateValues() && !defn.canIgnoreDuplicateValues()) {
            throw this.newValueExprException(Messages.bind((String)Messages.querySpec_CUSTOM_FUNC_INCOMPATIBLE_DUPL_CHECK, (Object)this.getName()));
        }
    }

    protected OdaException newValueExprException(String message) {
        return ValidatorUtil.newValueExprException(message, this);
    }

    protected IValidator getValidator(ValidationContext context, FunctionExpressionDefinition defn) {
        if (context != null && context.getValidator() != null) {
            return context.getValidator();
        }
        try {
            if (defn != null) {
                return defn.getValidator();
            }
        }
        catch (OdaException odaException) {}
        return null;
    }
}

