/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import java.util.HashMap;
import org.eclipse.birt.core.preference.IPreferences;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.IReportPreferenceFactory;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceWrapper;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PreferenceFactory
implements IPropertyChangeListener {
    private static PreferenceFactory instance = null;
    private HashMap preferenceMap = new HashMap();

    private PreferenceFactory() {
    }

    public static synchronized PreferenceFactory getInstance() {
        if (instance == null) {
            instance = new PreferenceFactory();
        }
        return instance;
    }

    public IPreferences getPreferences(AbstractUIPlugin plugin) {
        return this.getPreferences(plugin, null);
    }

    public IPreferences getPluginPreferences(String pluginId, IProject project) {
        IReportPreferenceFactory preference = (IReportPreferenceFactory)ElementAdapterManager.getAdapter((Object)ReportPlugin.getDefault(), IReportPreferenceFactory.class);
        if (preference == null || project == null) {
            if (this.preferenceMap.containsKey(pluginId)) {
                return (PreferenceWrapper)((Object)this.preferenceMap.get(pluginId));
            }
        } else {
            String id = pluginId.concat("/").concat(project.getName());
            if (this.preferenceMap.containsKey(id)) {
                return (PreferenceWrapper)((Object)this.preferenceMap.get(id));
            }
        }
        return null;
    }

    public IPreferences getPreferences(AbstractUIPlugin plugin, IProject project) {
        String pluginId = plugin.getBundle().getSymbolicName();
        IReportPreferenceFactory preference = (IReportPreferenceFactory)ElementAdapterManager.getAdapter(plugin, IReportPreferenceFactory.class);
        PreferenceWrapper wrapper = null;
        if (preference == null || project == null) {
            if (this.preferenceMap.containsKey(pluginId)) {
                return (PreferenceWrapper)((Object)this.preferenceMap.get(pluginId));
            }
            wrapper = new PreferenceWrapper(plugin.getPreferenceStore());
            wrapper.getPrefsStore().addPropertyChangeListener((IPropertyChangeListener)this);
            this.preferenceMap.put(pluginId, wrapper);
        } else {
            String id = pluginId.concat("/").concat(project.getName());
            if (this.preferenceMap.containsKey(id)) {
                return (PreferenceWrapper)((Object)this.preferenceMap.get(id));
            }
            wrapper = new PreferenceWrapper(preference, project, plugin.getPreferenceStore());
            wrapper.getPrefsStore().addPropertyChangeListener((IPropertyChangeListener)this);
            this.preferenceMap.put(id, wrapper);
        }
        return wrapper;
    }

    public void propertyChange(PropertyChangeEvent event) {
        PreferenceWrapper[] prefs = this.preferenceMap.values().toArray(new PreferenceWrapper[0]);
        int i = 0;
        while (i < prefs.length) {
            if (prefs[i].getPrefsStore() == event.getSource()) {
                prefs[i].firePreferenceChangeEvent(event.getProperty(), event.getOldValue(), event.getNewValue());
            }
            ++i;
        }
    }
}

