/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.wizards;

import java.io.File;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewReportPageSupport {
    private Composite topLevel;
    private static final String LABEL_SELECT_A_DIRECTORY = Messages.getString((String)"WizardNewReportCreationPage.label.select.directory");
    private static final String LABEL_BROWSE = Messages.getString((String)"WizardNewReportCreationPage.label.browse");
    private static final String LABEL_DIRECTORY = Messages.getString((String)"WizardNewReportCreationPage.label.directory");
    private static final String LABEL_USE_DEFAULT = Messages.getString((String)"WizardNewReportCreationPage.label.useDefault");
    private static final String LABEL_FILE_LOCATION = Messages.getString((String)"WizardNewReportCreationPage.label.file.location");
    private static final String LABEL_FILE_NAME = Messages.getString((String)"WizardNewReportCreationPage.label.file.name");
    private Text fileNameField;
    private Text locationPathField;
    private Label locationLabel;
    private Button browseButton;
    boolean useDefaults = true;
    private String initialFileName;
    private String defaultFileLocation;
    private String customLocationFieldValue = "";

    public Composite createComposite(Composite parent) {
        this.topLevel = new Composite(parent, 0);
        this.topLevel.setLayout((Layout)new GridLayout());
        this.topLevel.setFont(parent.getFont());
        this.createFileNameGroup(this.topLevel);
        this.createFileLocationGroup(this.topLevel);
        return this.topLevel;
    }

    private final void createFileNameGroup(Composite parent) {
        Composite nameGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        nameGroup.setLayout((Layout)layout);
        nameGroup.setLayoutData((Object)new GridData(768));
        Label fileLabel = new Label(nameGroup, 0);
        fileLabel.setText(LABEL_FILE_NAME);
        fileLabel.setFont(parent.getFont());
        this.fileNameField = new Text(nameGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.getFileNameField().setLayoutData((Object)data);
        this.getFileNameField().setFont(parent.getFont());
        this.initInput();
    }

    protected void initInput() {
        if (this.initialFileName != null) {
            this.getFileNameField().setText(this.initialFileName);
        } else {
            this.getFileNameField().setText("");
        }
    }

    private final void createFileLocationGroup(Composite parent) {
        Font font = parent.getFont();
        Group locationGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        locationGroup.setLayout((Layout)layout);
        locationGroup.setLayoutData((Object)new GridData(768));
        locationGroup.setFont(font);
        locationGroup.setText(LABEL_FILE_LOCATION);
        final Button useDefaultsButton = new Button((Composite)locationGroup, 131104);
        useDefaultsButton.setText(LABEL_USE_DEFAULT);
        useDefaultsButton.setSelection(this.useDefaults);
        useDefaultsButton.setFont(font);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup((Composite)locationGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewReportPageSupport.this.useDefaults = useDefaultsButton.getSelection();
                NewReportPageSupport.this.browseButton.setEnabled(!NewReportPageSupport.this.useDefaults);
                NewReportPageSupport.this.locationPathField.setEnabled(!NewReportPageSupport.this.useDefaults);
                NewReportPageSupport.this.locationLabel.setEnabled(!NewReportPageSupport.this.useDefaults);
                if (NewReportPageSupport.this.useDefaults) {
                    NewReportPageSupport.this.customLocationFieldValue = NewReportPageSupport.this.locationPathField.getText();
                    NewReportPageSupport.this.setLocationForSelection();
                } else {
                    NewReportPageSupport.this.locationPathField.setText(NewReportPageSupport.this.customLocationFieldValue);
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    public String getFileName() {
        if (this.getFileNameField() == null) {
            return this.initialFileName;
        }
        return this.getFileNameField().getText().trim();
    }

    public IPath getFileLocationFullPath() {
        if (this.locationPathField == null) {
            return new Path("");
        }
        return new Path(this.locationPathField.getText().trim());
    }

    private void createUserSpecifiedProjectLocationGroup(Composite group, boolean enabled) {
        Font font = group.getFont();
        this.locationLabel = new Label(group, 0);
        this.locationLabel.setText(LABEL_DIRECTORY);
        this.locationLabel.setEnabled(enabled);
        this.locationLabel.setFont(font);
        this.locationPathField = new Text(group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setEnabled(enabled);
        this.locationPathField.setFont(font);
        this.browseButton = new Button(group, 8);
        this.browseButton.setText(LABEL_BROWSE);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewReportPageSupport.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        this.browseButton.setFont(font);
        this.setButtonLayoutData(this.browseButton);
        if (this.defaultFileLocation != null) {
            this.locationPathField.setText(this.defaultFileLocation);
        } else {
            this.locationPathField.setText("");
        }
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(LABEL_SELECT_A_DIRECTORY);
        String dirName = this.getFileLocationFullPath().toOSString();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.customLocationFieldValue = selectedDirectory;
            this.locationPathField.setText(this.customLocationFieldValue);
        }
    }

    private void setLocationForSelection() {
        if (this.useDefaults) {
            this.locationPathField.setText(this.defaultFileLocation);
        }
    }

    public void setInitialFileName(String name) {
        this.initialFileName = name == null ? null : name.trim();
    }

    public String getInitialFileName() {
        return this.initialFileName;
    }

    protected GridData setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = minSize.x;
        button.setLayoutData((Object)data);
        return data;
    }

    public void setInitialFileLocation(String path) {
        this.defaultFileLocation = path;
    }

    public Text getFileNameField() {
        return this.fileNameField;
    }

    public Text getLocationPathField() {
        return this.locationPathField;
    }
}

