/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.script;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.script.OLAPExpressionHandler;

public class OLAPExpressionCompiler {
    public static void compile(ScriptContext cx, IBaseExpression expr) throws DataException {
        if (expr instanceof IConditionalExpression) {
            OLAPExpressionCompiler.prepareScriptExpression(cx, ((IConditionalExpression)expr).getExpression());
            OLAPExpressionCompiler.prepareScriptExpression(cx, ((IConditionalExpression)expr).getOperand1());
            OLAPExpressionCompiler.prepareScriptExpression(cx, ((IConditionalExpression)expr).getOperand2());
        } else if (expr instanceof IScriptExpression) {
            OLAPExpressionCompiler.prepareScriptExpression(cx, (IScriptExpression)expr);
        }
    }

    private static void prepareScriptExpression(ScriptContext cx, IBaseExpression expr1) throws DataException {
        try {
            if (expr1 == null) {
                return;
            }
            if (expr1 instanceof IScriptExpression) {
                String exprText = ((IScriptExpression)expr1).getText();
                if (expr1.getHandle() == null && !"constant".equals(expr1.getScriptId())) {
                    expr1.setHandle(new OLAPExpressionHandler(cx.compile(expr1.getScriptId(), null, 0, exprText)));
                }
            } else if (expr1 instanceof IExpressionCollection) {
                Object[] exprs = ((IExpressionCollection)expr1).getExpressions().toArray();
                int i = 0;
                while (i < exprs.length) {
                    OLAPExpressionCompiler.prepareScriptExpression(cx, (IBaseExpression)exprs[i]);
                    ++i;
                }
            }
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }
}

