/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.logging.Logger;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw3d.AbstractConnectionAnchor3D;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.FigureSurface;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.Locator1D;
import org.eclipse.draw3d.geometry.BoundingBoxImpl;
import org.eclipse.draw3d.geometry.IBoundingBox;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.util.Draw3DCache;

public class BorderAnchor3D
extends AbstractConnectionAnchor3D {
    private static final Logger log = Logger.getLogger(BorderAnchor3D.class.getName());
    private ISurface m_surface;
    private Locator1D m_xLocator;
    private Locator1D m_yLocator;
    private Locator1D m_zLocator;

    protected BorderAnchor3D() {
    }

    public BorderAnchor3D(IFigure owner) {
        this(owner, new Locator1D.Relative(0.5f), new Locator1D.Relative(0.5f), new Locator1D.Relative(0.5f));
    }

    public BorderAnchor3D(IFigure i_owner, Locator1D i_xLocator, Locator1D i_yLocator, Locator1D i_zLocator) {
        super(i_owner);
        if (i_xLocator == null) {
            throw new NullPointerException("i_xLocator must not be null");
        }
        if (i_yLocator == null) {
            throw new NullPointerException("i_yLocator must not be null");
        }
        if (i_zLocator == null) {
            throw new NullPointerException("i_zLocator must not be null");
        }
        this.m_xLocator = i_xLocator;
        this.m_yLocator = i_yLocator;
        this.m_zLocator = i_zLocator;
    }

    private Point doGetLocation(Point reference, boolean absoluteMode) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getBox());
        r.translate(-1, -1);
        r.resize(1, 1);
        if (absoluteMode) {
            this.getOwner().translateToAbsolute((Translatable)r);
        }
        float centerX = (float)r.x + 0.5f * (float)r.width;
        float centerY = (float)r.y + 0.5f * (float)r.height;
        if (r.isEmpty() || reference == null || reference.x == (int)centerX && reference.y == (int)centerY) {
            return new Point((int)centerX, (int)centerY);
        }
        float dx = (float)reference.x - centerX;
        float dy = (float)reference.y - centerY;
        float scale = 0.5f / Math.max(Math.abs(dx) / (float)r.width, Math.abs(dy) / (float)r.height);
        return new Point(Math.round(centerX += (dx *= scale)), Math.round(centerY += (dy *= scale)));
    }

    private Vector3f doGetReferencePoint3D(Vector3f io_result) {
        Vector3f size;
        Vector3f result;
        block4: {
            Vector3f vector3f;
            result = io_result;
            if (result == null) {
                result = new Vector3fImpl();
            }
            size = Draw3DCache.getVector3f();
            try {
                IBoundingBox boundingBox = this.getBounds3D();
                boundingBox.getSize(size);
                if (size.lengthSquared() != 0.0f) break block4;
                boundingBox.getCenter(result);
                vector3f = result;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{size});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{size});
            return vector3f;
        }
        result.setX(this.m_xLocator.getLocation(size.getX()));
        result.setY(this.m_yLocator.getLocation(size.getY()));
        result.setZ(this.m_zLocator.getLocation(size.getZ()));
        ISurface surface = this.getSurface();
        surface.getWorldLocation((IVector3f)result, result);
        Vector3f vector3f = result;
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{size});
        return vector3f;
    }

    protected IBoundingBox getBounds3D() {
        BoundingBoxImpl boundingBoxImpl;
        IFigure owner = this.getOwner();
        if (owner instanceof IFigure3D) {
            IFigure3D owner3D = (IFigure3D)owner;
            return owner3D.getBounds3D();
        }
        Vector3f origin3D = Draw3DCache.getVector3f();
        Vector3f tmp = Draw3DCache.getVector3f();
        Vector3f size3D = Draw3DCache.getVector3f();
        try {
            IFigure3D host = Figure3DHelper.getAncestor3D(owner);
            if (host == null) {
                throw new IllegalStateException("no 3D host found");
            }
            ISurface surface = host.getSurface();
            Rectangle bounds = owner.getBounds();
            Point bl = bounds.getBottomLeft();
            Point tr = bounds.getTopRight();
            surface.getWorldLocation(bl, origin3D);
            surface.getWorldLocation(tr, tmp);
            Math3D.sub((IVector3f)tmp, (IVector3f)origin3D, (Vector3f)size3D);
            boundingBoxImpl = new BoundingBoxImpl((IVector3f)origin3D, (IVector3f)size3D);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{origin3D, tmp, size3D});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{origin3D, tmp, size3D});
        return boundingBoxImpl;
    }

    protected Rectangle getBox() {
        return this.getOwner().getBounds();
    }

    public Point getLocation(Point reference) {
        return this.doGetLocation(reference, true);
    }

    public IVector3f getLocation3D(IVector3f i_reference, Vector3f io_result) {
        Vector3f vector3f;
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        Vector3f localReference = Draw3DCache.getVector3f();
        Vector3f rayDirection = Draw3DCache.getVector3f();
        try {
            if (this.getOwner() instanceof IFigure3D) {
                IFigure3D owner3D = (IFigure3D)this.getOwner();
                this.doGetReferencePoint3D(localReference);
                Math3D.sub((IVector3f)localReference, (IVector3f)i_reference, (Vector3f)rayDirection);
                Math3D.normalise((IVector3f)rayDirection, (Vector3f)rayDirection);
                float distance = owner3D.getDistance(i_reference, (IVector3f)rayDirection, null);
                Math3D.getLocation((IVector3f)i_reference, (IVector3f)rayDirection, (float)distance, (Vector3f)result);
            } else {
                Point reference = this.getReferencePoint();
                ISurface surface = this.getSurface();
                surface.getWorldLocation(reference, result);
            }
            vector3f = result;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{localReference, rayDirection});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{localReference, rayDirection});
        return vector3f;
    }

    public Point getReferencePoint() {
        Point reference = new Point(this.getBox().getTopLeft());
        reference.x += (int)this.m_xLocator.getLocation(this.getBox().width);
        reference.y += (int)this.m_yLocator.getLocation(this.getBox().height);
        this.getOwner().translateToAbsolute((Translatable)reference);
        return reference;
    }

    public Vector3f getReferencePoint3D(Vector3f io_result) {
        IFigure owner = this.getOwner();
        if (owner == null) {
            return null;
        }
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        if (owner instanceof IFigure3D) {
            this.doGetReferencePoint3D(result);
        } else {
            Point ref2D = this.getReferencePoint();
            ISurface surface = this.getSurface();
            surface.getWorldLocation(ref2D, result);
        }
        return result;
    }

    protected ISurface getSurface() {
        IFigure figure = this.getOwner();
        IFigure3D figure3D = Figure3DHelper.getAncestor3D(figure);
        if (figure3D == null) {
            return null;
        }
        ISurface surface = figure3D.getSurface();
        if (surface != null) {
            return surface;
        }
        if (this.m_surface == null) {
            this.m_surface = new FigureSurface(figure3D);
        }
        return this.m_surface;
    }

    public void setOwner(IFigure i_owner) {
        if (i_owner != this.getOwner()) {
            this.m_surface = null;
        }
        super.setOwner(i_owner);
    }
}

