/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.command;

import org.ascape.runtime.Runner;
import org.eclipse.amp.escape.command.ResourceHandler;
import org.eclipse.amp.escape.ide.EclipseEscapeRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class ExecuteHandler
extends ResourceHandler {
    private boolean headless;

    public ExecuteHandler(boolean headless) {
        this.setHeadless(headless);
    }

    @Override
    public final void execute(final Object executed, String name) throws ExecutionException {
        Job escapeRun = new Job("Run " + name){
            private EclipseEscapeRunner eclipseRunner;

            protected IStatus run(IProgressMonitor monitor) {
                ExecuteHandler.this.setMonitor(monitor);
                try {
                    this.eclipseRunner = ExecuteHandler.this.executeOpen(executed, monitor);
                }
                catch (RuntimeException e) {
                    ExecuteHandler.this.setMonitor(null);
                    throw e;
                }
                ExecuteHandler.this.setMonitor(null);
                if (this.eclipseRunner != null) {
                    return this.eclipseRunner.getFinishStatus();
                }
                return Status.CANCEL_STATUS;
            }

            protected void canceling() {
                if (this.eclipseRunner != null) {
                    this.eclipseRunner.setFinishStatus(Status.CANCEL_STATUS);
                    this.eclipseRunner.closeFinally();
                }
            }
        };
        escapeRun.setPriority(30);
        escapeRun.schedule();
    }

    protected abstract EclipseEscapeRunner executeOpen(Object var1, IProgressMonitor var2);

    protected EclipseEscapeRunner createRunner() {
        Runner.setDisplayGraphics((!this.isHeadless() ? 1 : 0) != 0);
        return new EclipseEscapeRunner();
    }

    public void setEnabled(Object evaluationContext) {
        EvaluationContext ctx = (EvaluationContext)evaluationContext;
        Object selection = ctx.getVariable("selection");
        if (selection instanceof IStructuredSelection) {
            boolean enabled = false;
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss != null && ss.getFirstElement() != null) {
                Object fs = ss.getFirstElement();
                enabled = this.handleSelect(fs);
            }
            this.setBaseEnabled(enabled);
        }
    }

    protected abstract boolean handleSelect(Object var1);

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public boolean isHeadless() {
        return this.headless;
    }
}

