/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.graphics;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.graphics.optimizer.PrimitiveSet;
import org.eclipse.draw3d.graphics.optimizer.classification.PrimitiveClass;
import org.eclipse.draw3d.graphics.optimizer.primitive.ImagePrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.Primitive;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.ILodHelper;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglVBO;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglVertexPrimitiveVBO;
import org.eclipse.draw3d.util.BufferUtils;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.draw3d.util.ImageConverter;
import org.eclipse.draw3d.util.RectanglePacker;
import org.eclipse.draw3d.util.converter.ColorBufferInfo;
import org.eclipse.draw3d.util.converter.ImageConverter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.lwjgl.opengl.GL11;

public class LwjglImageVBO
extends LwjglVertexPrimitiveVBO {
    private RectanglePacker<ImagePrimitive> m_packer;
    private int m_textureId;

    public LwjglImageVBO(PrimitiveSet i_primitives) {
        super(i_primitives);
        PrimitiveClass clazz = i_primitives.getPrimitiveClass();
        if (!clazz.isImage()) {
            throw new IllegalArgumentException(i_primitives + " does not contain images");
        }
    }

    private void addTexCoord(FloatBuffer i_buffer, int i_tw, int i_th, int i_x, int i_y) {
        float s = (float)i_x / (float)i_tw;
        float t = (float)i_y / (float)i_th;
        i_buffer.put(s);
        i_buffer.put(t);
    }

    protected void cleanup(Graphics3D i_g3d, ILodHelper i_lodContext) {
        super.cleanup(i_g3d, i_lodContext);
        GL11.glPopAttrib();
    }

    public void dispose() {
        super.dispose();
        if (this.m_textureId != 0) {
            IntBuffer idBuffer = Draw3DCache.getIntBuffer((int)1);
            try {
                idBuffer.put(0, this.m_textureId);
                idBuffer.rewind();
                GL11.glDeleteTextures((IntBuffer)idBuffer);
                this.m_textureId = 0;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{idBuffer});
                throw throwable;
            }
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{idBuffer});
        }
    }

    protected void doRender(Graphics3D i_g3d, ILodHelper i_lodContext) {
        i_g3d.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glPolygonMode((int)1032, (int)6914);
        GL11.glDrawArrays((int)7, (int)0, (int)this.getVertexCount());
    }

    private void drawImage(Image i_sourceImage, Rectangle i_sourceClip, ImageData i_targetData, Point i_targetPosition) {
        ImageData sourceData = i_sourceImage.getImageData();
        int y = 0;
        while (y < i_sourceClip.height) {
            int x = 0;
            while (x < i_sourceClip.width) {
                int pixel = sourceData.getPixel(x + i_sourceClip.x, y + i_sourceClip.y);
                RGB rgb = sourceData.palette.getRGB(pixel);
                pixel = i_targetData.palette.getPixel(rgb);
                i_targetData.setPixel(i_targetPosition.x + x, i_targetPosition.y + y, pixel);
                int alpha = sourceData.getAlpha(x, y);
                i_targetData.setAlpha(i_targetPosition.x + x, i_targetPosition.y + y, alpha);
                ++x;
            }
            ++y;
        }
    }

    protected Buffer getBuffer(LwjglVBO.BufferType i_type) {
        if (i_type == LwjglVBO.BufferType.TEXTURE_COORDINATES) {
            FloatBuffer floatBuffer;
            FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(2 * this.getVertexCount()));
            int tw = this.m_packer.getLength();
            int th = this.m_packer.getLength();
            Point p = Draw3DCache.getPoint();
            try {
                for (Primitive primitive : this.getPrimitives().getPrimitives()) {
                    ImagePrimitive imagePrimitive = (ImagePrimitive)primitive;
                    Rectangle s = imagePrimitive.getSource();
                    this.m_packer.getPosition((Object)imagePrimitive, p);
                    this.addTexCoord(buffer, tw, th, p.x, p.y);
                    this.addTexCoord(buffer, tw, th, p.x, p.y + s.height);
                    this.addTexCoord(buffer, tw, th, p.x + s.width, p.y + s.height);
                    this.addTexCoord(buffer, tw, th, p.x + s.width, p.y);
                }
                floatBuffer = buffer;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnPoint((Point[])new Point[]{p});
                throw throwable;
            }
            Draw3DCache.returnPoint((Point[])new Point[]{p});
            return floatBuffer;
        }
        return super.getBuffer(i_type);
    }

    protected LwjglVBO.BufferInfo getBufferInfo(LwjglVBO.BufferType i_type) {
        if (i_type == LwjglVBO.BufferType.TEXTURE_COORDINATES) {
            return new LwjglVBO.BufferInfo(5126, 35041, 2, 0, 0);
        }
        return super.getBufferInfo(i_type);
    }

    protected boolean hasBuffer(LwjglVBO.BufferType i_type) {
        if (i_type == LwjglVBO.BufferType.TEXTURE_COORDINATES) {
            return true;
        }
        return super.hasBuffer(i_type);
    }

    public void initialize(Graphics3D i_g3d) {
        this.m_packer = new RectanglePacker();
        for (Primitive primitive : this.getPrimitives().getPrimitives()) {
            ImagePrimitive imagePrimitive = (ImagePrimitive)primitive;
            Rectangle source = imagePrimitive.getSource();
            this.m_packer.add(source.width, source.height, (Object)imagePrimitive);
        }
        this.m_packer.pack();
        Display device = Display.getCurrent();
        int tw = this.m_packer.getLength();
        int th = this.m_packer.getLength();
        ImageData textureData = new ImageData(tw, th, 24, new PaletteData(255, 65280, 0xFF0000));
        Point p = Draw3DCache.getPoint();
        try {
            for (Primitive primitive : this.getPrimitives().getPrimitives()) {
                ImagePrimitive imagePrimitive = (ImagePrimitive)primitive;
                Image image = imagePrimitive.getImage();
                Rectangle source = imagePrimitive.getSource();
                this.m_packer.getPosition((Object)imagePrimitive, p);
                this.drawImage(image, source, textureData, p);
            }
            Image textureImage = new Image((Device)device, textureData);
            this.m_textureId = this.initializeTexture(textureImage);
            textureImage.dispose();
        }
        catch (Throwable throwable) {
            Draw3DCache.returnPoint((Point[])new Point[]{p});
            throw throwable;
        }
        Draw3DCache.returnPoint((Point[])new Point[]{p});
        super.initialize(i_g3d);
    }

    private int initializeTexture(Image i_texture) {
        GL11.glPushAttrib((int)262144);
        try {
            int n;
            int w = i_texture.getBounds().width;
            int h = i_texture.getBounds().height;
            ImageConverter.ConversionSpecs specs = new ImageConverter.ConversionSpecs();
            specs.foregroundAlpha = 255;
            specs.textureWidth = w;
            specs.textureHeight = h;
            specs.clip = new org.eclipse.swt.graphics.Rectangle(0, 0, w, h);
            ColorBufferInfo info = new ColorBufferInfo(w, h, 6408, 5121, 1);
            ByteBuffer buffer = Draw3DCache.getByteBuffer((int)info.getSize());
            IntBuffer nameBuffer = Draw3DCache.getIntBuffer((int)1);
            try {
                ImageConverter converter = ImageConverter.getInstance();
                buffer = converter.imageToBuffer(i_texture, info, buffer, false);
                nameBuffer.rewind();
                GL11.glGenTextures((IntBuffer)nameBuffer);
                int id = nameBuffer.get(0);
                GL11.glEnable((int)3553);
                GL11.glBindTexture((int)3553, (int)id);
                GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)w, (int)h, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
                GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
                GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                n = id;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{nameBuffer});
                Draw3DCache.returnByteBuffer((ByteBuffer[])new ByteBuffer[]{buffer});
                throw throwable;
            }
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{nameBuffer});
            Draw3DCache.returnByteBuffer((ByteBuffer[])new ByteBuffer[]{buffer});
            return n;
        }
        finally {
            GL11.glPopAttrib();
        }
    }

    protected void prepare(Graphics3D i_g3d, ILodHelper i_lodContext) {
        GL11.glPushAttrib((int)262144);
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)this.m_textureId);
        super.prepare(i_g3d, i_lodContext);
    }

    protected void stateChanged(LwjglVBO.State i_oldState, LwjglVBO.State i_newState) {
        if (i_newState == LwjglVBO.State.READY) {
            this.m_packer = null;
        }
    }
}

