/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.event;

import java.io.Serializable;
import java.util.TooManyListenersException;
import org.ascape.model.Scape;
import org.ascape.model.event.ControlEvent;
import org.ascape.model.event.ScapeEvent;
import org.ascape.model.event.ScapeListener;

public abstract class DefaultScapeListener
implements ScapeListener,
Serializable {
    private static final long serialVersionUID = 1L;
    public Scape scape;
    protected boolean listeningToScape;
    protected String name = "Default Listener";
    private boolean notifyScapeAutomatically = true;

    public DefaultScapeListener() {
    }

    public DefaultScapeListener(String name) {
        this.name = name;
    }

    @Override
    public void scapeInitialized(ScapeEvent scapeEvent) {
    }

    @Override
    public void scapeStarted(ScapeEvent scapeEvent) {
    }

    @Override
    public void scapeStopped(ScapeEvent scapeEvent) {
    }

    @Override
    public void scapeIterated(ScapeEvent scapeEvent) {
    }

    @Override
    public void scapeSetup(ScapeEvent scapeEvent) {
    }

    @Override
    public void scapeClosing(ScapeEvent scapeEvent) {
        ((Scape)scapeEvent.getSource()).removeScapeListener(this);
    }

    @Override
    public void environmentQuiting(ScapeEvent scapeEvent) {
    }

    @Override
    public void scapeDeserialized(ScapeEvent scapeEvent) {
    }

    @Override
    public void scapeAdded(ScapeEvent scapeEvent) throws TooManyListenersException {
        if (scapeEvent == null) {
            throw new RuntimeException("Called " + this + "'s addScape with a null argument.");
        }
        if (this.listeningToScape) {
            throw new TooManyListenersException("Tried to add scape " + scapeEvent + " to view " + this + "; already listening to scape " + this.scape + ".");
        }
        this.scape = (Scape)scapeEvent.getSource();
        this.listeningToScape = true;
    }

    @Override
    public void scapeRemoved(ScapeEvent scapeEvent) {
        if (this.scape == null) {
            throw new RuntimeException("Tried to remove a scape from a delegate with no scape.");
        }
        this.listeningToScape = false;
    }

    @Override
    public void scapeNotification(ScapeEvent scapeEvent) {
        if (scapeEvent.getID() == 3) {
            this.scapeIterated(scapeEvent);
        } else if (scapeEvent.getID() == -1) {
            this.scapeSetup(scapeEvent);
        } else if (scapeEvent.getID() == -4) {
            this.scapeInitialized(scapeEvent);
        } else if (scapeEvent.getID() == 1) {
            this.scapeStarted(scapeEvent);
        } else if (scapeEvent.getID() == 2) {
            this.scapeStopped(scapeEvent);
        } else if (scapeEvent.getID() == 5) {
            this.scapeDeserialized(scapeEvent);
        } else if (scapeEvent.getID() == -2) {
            this.scapeClosing(scapeEvent);
        }
        if (this.isNotifyScapeAutomatically()) {
            this.notifyScapeUpdated();
        }
    }

    public void notifyScapeUpdated() {
        this.scape.respondControl(new ControlEvent(this, 1));
    }

    @Override
    public boolean isGraphic() {
        return false;
    }

    @Override
    public boolean isLifeOfScape() {
        return true;
    }

    @Override
    public Scape getScape() {
        return this.scape;
    }

    public boolean isNotifyScapeAutomatically() {
        return this.notifyScapeAutomatically;
    }

    public void setNotifyScapeAutomatically(boolean notifyScapeAutomatically) {
        this.notifyScapeAutomatically = notifyScapeAutomatically;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public Object clone() {
        try {
            DefaultScapeListener clone = (DefaultScapeListener)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.getName();
    }
}

