/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics.optimizer.primitive;

import java.util.Arrays;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw3d.geometry.IMatrix3f;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector2f;
import org.eclipse.draw3d.graphics.optimizer.PrimitiveBounds;
import org.eclipse.draw3d.graphics.optimizer.primitive.AbstractPrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.RenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.VertexPrimitive;
import org.eclipse.draw3d.util.Draw3DCache;

public abstract class AbstractVertexPrimitive
extends AbstractPrimitive
implements VertexPrimitive {
    private float[] m_vertices;

    private static float[] getVertices(PointList i_points) {
        float[] fArray;
        if (i_points == null) {
            throw new NullPointerException("i_points must not be null");
        }
        Point p = Draw3DCache.getPoint();
        try {
            int s = i_points.size();
            float[] vertices = new float[2 * s];
            int i = 0;
            while (i < s) {
                i_points.getPoint(p, i);
                vertices[2 * i] = p.x;
                vertices[2 * i + 1] = p.y;
                ++i;
            }
            fArray = vertices;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnPoint(p);
            throw throwable;
        }
        Draw3DCache.returnPoint(p);
        return fArray;
    }

    protected AbstractVertexPrimitive(IMatrix3f i_transformation, RenderRule i_renderRule, float[] i_vertices) {
        super(i_transformation, i_renderRule);
        if (i_vertices == null) {
            throw new NullPointerException("i_vertices must not be null");
        }
        if (i_vertices.length % 2 != 0) {
            throw new IllegalArgumentException("i_vertices must contain an even number of elements");
        }
        if (i_vertices.length < 4) {
            throw new IllegalArgumentException("i_vertices must contain at least two vertices");
        }
        if (i_transformation != null && !IMatrix3f.IDENTITY.equals(i_transformation)) {
            Vector2f v = Draw3DCache.getVector2f();
            try {
                int s = i_vertices.length / 2;
                this.m_vertices = new float[2 * s];
                int i = 0;
                while (i < s) {
                    v.set(i_vertices[2 * i], i_vertices[2 * i + 1]);
                    Math3D.transform((IVector2f)v, (IMatrix3f)i_transformation, (Vector2f)v);
                    this.m_vertices[2 * i] = v.getX();
                    this.m_vertices[2 * i + 1] = v.getY();
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector2f((Vector2f[])new Vector2f[]{v});
                throw throwable;
            }
            Draw3DCache.returnVector2f((Vector2f[])new Vector2f[]{v});
        } else {
            this.m_vertices = i_vertices;
        }
    }

    protected AbstractVertexPrimitive(IMatrix3f i_transformation, RenderRule i_renderRule, PointList i_vertices) {
        this(i_transformation, i_renderRule, AbstractVertexPrimitive.getVertices(i_vertices));
    }

    protected PrimitiveBounds calculateBounds() {
        return new PrimitiveBounds(this.m_vertices);
    }

    public int getVertexCount() {
        return this.m_vertices.length / 2;
    }

    public float[] getVertices() {
        return this.m_vertices;
    }

    public String toString() {
        return "AbstractVertexPrimitive [m_vertices=" + Arrays.toString(this.m_vertices) + "]";
    }
}

