/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.vis;

import java.util.Iterator;
import org.ascape.model.Agent;
import org.ascape.model.LocatedAgent;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Coordinate2DContinuous;
import org.ascape.util.vis.ColorFeature;
import org.ascape.util.vis.DrawFeature;
import org.ascape.view.vis.AgentView;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;

public class Overhead2DContinuousView
extends AgentView {
    private static final long serialVersionUID = -6649641939349361054L;
    private int nominalAgentSize = 5;
    private Dimension preferredSize;
    private Object[] drawFeatures;
    private boolean drawSelectedNeighbors;
    Color backgroundColor = ColorFeature.WHITE;
    public final DrawFeature agents_fill_draw_feature = new DrawFeature("Agent Fill"){
        private static final long serialVersionUID = -6961184796443185786L;

        @Override
        public void draw(Graphics g, Object object, int x, int y) {
            g.setBackgroundColor(Overhead2DContinuousView.this.agentColorFeature.getColor(object));
            g.fillOval(-x / 2, -y / 2, x, y);
        }
    };
    public final DrawFeature agents_fill_draw_inset_feature = new DrawFeature("Border Agent"){
        private static final long serialVersionUID = 3566236494167356035L;

        @Override
        public void draw(Graphics g, Object object, int x, int y) {
            g.setBackgroundColor(Overhead2DContinuousView.this.agentColorFeature.getColor(object));
            g.fillOval(-x / 2 + 2, -y / 2 + 2, x - 2, y - 2);
        }
    };

    public Overhead2DContinuousView() {
        this("Continuous Overhead 2D View");
    }

    public Overhead2DContinuousView(String name) {
        super(name);
    }

    @Override
    public void createFeatures() {
        super.createFeatures();
        this.addDrawFeature(this.agents_fill_draw_feature);
        this.agents_fill_draw_feature.setName(String.valueOf(this.getName()) + " Agents Solid");
        this.getDrawSelection().addElement((Object)this.agents_fill_draw_feature);
    }

    public void updateScapeGraphics(Graphics graphics) {
        graphics.setBackgroundColor(this.getBackgroundColor());
        graphics.fillRectangle(0, 0, this.image.getBounds().width, this.image.getBounds().height);
        this.drawFeatures = this.getDrawSelection().getSelection();
        Iterator agents = this.getScape().iterator();
        while (agents.hasNext()) {
            this.drawAgent(graphics, (LocatedAgent)agents.next(), this.scale());
        }
    }

    private double scale() {
        double viewWidth = this.getSize().width;
        double scapeWidth = ((Coordinate2DContinuous)this.getScape().getExtent()).getXValue();
        return viewWidth / scapeWidth;
    }

    private void drawAgent(Graphics graphics, LocatedAgent a, double scale) {
        Coordinate2DContinuous origin = (Coordinate2DContinuous)a.getCoordinate();
        int pixelX = (int)(scale * origin.getXValue());
        int pixelY = (int)(scale * origin.getYValue());
        graphics.translate(pixelX, pixelY);
        this.drawAgentAt(graphics, a, this.nominalAgentSize, this.nominalAgentSize);
        graphics.translate(-pixelX, -pixelY);
    }

    private void drawAgentAt(Graphics graphics, LocatedAgent agent, int x, int y) {
        Object[] objectArray = this.drawFeatures;
        int n = this.drawFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            Object drawFeature = objectArray[n2];
            ((DrawFeature)drawFeature).draw(graphics, agent, x, y);
            ++n2;
        }
    }

    public void drawAgentAt(Graphics graphics, LocatedAgent agent, int x, int y, DrawFeature feature) {
        feature.draw(graphics, agent, x, y);
    }

    public void drawAgentAtIfUpdate(Graphics graphics, LocatedAgent agent, int x, int y) {
        if (agent.isUpdateNeeded(this.getScape().getIterationsPerRedraw())) {
            Object[] objectArray = this.drawFeatures;
            int n = this.drawFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                Object drawFeature = objectArray[n2];
                ((DrawFeature)drawFeature).draw(graphics, agent, x, y);
                ++n2;
            }
        }
    }

    public Coordinate getCoordinateAtPixel(int pixelX, int pixelY) {
        double scale = this.scale();
        double transX = (double)pixelX / scale;
        double transY = (double)pixelY / scale;
        return new Coordinate2DContinuous(transX, transY);
    }

    @Override
    public Agent getAgentAtPixel(int pixelX, int pixelY) {
        return this.getScape().findNearest(this.getCoordinateAtPixel(pixelX, pixelY), null, true, Double.MAX_VALUE);
    }

    @Override
    public Dimension getPreferredSizeWithin(Dimension d) {
        int protoSize = ((LocatedAgent)this.getScape().getPrototypeAgent()).getAgentSize();
        int xAgentsPer = (int)((Coordinate2DContinuous)this.getScape().getExtent()).getXValue() / protoSize;
        int xAgentSize = d.width / xAgentsPer;
        int yAgentsPer = (int)((Coordinate2DContinuous)this.getScape().getExtent()).getYValue() / protoSize;
        int yAgentSize = d.height / yAgentsPer;
        this.nominalAgentSize = Math.max(Math.min(xAgentSize, yAgentSize), 1);
        return new Dimension(this.nominalAgentSize * xAgentsPer, this.nominalAgentSize * yAgentsPer);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public int getNominalAgentSize() {
        return this.nominalAgentSize;
    }

    public void setNominalAgentSize(int nominalAgentSize) {
        this.nominalAgentSize = nominalAgentSize;
    }

    public ColorFeature getPrimaryAgentColorFeature() {
        return this.agentColorFeature;
    }

    public void setPrimaryAgentColorFeature(ColorFeature agentColorFeature) {
        this.agentColorFeature = agentColorFeature;
    }

    @Override
    public ColorFeature getAgentColorFeature() {
        return this.agentColorFeature;
    }

    @Override
    public void setAgentColorFeature(ColorFeature agentColorFeature) {
        this.agentColorFeature = agentColorFeature;
    }

    @Override
    public synchronized void drawSelectedAgent(Graphics g, LocatedAgent a) {
        Coordinate2DContinuous origin = (Coordinate2DContinuous)a.getCoordinate();
        double scale = this.scale();
        int pixelX = (int)(scale * origin.getXValue());
        int pixelY = (int)(scale * origin.getYValue());
        g.translate(pixelX - (a.getAgentSize() / 2 + 8), pixelY - (a.getAgentSize() / 2 + 8));
        g.setForegroundColor((Color)a.getPlatformColor());
        g.drawOval(0, 0, a.getAgentSize() + 16, a.getAgentSize() + 16);
        g.setForegroundColor(ColorFeature.HIGHLIGHT_AGENT_COLOR);
        g.translate(2, 2);
        g.drawOval(0, 0, a.getAgentSize() + 12, a.getAgentSize() + 12);
        g.translate(-pixelX + a.getAgentSize() / 2 + 6, -pixelY + a.getAgentSize() / 2 + 6);
    }

    public boolean isDrawSelectedNeighbors() {
        return this.drawSelectedNeighbors;
    }

    public void setDrawSelectedNeighbors(boolean drawSelectedNeighbors) {
        this.drawSelectedNeighbors = drawSelectedNeighbors;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

