/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.editpolicies;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef3d.editpolicies.FeedbackHelper3D;
import org.eclipse.gef3d.handles.FeedbackFigure3D;
import org.eclipse.gef3d.handles.MoveHandle3DFactory;
import org.eclipse.gef3d.handles.NonResizableHandle3DFactory;
import org.eclipse.gef3d.handles.ResizableHandle3DFactory;

public class ResizableEditPolicy3D
extends ResizableEditPolicy {
    private static final Logger log = Logger.getLogger(ResizableEditPolicy3D.class.getName());
    private FeedbackHelper3D m_helper;

    protected IFigure createDragSourceFeedbackFigure() {
        if (Figure3DHelper.getAncestor3D((IFigure)this.getHostFigure()) == null) {
            return super.createDragSourceFeedbackFigure();
        }
        FeedbackFigure3D feedback = new FeedbackFigure3D();
        this.getFeedbackHelper().setInitialFeedbackPosition((IFigure3D)feedback);
        this.addFeedback((IFigure)feedback);
        return feedback;
    }

    protected FeedbackHelper3D createFeedbackHelper() {
        return new FeedbackHelper3D();
    }

    protected List createSelectionHandles() {
        if (Figure3DHelper.getAncestor3D((IFigure)this.getHostFigure()) == null) {
            return super.createSelectionHandles();
        }
        NonResizableHandle3DFactory nonResizableHF = NonResizableHandle3DFactory.INSTANCE;
        ResizableHandle3DFactory resizableHF = ResizableHandle3DFactory.INSTANCE;
        MoveHandle3DFactory moveHF = MoveHandle3DFactory.INSTANCE;
        int directions = this.getResizeDirections();
        ArrayList<Handle> list = new ArrayList<Handle>();
        GraphicalEditPart host = (GraphicalEditPart)this.getHost();
        if (directions == 0) {
            nonResizableHF.addHandles(host, list);
        } else if (directions != -1) {
            moveHF.addHandles(host, list);
            if ((directions & 0x10) != 0) {
                resizableHF.addHandle(host, list, 16);
            } else {
                nonResizableHF.addHandle(host, list, 16);
            }
            if ((directions & 0x14) == 20) {
                resizableHF.addHandle(host, list, 20);
            } else {
                nonResizableHF.addHandle(host, list, 20);
            }
            if ((directions & 4) != 0) {
                resizableHF.addHandle(host, list, 4);
            } else {
                nonResizableHF.addHandle(host, list, 4);
            }
            if ((directions & 0xC) == 12) {
                resizableHF.addHandle(host, list, 12);
            } else {
                nonResizableHF.addHandle(host, list, 12);
            }
            if ((directions & 8) != 0) {
                resizableHF.addHandle(host, list, 8);
            } else {
                nonResizableHF.addHandle(host, list, 8);
            }
            if ((directions & 9) == 9) {
                resizableHF.addHandle(host, list, 9);
            } else {
                nonResizableHF.addHandle(host, list, 9);
            }
            if ((directions & 1) != 0) {
                resizableHF.addHandle(host, list, 1);
            } else {
                nonResizableHF.addHandle(host, list, 1);
            }
            if ((directions & 0x11) == 17) {
                resizableHF.addHandle(host, list, 17);
            } else {
                nonResizableHF.addHandle(host, list, 17);
            }
        } else {
            resizableHF.addHandles(host, list);
        }
        return list;
    }

    protected FeedbackHelper3D getFeedbackHelper() {
        if (this.m_helper == null) {
            this.m_helper = this.createFeedbackHelper();
        }
        this.m_helper.setHostFigure(this.getHostFigure());
        return this.m_helper;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        IFigure feedback = this.getDragSourceFeedbackFigure();
        if (!(feedback instanceof IFigure3D)) {
            super.showChangeBoundsFeedback(request);
        } else {
            IFigure3D feedback3D = (IFigure3D)feedback;
            this.getFeedbackHelper().setInitialFeedbackPosition(feedback3D);
            this.getFeedbackHelper().updateFeedbackPosition(feedback3D, request.getMoveDelta(), request.getSizeDelta());
        }
    }
}

