/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.amp.agf.chart.BasicChartStrategy;
import org.eclipse.amp.agf.chart.IDataProvider;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;

public class HistogramStrategy
extends BasicChartStrategy {
    private SeriesDefinition xSeriesDefinition;
    private SeriesDefinition valueDefinition;
    List<List<Double>> numbersLists = new ArrayList<List<Double>>();
    List<List<String>> labelsLists = new ArrayList<List<String>>();

    public Chart createChart(IDataProvider dataProvider, Object dataSource) {
        this.dataProvider = dataProvider;
        this.dataSource = dataSource;
        ChartWithAxes chart = ChartWithAxesImpl.create();
        chart.setType("Bar Chart");
        chart.setSubType("Stacked");
        chart.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        chart.getBlock().getOutline().setVisible(true);
        Plot p = chart.getPlot();
        p.getClientArea().setBackground((Fill)ColorDefinitionImpl.WHITE());
        p.setBackground((Fill)ColorDefinitionImpl.WHITE());
        for (Block block : p.getChildren()) {
            block.setBackground((Fill)ColorDefinitionImpl.WHITE());
        }
        Axis xAxisPrimary = chart.getPrimaryBaseAxes()[0];
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.MIN_LITERAL);
        xAxisPrimary.setCategoryAxis(true);
        Axis yAxisPrimary = chart.getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getLabel().getCaption().getFont().setRotation(90.0);
        this.xSeriesDefinition = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)this.xSeriesDefinition);
        this.xSeriesDefinition.getSeriesPalette().shift(0);
        this.valueDefinition = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)this.valueDefinition);
        return chart;
    }

    public void update() {
        int index = 0;
        for (Object valueSet : this.dataProvider.getValueSets(this.dataSource)) {
            List values = (List)this.dataProvider.getValues(valueSet);
            this.numbersLists.get(index).set(0, (Double)values.get(values.size() - 1));
            String text = this.dataProvider.getText(valueSet);
            this.labelsLists.get(index++).set(0, text);
        }
    }

    public void updateSelection() {
        this.valueDefinition.getSeries().clear();
        this.xSeriesDefinition.getSeries().clear();
        this.numbersLists = new ArrayList<List<Double>>();
        this.labelsLists = new ArrayList<List<String>>();
        for (Object valueSet : this.dataProvider.getValueSets(this.dataSource)) {
            Double number = 0.0;
            ArrayList<Double> valueList = new ArrayList<Double>();
            valueList.add(number);
            NumberDataSet numberSet = NumberDataSetImpl.create(valueList);
            this.numbersLists.add(valueList);
            BarSeries valueSeries = (BarSeries)BarSeriesImpl.create();
            valueSeries.setDataSet((DataSet)numberSet);
            valueSeries.getLabel().setVisible(true);
            valueSeries.setLabelPosition(Position.INSIDE_LITERAL);
            this.valueDefinition.getSeries().add((Object)valueSeries);
            String text = this.dataProvider.getText(valueSet);
            valueSeries.setSeriesIdentifier((Object)text);
            ArrayList<String> labelList = new ArrayList<String>();
            labelList.add("");
            TextDataSet labelSet = TextDataSetImpl.create(labelList);
            this.labelsLists.add(labelList);
            Series labelSeries = SeriesImpl.create();
            labelSeries.setDataSet((DataSet)labelSet);
            this.xSeriesDefinition.getSeries().add((Object)labelSeries);
        }
    }

    public void createLegend() {
        super.createLegend();
        this.getLegend().setItemType(LegendItemType.CATEGORIES_LITERAL);
    }

    public boolean isInitialized() {
        return this.xSeriesDefinition.getSeries().size() > 0;
    }

    public SeriesDefinition getValueSetsDefinition() {
        return this.valueDefinition;
    }
}

