/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometryext;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.geometry.AbstractPosition3D;
import org.eclipse.draw3d.geometry.IBoundingBox;
import org.eclipse.draw3d.geometry.IHost3D;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.geometryext.SyncHost3D;
import org.eclipse.draw3d.geometryext.SyncedBounds3D;

public class SynchronizedPosition3DImpl
extends AbstractPosition3D {
    private SyncedBounds3D bounds3D;
    private SyncHost3D host;

    public SynchronizedPosition3DImpl(SyncHost3D i_syncHost) {
        if (i_syncHost == null) {
            throw new NullPointerException("i_syncHost must not be null");
        }
        this.host = i_syncHost;
        this.bounds3D = new SyncedBounds3D();
        this.bounds3D.setDepth(1.0f);
        this.m_rotationAngles = new Vector3fImpl(0.0f, 0.0f, 0.0f);
        this.m_updatingBounds = false;
    }

    public IBoundingBox getBounds3D() {
        return this.bounds3D.getBoundingBox(this.host.getBounds());
    }

    public IHost3D getHost() {
        return this.host;
    }

    public IVector3f getLocation3D() {
        return this.bounds3D.getLocation3D(this.host.getBounds());
    }

    public IVector3f getSize3D() {
        return this.bounds3D.getSize3D(this.host.getBounds());
    }

    public void setLocation3D(IVector3f i_point) {
        if (i_point == null) {
            throw new NullPointerException("i_point must not be null");
        }
        if (this.getLocation3D().equals(i_point)) {
            return;
        }
        Vector3fImpl delta = new Vector3fImpl();
        Math3D.sub((IVector3f)i_point, (IVector3f)this.getLocation3D(), (Vector3f)delta);
        Rectangle newBounds = this.bounds3D.setBounds3D(i_point, this.getSize3D());
        if (delta.x != 0.0f || delta.y != 0.0f) {
            this.host.setBounds(newBounds);
        }
        this.invalidate();
        this.firePositionChanged(IPosition3D.PositionHint.LOCATION, (IVector3f)delta);
    }

    public void setSize3D(IVector3f i_size) {
        if (i_size == null) {
            throw new NullPointerException("i_size must not be null");
        }
        IVector3f size3D = this.getSize3D();
        if (size3D.equals(i_size)) {
            return;
        }
        Vector3fImpl delta = new Vector3fImpl();
        Math3D.sub((IVector3f)i_size, (IVector3f)size3D, (Vector3f)delta);
        Rectangle newBounds = this.bounds3D.setBounds3D(this.getLocation3D(), i_size);
        if (delta.x != 0.0f || delta.y != 0.0f) {
            this.host.setBounds(newBounds);
        }
        this.invalidate();
        this.firePositionChanged(IPosition3D.PositionHint.SIZE, (IVector3f)delta);
    }
}

