/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.texture;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw3d.graphics3d.lwjgl.texture.AbstractLwjglTexture;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.draw3d.util.converter.ColorBufferInfo;
import org.eclipse.draw3d.util.converter.ImageConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.lwjgl.opengl.GL11;

public class LwjglTextureSwt
extends AbstractLwjglTexture {
    private int m_clearAlpha;
    private GC m_gc;
    private int m_glTexture = 0;
    protected SWTGraphics m_graphics;
    private Image m_image;
    private ColorBufferInfo m_info;
    private ByteBuffer m_textureBuffer;
    private final Color m_transparentColor = new Color((Device)Display.getCurrent(), 153, 153, 153);
    private boolean m_uploadTexture;

    public LwjglTextureSwt(int i_width, int i_height) {
        this.m_info = new ColorBufferInfo(i_width, i_height, 6408, 5121, 1);
    }

    public void activate() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        if (!this.m_valid) {
            this.deleteGraphics();
            this.createGraphics();
            this.m_valid = true;
        }
    }

    public void clear(Color i_color, int i_alpha) {
        if (i_alpha != this.m_clearAlpha) {
            this.m_clearAlpha = i_alpha;
            this.deleteGraphics();
            this.createGraphics();
        }
        this.m_graphics.pushState();
        try {
            this.m_graphics.setBackgroundColor(i_color);
            this.m_graphics.fillRectangle(0, 0, this.m_info.getWidth(), this.m_info.getHeight());
        }
        finally {
            this.m_graphics.popState();
        }
    }

    private void createGraphics() {
        int width = this.m_info.getWidth();
        int height = this.m_info.getHeight();
        int size = width * height;
        byte[] data = new byte[size * 3];
        PaletteData pal = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(width, height, 24, pal, 1, data);
        imageData.alphaData = new byte[size];
        Arrays.fill(imageData.alphaData, (byte)this.m_clearAlpha);
        this.m_image = new Image((Device)Display.getCurrent(), imageData);
        this.m_gc = new GC((Drawable)this.m_image);
        this.m_graphics = new SWTGraphics(this.m_gc);
        this.m_graphics.setAlpha(255);
    }

    private void createTexture() {
        IntBuffer buffer = Draw3DCache.getIntBuffer((int)1);
        try {
            buffer.rewind();
            GL11.glGenTextures((IntBuffer)buffer);
            this.m_glTexture = buffer.get(0);
            GL11.glBindTexture((int)3553, (int)this.m_glTexture);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.m_info.getWidth(), (int)this.m_info.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)this.m_textureBuffer);
            GL11.glBindTexture((int)3553, (int)0);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
            throw throwable;
        }
        Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
    }

    public void deactivate() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        this.m_uploadTexture = true;
    }

    private void deleteGraphics() {
        if (this.m_image != null) {
            this.m_image.dispose();
        }
        if (this.m_gc != null) {
            this.m_gc.dispose();
        }
        if (this.m_graphics != null) {
            this.m_graphics.dispose();
        }
    }

    private void deleteTexture() {
        if (this.m_glTexture > 0) {
            IntBuffer buffer = Draw3DCache.getIntBuffer((int)1);
            try {
                buffer.rewind();
                buffer.put(this.m_glTexture);
                GL11.glDeleteTextures((IntBuffer)buffer);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
                throw throwable;
            }
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
        }
    }

    public void dispose() {
        if (this.m_disposed) {
            return;
        }
        this.deleteGraphics();
        this.deleteTexture();
        this.m_transparentColor.dispose();
        this.m_disposed = true;
    }

    public Graphics getGraphics() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        if (!this.m_valid) {
            throw new IllegalStateException("texture not valid");
        }
        if (this.m_graphics == null) {
            throw new IllegalStateException("texture not initialized");
        }
        return this.m_graphics;
    }

    public int getTextureId() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        if (this.m_uploadTexture) {
            ImageConverter converter = ImageConverter.getInstance();
            this.m_textureBuffer = converter.imageToBuffer(this.m_image, this.m_info, this.m_textureBuffer, true);
            this.deleteTexture();
            this.createTexture();
            this.m_uploadTexture = false;
        }
        return this.m_glTexture;
    }

    public void setDimensions(int i_width, int i_height) {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        if (i_width <= 0 || i_height <= 0) {
            throw new IllegalArgumentException("texture dimensions must not be negative");
        }
        if (this.m_info.getWidth() != i_width || this.m_info.getHeight() != i_height) {
            this.m_valid = false;
            this.m_info = new ColorBufferInfo(i_width, i_height, this.m_info.getPixelFormat(), this.m_info.getDataType(), this.m_info.getAlignment());
        }
    }
}

