/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.runtime.impl.namespace.workspace;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.ide.runtime.namespace.workspace.IWorkspaceQualifiedNameResolverFactory;
import org.eclipse.acceleo.query.ide.runtime.namespace.workspace.IWorkspaceResolverFactoryDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;

public class WorkspaceResolverFactoryRegistryListener
implements IRegistryEventListener {
    public static final String CLASS = "class";
    public static final String CLASS_PROVIDER_EXTENSION_POINT = "org.eclipse.acceleo.query.ide.workspaceresolverfactory";
    public static final String CLASS_PROVIDER_TAG_EXTENSION = "workspaceresolverfactory";
    public static final String CLASS_PROVIDER_ATTRIBUTE_CLASS = "class";
    private final Map<String, IWorkspaceResolverFactoryDescriptor> descriptors = new HashMap<String, IWorkspaceResolverFactoryDescriptor>();

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (CLASS_PROVIDER_EXTENSION_POINT.equals(extension.getUniqueIdentifier())) {
                this.parseClassProviderExtension(extension);
            }
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(CLASS_PROVIDER_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseClassProviderExtension(extension);
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkspaceResolverFactoryDescriptor descriptor;
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (CLASS_PROVIDER_TAG_EXTENSION.equals(element.getName()) && (descriptor = this.descriptors.remove(element.getAttribute("class"))) != null) {
                    QueryPlugin.unregisterWorkspaceResolverFactory(descriptor);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    private void parseClassProviderExtension(IExtension extension) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (CLASS_PROVIDER_TAG_EXTENSION.equals(element.getName())) {
                ResolverFactoryDescriptor descriptor = new ResolverFactoryDescriptor(element);
                this.descriptors.put(element.getAttribute("class"), descriptor);
                QueryPlugin.registerWorkspaceResolverFactory(descriptor);
            }
            ++n2;
        }
    }

    public static class ResolverFactoryDescriptor
    implements IWorkspaceResolverFactoryDescriptor {
        private final IConfigurationElement element;
        private IWorkspaceQualifiedNameResolverFactory factory;

        public ResolverFactoryDescriptor(IConfigurationElement element) {
            this.element = element;
        }

        @Override
        public IWorkspaceQualifiedNameResolverFactory getFactory() {
            if (this.factory == null) {
                try {
                    this.factory = (IWorkspaceQualifiedNameResolverFactory)this.element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    QueryPlugin.log((Exception)((Object)e), false);
                }
            }
            return this.factory;
        }
    }
}

