/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.migration.converters;

import java.util.Collections;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

final class ServiceWithNoParameterMethodRefactorVisitor
extends ASTVisitor {
    private final IDocument document;
    private final String serviceName;

    ServiceWithNoParameterMethodRefactorVisitor(IDocument document, String serviceName) {
        this.document = document;
        this.serviceName = serviceName;
    }

    public boolean visit(MethodDeclaration method) {
        if (method.getName().getIdentifier().equals(this.serviceName) && method.parameters().isEmpty() && !this.newMethodExists(method)) {
            ExpressionStatement statement;
            ASTRewrite rewrite = ASTRewrite.create((AST)method.getAST());
            MethodDeclaration newMethod = method.getAST().newMethodDeclaration();
            for (Object modifier : method.modifiers()) {
                newMethod.modifiers().add(rewrite.createCopyTarget((ASTNode)modifier));
            }
            newMethod.setReturnType2((Type)rewrite.createCopyTarget((ASTNode)method.getReturnType2()));
            newMethod.setName(newMethod.getAST().newSimpleName(this.serviceName + "JavaService"));
            SingleVariableDeclaration parameter = newMethod.getAST().newSingleVariableDeclaration();
            parameter.setName(newMethod.getAST().newSimpleName("object"));
            parameter.setType((Type)newMethod.getAST().newSimpleType(newMethod.getAST().newName("Object")));
            newMethod.parameters().add(parameter);
            Block body = newMethod.getAST().newBlock();
            MethodInvocation methodInvocation = newMethod.getAST().newMethodInvocation();
            methodInvocation.setName(newMethod.getAST().newSimpleName(this.serviceName));
            if (method.getReturnType2() != null && !"void".equals(method.getReturnType2().toString())) {
                ReturnStatement returnStatement = newMethod.getAST().newReturnStatement();
                returnStatement.setExpression((Expression)methodInvocation);
                statement = returnStatement;
            } else {
                ExpressionStatement expressionStatement;
                statement = expressionStatement = newMethod.getAST().newExpressionStatement((Expression)methodInvocation);
            }
            body.statements().add(statement);
            newMethod.setBody(body);
            TypeDeclaration typeDeclaration = (TypeDeclaration)method.getParent();
            ListRewrite declarations = rewrite.getListRewrite((ASTNode)typeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            declarations.insertAfter((ASTNode)newMethod, (ASTNode)method, null);
            try {
                TextEdit edit = rewrite.rewriteAST(this.document, Collections.EMPTY_MAP);
                edit.apply(this.document);
            }
            catch (IllegalArgumentException | BadLocationException | MalformedTreeException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean newMethodExists(MethodDeclaration method) {
        boolean res = false;
        String newMethodName = this.serviceName + "JavaService";
        TypeDeclaration typeDeclaration = (TypeDeclaration)method.getParent();
        MethodDeclaration[] methodDeclarationArray = typeDeclaration.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            if (newMethodName.equals(methodDeclaration.getName().getIdentifier()) && methodDeclaration.parameters().size() == 1 && "Object".equals(((SingleVariableDeclaration)methodDeclaration.parameters().get(0)).getType().toString())) {
                res = true;
                break;
            }
            ++n2;
        }
        return res;
    }
}

