/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.common;

import java.lang.reflect.Array;
import java.util.Objects;
import java.util.Set;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.ExpressionStatement;
import org.eclipse.acceleo.FileStatement;
import org.eclipse.acceleo.ForStatement;
import org.eclipse.acceleo.IfStatement;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.util.AcceleoSwitch;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.SymbolKind;

public class AcceleoAstNodeToSymbolKind
extends AcceleoSwitch<SymbolKind> {
    private final IAcceleoValidationResult acceleoValidationResult;

    public AcceleoAstNodeToSymbolKind(IAcceleoValidationResult acceleoValidationResult) {
        this.acceleoValidationResult = Objects.requireNonNull(acceleoValidationResult);
    }

    public SymbolKind defaultCase(EObject object) {
        return SymbolKind.Null;
    }

    public SymbolKind caseBinding(Binding binding) {
        return (SymbolKind)this.doSwitch((EObject)binding.getInitExpression());
    }

    public SymbolKind caseExpressionStatement(ExpressionStatement expressionStatement) {
        return (SymbolKind)this.doSwitch((EObject)expressionStatement.getExpression());
    }

    public SymbolKind caseExpression(Expression expression) {
        IValidationResult expressionValidationResult = this.acceleoValidationResult.getValidationResult(expression.getAst());
        Set possibleTypes = expressionValidationResult.getPossibleTypes(expression.getAst().getAst());
        return this.getSymbolKindFor(possibleTypes);
    }

    public SymbolKind caseVariable(Variable variable) {
        return SymbolKind.Property;
    }

    private SymbolKind getSymbolKindFor(Set<IType> possibleTypes) {
        SymbolKind res;
        if (possibleTypes == null || possibleTypes.isEmpty()) {
            res = SymbolKind.Object;
        } else {
            IType type = possibleTypes.iterator().next();
            res = this.getSymbolKindFor(type);
        }
        return res;
    }

    private SymbolKind getSymbolKindFor(IType type) {
        SymbolKind res;
        Object javaClassOrEClass = type.getType();
        if (javaClassOrEClass instanceof Class) {
            res = this.getSymbolKindFor((Class)javaClassOrEClass);
        } else if (javaClassOrEClass instanceof EClass) {
            res = this.getSymbolKindFor((EClass)javaClassOrEClass);
        } else {
            throw new IllegalArgumentException("Unexpected 'type' Object in " + type.toString() + ": " + javaClassOrEClass.toString() + " is neither a Java class nor an EClass instance.");
        }
        return res;
    }

    private SymbolKind getSymbolKindFor(EClass eClass) {
        return this.getSymbolKindFor(eClass.getInstanceClass());
    }

    private SymbolKind getSymbolKindFor(Class<?> javaClass) {
        SymbolKind symbolKind = String.class.isAssignableFrom(javaClass) ? SymbolKind.String : (Number.class.isAssignableFrom(javaClass) ? SymbolKind.Number : (Boolean.class.isAssignableFrom(javaClass) ? SymbolKind.Boolean : (Array.class.isAssignableFrom(javaClass) ? SymbolKind.Array : (Enum.class.isAssignableFrom(javaClass) ? SymbolKind.EnumMember : SymbolKind.Object))));
        return symbolKind;
    }

    public SymbolKind caseForStatement(ForStatement object) {
        return SymbolKind.Operator;
    }

    public SymbolKind caseIfStatement(IfStatement object) {
        return SymbolKind.Operator;
    }

    public SymbolKind caseLetStatement(LetStatement letStatement) {
        return SymbolKind.Operator;
    }

    public SymbolKind caseModule(Module object) {
        return SymbolKind.Module;
    }

    public SymbolKind caseImport(Import object) {
        return SymbolKind.Property;
    }

    public SymbolKind caseFileStatement(FileStatement object) {
        return SymbolKind.File;
    }

    public SymbolKind caseMetamodel(Metamodel object) {
        return SymbolKind.Method;
    }

    public SymbolKind caseQuery(Query object) {
        return SymbolKind.Function;
    }

    public SymbolKind caseTemplate(Template object) {
        return SymbolKind.String;
    }

    public SymbolKind caseBlock(Block object) {
        return SymbolKind.Struct;
    }
}

