/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.wizards;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.wizards.CreateThemeAssociationWizardPage;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.osgi.service.prefs.BackingStoreException;

public final class CreateThemeAssociationWizard
extends Wizard {
    private final IThemeManager.EditSession themeManager;
    private final boolean saveOnFinish;
    private CreateThemeAssociationWizardPage mainPage = (CreateThemeAssociationWizardPage)((Object)NullSafetyHelper.lazyNonNull());
    private @Nullable IThemeAssociation createdThemeAssociation;
    private @Nullable IGrammarDefinition initialDefinition;
    private @Nullable IThemeAssociation initialAssociation;

    public CreateThemeAssociationWizard(IThemeManager.EditSession themeManager, boolean saveOnFinish) {
        this.themeManager = themeManager;
        this.saveOnFinish = saveOnFinish;
    }

    public void addPages() {
        this.mainPage = new CreateThemeAssociationWizardPage(this.initialDefinition, this.initialAssociation);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        IThemeAssociation association = this.mainPage.getThemeAssociation();
        this.themeManager.registerThemeAssociation(association);
        if (this.saveOnFinish) {
            try {
                this.themeManager.save();
            }
            catch (BackingStoreException ex) {
                TMUIPlugin.logError((Exception)((Object)ex));
                return false;
            }
        }
        this.createdThemeAssociation = association;
        return true;
    }

    public @Nullable IThemeAssociation getCreatedThemeAssociation() {
        return this.createdThemeAssociation;
    }

    public void setInitialDefinition(@Nullable IGrammarDefinition definition) {
        this.initialDefinition = definition;
    }

    public void setInitialAssociation(@Nullable IThemeAssociation association) {
        this.initialAssociation = association;
    }
}

