#!/bin/awk -f 

#
#    REFERENCES -- bibliographic software
#    Copyright (C) 1995-2006  Volker Kiefel
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#    USA
#

#
#    refs_srl.awk -- create a macro for converting citations in the search and
#    replace function of References
#    
#    Usage:
#
#       awk [-v output_file=NameOfOutputFile.txt] -f refs_sr.awk textfile
#
#    Versions:
#    31.7.2005: name of `outfle' may be changed (for References v4.2)
#
#

BEGIN {
  a = ""
  if (!output_file)
  {
    outfle = "rc-mak.sr"
  } else
  {
    outfle=output_file
  }
}
{
  a = $0;
  gsub(/\/\/\/A\/\/\//,"|",a) 
  gsub(/\/\/\/B\/\/\//,"|",a)
  gsub(/\/\/\/C\/\/\//,"|",a)
  print a > outfle
}

END {
  print "\nSearch and replace script for References (" outfle ") created\n"
  close(outfle)
}

