# Changelog

- the x.y.z is the version of the source code which follows semantic versioning
- the combination of version and version date designates the version of the package as it is uploaded to CTAN

# Changes

## 2025-06-01 (3.3.0)

### Added

- IMPORTANT: No external programs required any longer, i.e.
  - pdf checking done internally, i.e. `pdfinfo` no longer required
  - changing permissions done internally, i.e. `chmod` no longer required
- binaries are now available for Linux, macOS x86\*64 and macOS aarch64
  - see https://codeberg.org/ManfredLotz/pkgcheck/releases
- now both, Debian and RPM packages, are available in directory packages/
  - see https://codeberg.org/ManfredLotz/pkgcheck/releases
- when checking binaries recognize Mach-O binaries with universal header

### Changed

- now consistently checking if a file is a script by strictly looking for a shebang
- move repository to codeberg

### Removed

- remove error messages which are environmental and not related to the
  content of the package upload. These are E0033, F0001, ..., F0010

## 2024-06-11 (3.2.0)

### Added

- add generation of completion support for nushell
- add a new warning message W0011 if a file in the package tree
  has a future modification time
- add Thumbs.db as temporary file
- (Experimental) for l3backend-dev and l3kernel-dev use the real directory name
  latex-dev/l3backend resp. latex-dev/l3kernel when checking path names in the
  TDS archive
- new E0042 error when there are filenames with different letter cases in a TDS archive
- new E0043 error when a symlink is found in the TDS archive

### Changed

- small improvement in src/recode.rs due to clippy suggestions
- small code reorganization in check_tds_archive()
- crates update

## 2022-12-26 (3.1.0)

### Added

- now checking for hard links which generate a warning message
- new message w0010: now hardlinks are detected and reported
- add armtex to exception list when checking path names in the TDS zip archive
- add latex-cyrillic to exception list when checking path names in the TDS zip archive

### Changed

- typo in F010 message

## 2022-05-26 (3.0.0)

### Added

- fatal messages Fnnnn go to stderr instead of stdout
- add generation of shell completion support for various shells,
  which are bash, elvish, fish, powershell, zsh
- now a config file can be specified
  - currently only exceptions can be specified when checking
    the paths of files in the TDS archive
- new messages F0008, F0009 and F0010 regarding reading config file
- new message I0008 to tell which config file is used
- new messages I0009, W0009 giving more information about config file
  usage (only if --verbose is given)
- enhance documentation

### Changed

- (devel) reformatting source code
- (devel) using clap with derive feature instead of structopt-derive
- reorganized this changelog
- in w0002 output remove empty line at end
- don't complain if filename contains `@` , `=`, or `:` characters. These
  characters are not recommended to be used but there could be a necessity.

## 2022-01-15 (2.4.0)

### Changed

- for latex-lab and latex-lab-dev use the real directory name 'latex' resp.
  'latex-dev' when checking path names in the TDS zip archive

## 2022-01-02

### Added

- add .xray to temporary file endings
- (experimental) when URL checking decode some html entities if they appear in URLs

### Changed

- switch to Rust edition 2021
- switch from blake2 to blake3 library for checksumming
- unzipping now done internally. /usr/bin/unzip no longer required

## 2021-10-03 (2.3.0)

### Added

- add temporary file endings .hd and tpt (pointed to by Karl Berry)
- add option `--ignore-same-named` to ignore same named files
- add `.lua` to file endings recognized as scripts
- add latex-firstaid-dev to exceptions when checking paths in the TDS archive

### Changed

- if a URL ends with '。', which is an ideographic full stop (U+3002), remove that character
- ignore if generated files with ending .html or .css exist (merge request from Vít Novotný).
  Reason is that documentation could also exist as html.
- some code simplifications most of them by clippy recommendations

## 2020-11-20 (2.2.0)

### Added

- (Experimental) instead of latex-firstaid use latex/firstaid when checking path names
  in TDS zip archive
- new error message e0039: no doc/ top level directory in tds zip archive
- new error message e0040: too few top level directories in tds zip archive
- new error message e0041: map file found in path not starting with `fonts/map/dvips`
- add more test cases

### Changed

- small code changes due to new release of blake2 library
- replace deprecated tempdir crate by tempfile crate
- revive e0020 which checks for unwanted directories in the top level directory of a TDS zip
  archive.

### Fixed

- unpack TDS zip without -a flag which was introduced in 2.0.1. According to Petra this creates
  more problems than it solves

## 2020-04-12 (2.1.0)

### Added

- add new test case e0033

### Changed

- improvements regarding detection of generated files (error message e0019)
  - generated REAME files caused e0019 error message when they were specified with
    a relative path name in the `\generate` statement in the .dtx resp. .ins file
  - don't issue error message when a pdf file, generated by .dtx/.ins, exists
  - don't issue error message when an existing .ins file is generated by a .dtx file
  - improved text in error message e0019

### Fixed

- don't issue error messages when a .bat file has 0755 permission
- call pdfinfo and unzip without specifying an absolute path so that it gets found
  when it is outside of /usr/bin (reported by Arthur Reutenauer)

## 2020-02-07 (2.0.1)

### Changed

- use the `-a` (convert text files) flag when temporarily unzipping the TDS archive
- crates update

## 2020-01-17 (2.0.0)

### Added

- more error checking in TDS zip archives
  - detecting if a .dtx or .ins file is not in a subdirectory of source/ or doc/ toplevel directories (E0036)
  - detecting empty directories (W0007)
  - detecting hidden directories (E0006)
  - detecting temporary files (E0008)
    - as a special case tex/latex/tools/.tex is allowed for package latex-tools. The
      same applies for latex-tools-dev package

### Changed

- revamped handling of line ending checks
  - reporting if a file has CR line endings only (E0037)
  - reporting if a file has inconsistent line endings (E0038)
  - reporting if a Windows file does not have Windows (CRLF) line endings (W0008)
    - a file is regarded a Windows file if its name ends with one of .bat, .cmd, .nsh or .reg
  - files with CR, or CRLF line endings will be corrected to LF
  - but windows files will be corrected to CRLF line endings
  - when correcting line endings a line ending at the end of a file will be added if required
  - renamed command line switch
    - old: -L, --correct-crlf Correct CRLF line endings
    - new: -L, --correct-le Correct line endings
- other changes
  - new message F0007 when tmp directory is not writable or the tmp directory is full
  - some code simplifications
  - crates update
  - when detecting an empty file also permissions will be checked and (if requested) corrected
  - (Experimental) for latex-base-dev, latex-tools-dev, latex-graphics-dev and latex-amsmath-dev
    check for latex-dev in the path names in the TDS zip archive
  - if a file in a generated file statement contains a directory part it was correctly
    recognized but not compared correctly to the contents of the TDS zip archive

## 2019-11-28 (1.10.0)

### Added

- more checks for a TDS zip archive
  - check for temporary files or directories

### Changed

- remove message E0020 to report unwanted top level directory in a TDS zip archive

## 2019-11-27 (1.9.1)

### Added

- recognize .bat files as script type
- add test case for .bat file recognition

### 2019-11-04 (1.9.0)

### Added

- (Experimental) for latex-base, latex-tools, latex-graphics and latex-amsmath use the real
  directory name 'latex' when checking path names in the TDS zip archive
- New error message e0035 if a TDS zip archive is found in the unpacked directory tree
- add testcases for w0005, w0006 and e0035

## 2019-10-01 (1.8.3)

### Added

- (Experimental) issue warning if a file in the package tree (W0005) or in the TDS zip archive (W0006) is
  larger than 40MiB
- (Experimental) for babel-base.tds.zip use the real package name 'babel' (instead of 'babel-base') in order
  to check if the path name contains the package name

  Both features are regarded as experimental because both contain a hard coded check. If required
  things will be changed in the future.

## 2019-08-07 (1.8.2)

### Changed

- updating crates, requiring slight code changes in integration.rs
- ignore windows files .nsh and .reg when checking for LF line endings

### Added

- new error message e0034 for unwanted files in top level directory of a TDS zip archive
- e0020 now reporting only unwanted directory in top level directory of a TDS zip archive

## 2019-07-21 (1.8.1)

### Fixed

- correct typo in e0008 message text

## 2019-07-20 (1.8.0)

### Added

- add a check to detect temporary files in the TDS zip archive

## 2019-06-30 (1.7.0)

### Changed

- compiled with rust edition 2018
- if a found http(s) link ends with "`" then the trailing "`" will be discarded

### Fixed

- improved error message e0025 now displaying the paths of the affected
  files/directories/symlinks
- when symlinks occur in e0025 they are reported as files

## 2019-03-29 (1.6.0)

### Changed

- new error message e0031 when a filename contains invalid UTF-8 characters

## 2019-03-14 (1.5.0)

### Changed

- if a symlink points to a file object outside of the package directory tree error message
  e0030 will be issued

### Fixed

- a README can be a symlink which will now be detected properly

## 2019-03-11 (1.4.0)

### Added

- recognizing generated files in a .dtx file when they are included using a
  filecontents resp. filecontents\* environment.

## 2019-03-09 (1.3.0)

### Changed

- checking URLs
  - when checking URLs we try to get the headers first. If this fails we try to get the web page.
  - when checking URLs and a redirect has an invalid location containing 127.0.0.1
    then we regard the url as ok
- ignoring .tfm files when checking for duplicates
- now checking for UTF BOMs. If a README file contains a BOM we issue an error message,
  if other files contain BOMs we issue a warning message
- recompile with newest http library

## 2019-01-02 (1.2.0)

### Added

- add test cases for messages e0026, e0028
- **New feature**: checks that path names in the TDS zip archive contain the package name
  (only exception is a man page path)

### Changed

- some code simplification

## 2018-12-26 (1.1.0)

### Added

- enhance check for generated files which now could reside in any
  subdirectory in the package tree. This changes the format of the
  e0019 message slightly where now the path of a generated file will be
  displayed in the e0019 message
- add a short info to the PDF documention about how to install pkgcheck

### Changed

- change ordering of the sections in the pkgcheck.pdf document. First come the
  informational messages, then warnings and error messages and finally fatal messages.

## 2018-12-16 (1.0.0)

### Added

- quick_intro.txt: improve wording
- build_ctan_zip.p6: add source files to be included into CTAN zip archive
- devnotes.md: add documentation how to build your own binary

## 2018-12-09 (1.0.0)

- 1.0.0 First stable release
