{$N-,E-,V-,O+,F+}

Unit bibadd;

Interface

Uses
  bibwindo, Dos, Objects, BibMouse, bibsedit, BibCrt, bibdisp, bibedent,
  bibshow, bibstrg, bibstrm, bibvars, bibfile, bibutil, bibcache,
  BibReadB, BibReadT, BibReadD, BibReach, rc_strng, bibflch2,
  bibtmplt, lfnunit;

procedure CheckEntryName(Elist: PStream; Var ename: string;
                         IgnoreName: string; AskForNew: Boolean);
procedure ManualAdd(Entry: EntryRecPtr;
                    var written,changed: boolean;
                    Elist,TEList,TempEntries: PStream;
                    var nadded: word; var LastEntryName: string;
                    SMode: ConfigSortPtr; SortPattern: PatRecPtr;
                    MakeList: boolean );
procedure ImportEnt(Entry: EntryRecPtr; Pattern: PatRecPtr;
                 var ImpFile: string; var written,changed,UnixImp: boolean;
                 Elist,TEList,TempEntries: PStream;
                 var nadded: word; var LastEntryName: string;
                 var FirstEntry: longint;
                 SMode: ConfigSortPtr; SortPattern: PatRecPtr;
                 MakeList: boolean);


implementation


procedure CheckEntryName(Elist: PStream; Var ename: string;
                         IgnoreName: string; AskForNew: Boolean);
var
  ok,accept: boolean;
  lowline,lowname: string;
  Srec: SortRecType;
begin                             { CheckEntryName }
  if elist=Nil then Exit;
  ChrDel(Ename,' ');
  if Ename='' then Exit;
  if EditOnlyStrings then StrLwr(IgnoreName);
  if CheckDuplicate<>AllowDuplicate then
  repeat
    ok:=true;
    lowname:=ename; StrLwr(lowname);
    elist^.flush; elist^.reset; elist^.seek(0);
    ReadSortRec(elist,Srec);
    lowline:=Srec.name; StrLwr(lowline);
    if EditOnlyStrings then
    begin
      if (Srec.name<>'') and (lowline=lowname) and (lowline<>IgnoreName) then
      begin
        ok:=false;
        if AskForNew then ErrorMessageRC(Str_StringAlreadyExists,Ename);
      end;
    end else
    begin
      if (Srec.name<>'') and (Srec.name=ename) and (Srec.name<>IgnoreName) then
        ok:=false;
      if not ok then
      begin
        if AskForNew then ErrorMessageRC(Str_EntryAlreadyExists,Ename);
      end else if (lowline=lowname) and (Srec.name<>IgnoreName) then
      begin
        if CheckDuplicate=DuplicateCaseWarn then
          ok:=AskIf(Concat(' "',ename,' is similar to "',Srec.name,
              '"! '),'','Accept','Reject')
        else if CheckDuplicate=DuplicateCaseOff then
        begin
          ok:=false;
          if AskForNew then ErrorMessageRC(Str_EntryAlreadyExists,Ename);
        end;
      end;
    end;
    if (not ok) and (not AskForNew) then
    begin
      ename:='';
      Exit;
    end;
    while (ok) and (Srec.name<>'') do
    begin
      ReadSortRec(elist,Srec);
      lowline:=Srec.name; StrLwr(lowline);
      if EditOnlyStrings then
      begin
        if (Srec.name<>'') and (lowline=lowname) and (lowline<>IgnoreName) then
        begin
          ok:=false;
          if AskForNew then ErrorMessageRC(Str_StringAlreadyExists,Ename);
        end;
      end else
      begin
        if (Srec.name<>'') and (Srec.name=ename) and (Srec.name<>IgnoreName) then
          ok:=false;
        if (not ok) and (AskForNew) then
          ErrorMessageRC(Str_EntryAlreadyExists,Ename)
        else if (lowline=lowname) and (Srec.name<>IgnoreName) then
        begin
          if CheckDuplicate=DuplicateCaseWarn then
            ok:=AskIf(Concat(' "',ename,' is similar to "',Srec.name,
                '"! '),'','Accept','Reject')
          else if CheckDuplicate=DuplicateCaseOff then
          begin
            ok:=false;
            if AskForNew then ErrorMessageRC(Str_EntryAlreadyExists,Ename);
          end;
        end;
      end;
      if (not ok) and (not AskForNew) then
      begin
        ename:='';
        Exit;
      end;
    end;
    if (not ok) and (AskForNew) then
    begin
      if EditOnlyStrings then
        GetAString(' Enter new string name: ',Ename,ScrLen-5,50,48,NameForbid,
                   accept,true)
      else
        GetAString(' Enter new entry name: ',Ename,ScrLen-5,50,48,NameForbid,
                   accept,true);
      if not accept then Ename:='';
      if Ename='' then ok:=true;
    end;
  until ok;
  if (Elist<>Nil) and (Elist^.status<>stOK) then Elist^.reset;
end;                          { CheckEntryName }

procedure GetNewName(Var name: string; Man: boolean;
                     var accept,Finish,Abort,EditIt: boolean);
var
  xstart,xm,ym,i,y0,linelen: integer;
  line: string;
  AltPress: char;
  xfirst,att: byte;
  prompt: string[20];
  AltChars: string[4];
  ButtonChars: set of char;
begin
  Finish:=false; Abort:=false; EditIt:=false;
  if UseMouse then WaitForRelease(255);
  y0:=ScrLen-4; linelen:=48;
  prompt:=' Entry name: ';
  if EditOnlyStrings then prompt:=' String name: ';
  xstart:=(ScrWidth-linelen-2) div 2+1;
  MakeWindow(y0,xstart,3,linelen+2,DialogNorm,DialogNorm,2,RNorm,Shadow,1);
  AltPress:=#255;
  if man then
  begin
    line:='[Edit]'; AltChars:='E';
    ButtonChars:=['[','a'..'z','E',']']
  end else
  begin
    line:='[Skip]'+#205+'[Finish]'+#205+'[Abort]'+#205+'[Edit]';
    AltChars:='SFAE';
    ButtonChars:=['[','a'..'z','S','F','A','E',']'];
  end;
  TitleWindow(4,DialogNorm,line);
  for i:=1 to length(AltChars) do
    TpwAttr(y0+2,xstart+Pos(AltChars[i],line)+1,1,1,EditBright);

  ReadEdit(prompt,name,y0+1,xstart+1,50,linelen,
             NameForbid,AltChars,accept,AltPress,true);
  
  if AltPress='S' then accept:=false
  else if AltPress='F' then Finish:=true
  else if AltPress='A' then Abort:=true
  else if AltPress='E' then EditIt:=true
  else if AltPress=#255 then
  begin
    i:=length(line); line:='';
    xm:=Event.x-xstart; ym:=Event.y-y0;
    if (ym=2) and (xm>1) and (xm<i+2) then
        ReadScrStr(line,xm+xstart,ym+y0,xfirst,att,ButtonChars);
    if line='[Skip]'        then accept:=false
    else if line='[Finish]' then Finish:=true
    else if line='[Abort]'  then Abort:=true
    else if line='[Edit]'   then EditIt:=true;
  end;
  RemoveWindow;
  if Abort then accept:=false;
end;                                  { GetNewName }

procedure ManualAdd(Entry: EntryRecPtr;
                    var written,changed: boolean;
                    Elist,TEList,TempEntries: PStream;
                    var nadded: word; var LastEntryName: string;
                    SMode: ConfigSortPtr; SortPattern: PatRecPtr;
                    MakeList: boolean );
var
  opos: longint;
  i,EdExitCode: Byte;
  Finish,retain,accept,AbortIt,EditIt,FinishIt: boolean;
  S: BigTypePtr;
  Sbuff: array[1..256] of char;
  CurMaxBig,j: Word;
  Scroll,LastY: longint;

procedure TidyUp;
begin
  TempEntries^.flush;
  SuspendWaiting(false);
end;

begin                           { ManualAdd }
  SuspendWaiting(true);
  Entry^.entrynum:=0; Entry^.realnum:=0; Entry^.nentry:=0;
  repeat
    Finish:=false;
    if written then ShowEntry(Entry,Scroll,LastY,true,false,false);
    Scroll:=0;
    EditEntry(Entry,true,Scroll,changed,false,false,true,EdExitCode);
    if Entry^.nentry=0 then
    begin
      finish:=true; changed:=false;
    end;
    FinishIt:=false; AbortIt:=false; EditIt:=false;
    if EdExitCode=CEditFinish then finish:=true;
    if changed then
    begin
      if Entry^.name='' then
      begin
        if (not EditOnlyStrings) and (LabelMode<>OffLabelMode) then
          AutoLabel(Entry,LabelTemplate^,Entry^.name);
        if (Entry^.name='') or (LabelMode<>AutoLabelMode) then
        begin
          GetNewName(Entry^.name,true,accept,FinishIt,AbortIt,EditIt);
          if Entry^.name='' then Finish:=true;
          if FinishIt then Finish:=true;
          if EditIt or (not accept) then
          begin
            Entry^.name:=''; Finish:=false;
          end;
        end;
      end;
      if (Entry^.name<>'') then
      begin
        CheckEntryName(elist,Entry^.name,'',true);
        if nadded>0 then CheckEntryName(TElist,Entry^.name,'',true);
      end;
      if (Entry^.name<>'') then
      begin
        Entry^.beginning:=TempEntries^.getsize;
        TempEntries^.seek(TempEntries^.getsize);
        PutEntryTemp(TempEntries,Entry,false);
        if TempEntries^.status<>stOK then
        begin
          TidyUp; Exit;
        end;
        LastEntryName:=Entry^.name;
        TempEntries^.flush;
        if MakeList then
        begin
          MaxMemAvail;
          TElist^.seek(TElist^.getsize);
          WriteElist(Telist,SMode^,SortPattern,Entry);
          if TElist^.status<>stOK then
          begin
            TidyUp; Exit;
          end;
          Telist^.Flush;
        end;
        Inc(nadded);
        written:=true;
        Entry^.entrynum:=0; Entry^.realnum:=0; Entry^.nentry:=0;
      end;
    end;
  until Finish;
  TidyUp;
end;                                     { ManualAdd }

procedure ImportEnt(Entry: EntryRecPtr; Pattern: PatRecPtr;
                 var ImpFile: string; var written,changed,UnixImp: boolean;
                 Elist,TEList,TempEntries: PStream;
                 var nadded: word; var LastEntryName: string;
                 var FirstEntry: longint;
                 SMode: ConfigSortPtr; SortPattern: PatRecPtr;
                 MakeList: boolean);
var
  op,nomore,ok,skip,SkipAll,OldUnixBib,btmp,display,FirstEmpty: boolean;
  quiet,accept,AbortIt,FinishIt,EditIt,OldBibFileExists,FirstTime: boolean;
  SkipIt,Done: boolean;
  fentry,opos,Scroll,LastY: longint;
  ename: string;
  choice: integer;
  ercode,EdExitCode: byte;
  OldBibName: string;
  PP: PatRecPtr;

procedure TidyUp;
begin
  if TempEntries<>Nil then TempEntries^.flush;
  if MakeList then TElist^.flush;
  CloseFile(bib);
  bibname^:=OldBibName;
  LFNAssign(bib,bibname^); UnixBib:=OldUnixBib;
  BibFileExists:=OldBibFileExists;
  SetTextBuf(bib,bibbuf^,FileBufSize);
  if (not AbortFlag) and (nadded=0) then
  begin
    if EditOnlyStrings then MessageRC(Str_NoStringsIn,ImpFile)
    else MessageRC(Str_NoEntriesIn,ImpFile);
  end;
  EntryCache^.on:=true;
end;                       { TidyUp }

begin                                    { Import }
  if ImpFile='' then Exit;
  OldBibFileExists:=BibFileExists;
  OldUnixBib:=UnixBib;
  OldBibName:=bibname^; bibname^:=ImpFile;
  CloseFile(bib);
  EntryCache^.on:=false;

  LFNAssign(bib,ImpFile); UnixImp:=IsUnixFile(bib,ImpFile);
  SetTextBuf(bib,bibbuf^,FileBufSize);
  BibFileExists:=true;
  Resetbib(Entry);
  UnixBib:=UnixImp;
  nadded:=0;
  WaitingMessage('Importing...');
  SkipAll:=false;
  display:=EditOnlyStrings or (Verify[ImportFormat]=VerifyOff);
  if ImportFormat=BibTeXFormat then
    GetEntry(Entry,Nil,1,true,Nil,ok)
  else if ImportFormat=CommaDelimited then
    GetDBEntry(Entry,Nil,1,'',Nil,ok)
  else if (ImportFormat=TibFormat) or (ImportFormat=ReferFormat) then
    GetTibEntry(Entry,Nil,1,ImportFormat,'',Nil,ok);
  FirstEntry:=Entry^.Beginning;
  if ok and (Pattern<>Nil) and Pattern^.on and (ImportFormat=BibTeXFormat) then
  begin
    ResetBib(Entry);
    GetEntry(Entry,Nil,1,true,Pattern,ok);
  end;
  if not ok then
  begin
    TidyUp; Exit;
  end;
  ChrDel(Entry^.name,' ');
  fentry:=Entry^.realnum;
  nomore:=false; quiet:=false;

  EntryEditMenu.ToMenu[EntryEditMenu.nitems]:=true;
  StringEditMenu.ToMenu[StringEditMenu.nitems]:=true;
  FirstEmpty:=(Entry^.nentry>0) and (Entry^.name='');
  repeat
    EdExitCode:=0; changed:=true; SkipIt:=false;
    if (FirstEmpty) or (Entry^.name<>'') then
    begin
      Scroll:=0;
      if (entry^.name='') or (Verify[ImportFormat]<>VerifyOff) then
      begin
        if (Verify[ImportFormat]=VerifyLabel) or
           ((Verify[ImportFormat]=VerifyOff) and FirstEmpty)
           or ((not quiet) and (Verify[ImportFormat]=VerifyEntry)) then
        begin
          SuspendWaiting(true);
          ShowEntry(Entry,Scroll,LastY,false,false,false);
          FirstTime:=true;
          EditIt:=(Verify[ImportFormat]=VerifyEntry);
          repeat
            FinishIt:=false; AbortIt:=false; SkipIt:=false; EdExitCode:=0;
            Done:=false;
            if (not FirstTime) or (Verify[ImportFormat]<>VerifyEntry) then
            begin
              if (Entry^.name='') and (not EditOnlyStrings) and
                (LabelMode<>OffLabelMode) then
                   AutoLabel(Entry,LabelTemplate^,Entry^.name);
              GetNewName(Entry^.name,false,accept,FinishIt,AbortIt,EditIt);
              if not accept then SkipIt:=true;
            end;
            if EditIt then
            begin
              EditEntry(Entry,false,Scroll,changed,false,false,true,EdExitCode);
              if      EdExitCode=CEditFinish   then nomore:=true
              else if EdExitCode=CEdQuit_Skip  then SkipIt:=true
              else if EdExitCode=CEdQuit_Term  then FinishIt:=true
              else if EdExitCode=CEdQuit_Abort then AbortIt:=true;
              if nomore or FinishIt or AbortIt or SkipIt or (Entry^.name<>'')
                  then Done:=true;
            end else Done:=true;
            FirstTime:=false; EditIt:=false;
          until Done;
          if SkipIt then Entry^.name:='';
          if FinishIt or AbortIt then
          begin
            SkipIt:=true; nomore:=true;
          end;
          SuspendWaiting(false);
        end;
      end;
      if (EdExitCode=0) and (entry^.name='') then SkipIt:=true;
      if changed and (entry^.name<>'') and (not SkipIt) then
      begin
        ename:=entry^.name;
        CheckEntryName(elist,Entry^.name,'',false);
        if Entry^.name<>'' then CheckEntryName(Telist,Entry^.name,'',false);
        repeat
          Skip:=false;
          if (Entry^.name='') and (not SkipAll) then
          begin
            Scroll:=0; LastY:=0;
            SuspendWaiting(true);
            if display then
            begin
              MakeBox(2,1,ScrLen-1,ScrWidth,EntryNorm,EntryNorm,2,0,0,0);
            end;
            ShowEntry(Entry,Scroll,LastY,false,false,false);
            if EditOnlyStrings then
              choice:=AskIf4(' String "'+ename+'" is duplicated! ',
                'Rename', 'Skip dup.', 'Ignore', 'Abort')
            else
              choice:=AskIf4(' Entry "'+ename+'" is duplicated! ',
                'Rename', 'Skip dup.', 'Ignore', 'Abort');
            if choice=4 then
            begin        
              nadded:=0;
              written:=false;
              nomore:=true;
            end else if choice=1 then
            begin
              if EditOnlyStrings then
                GetAString(' Enter new string name: ',Ename,ScrLen-5,50,48,
                           NameForbid,accept,true)
              else
                GetAString(' Enter new entry name: ',Ename,ScrLen-5,50,48,
                           NameForbid,accept,true);
              if not accept then Ename:='';
              Entry^.name:=Ename;
            end else if choice=2 then
            begin
              SkipAll:=true;
            end else if Choice=3 then
            begin
              Skip:=true;
              Entry^.name:='';
            end;
            SuspendWaiting(false);
          end;
          if entry^.name<>'' then
          begin
            ename:=entry^.name;
            CheckEntryName(elist,Entry^.name,'',false);
            if nadded>0 then CheckEntryName(Telist,Entry^.name,'',false);
          end;
        until (Entry^.name<>'') or (Skip) or (nomore) or (SkipAll);
      end else if (not changed) and (SkipIt) then Entry^.name:=''
      else if FinishIt then nomore:=true
      else if AbortIt then
      begin
        nomore:=true; nadded:=0;
      end;
      if (Entry^.name<>'') and (not SkipIt) then
      begin
        Entry^.beginning:=TempEntries^.getsize;
        PutEntryTemp(TempEntries,Entry,false);
        if TempEntries^.status<>stOK then
        begin
          TidyUp; Exit;
        end;
        LastEntryName:=Entry^.name;
        if MakeList then
        begin
          TElist^.seek(TElist^.getsize);
          WriteElist(Telist,SMode^,SortPattern,Entry);
          if TElist^.status<>stOK then
          begin
            TidyUp; Exit;
          end;
        end;
        written:=true;
        Inc(nadded);
        if Display then WaitingMessage('Imported '+Num2Str(nadded)+'...');
      end;
      if not nomore then
      begin
        if ImportFormat=BibTeXFormat then
          GetEntry(Entry,Nil,entry^.entrynum+1,true,Pattern,ok)
        else if ImportFormat=CommaDelimited then
          GetDBEntry(Entry,Nil,entry^.entrynum+1,'',Pattern,ok)
        else if (ImportFormat=TibFormat) or (ImportFormat=ReferFormat) then
          GetTibEntry(Entry,Nil,entry^.entrynum+1,ImportFormat,'',Pattern,ok);
        ChrDel(Entry^.name,' ');
      end;
    end;
    FirstEmpty:=false;
    TrapAbort;
  until (nomore) or (entry^.realnum<=fentry)
        or (Entry^.entrynum<nadded) or AbortFlag;
  EntryEditMenu.ToMenu[EntryEditMenu.nitems]:=false;
  StringEditMenu.ToMenu[StringEditMenu.nitems]:=false;

  if AbortFlag then
  begin
    written:=false; nadded:=0;
  end;
  TidyUp;
end;                                  { Import }



end.
