#!BPY
"""
Name: 'Star'
Blender: 248
Group: 'AddMesh'
"""
__author__ = ["Four Mad Men", "FourMadMen.com"]
__version__ = '1.00'
__url__ = ["http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Add/Star"]
__email__=["bwiki {at} fourmadmen {dot} com"]


__bpydoc__ = """

Usage:

* Launch from Add Mesh menu

* Modify parameters as desired or keep defaults

"""
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2008, FourMadMen.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****

import BPyAddMesh
import Blender

def add_star(PREF_POINTS, PREF_OUTR_RAD, PREF_INNR_RAD, PREF_DEPTH):
	Vector = Blender.Mathutils.Vector
	RotationMatrix = Blender.Mathutils.RotationMatrix
	verts = []
	faces = []
	
	segments = PREF_POINTS * 2
	tot_verts = segments * 2 + 2
	
	half_height = PREF_DEPTH * .5
	
	verts.append( Vector(0, 0, half_height) )
	verts.append( Vector(0, 0, -half_height) )
	
	i = 2
	alt_idx = 0
	for index in xrange(segments):
		mtx = RotationMatrix( (360 * float(index)/segments)+90, 3, 'z' )
		
		radius = alt_idx and PREF_INNR_RAD or PREF_OUTR_RAD
		
		verts.append( Vector(radius, 0, half_height) * mtx )
		it1 = i
		i+=1
		
		verts.append( Vector(radius, 0, -half_height) * mtx )
		ib1 = i
		i+=1
		
		if i>4:
			faces.append( (it2, it1, 0) )
			faces.append( (it1, it2, ib2, ib1) )
			faces.append( (ib1, ib2, 1) )
		
		it2 = it1
		ib2 = ib1
		
		alt_idx = 1 - alt_idx
		
	faces.append( (tot_verts-2, 2, 0) )
	faces.append( (3, 2, tot_verts-2, tot_verts-1) )
	faces.append( (3, tot_verts-1, 1) )
	
	return verts, faces

def main():
	Draw = Blender.Draw
	PREF_POINTS = Draw.Create(5)
	PREF_OUTR_RAD = Draw.Create(1.0)
	PREF_INNR_RAD = Draw.Create(0.5)
	PREF_DEPTH = Draw.Create(0.5)
	
	if not Draw.PupBlock('Add Star', [\
	('Points:', PREF_POINTS,  2, 256, 'Number of points of the star'),\
	('Outer Radius:', PREF_OUTR_RAD,  0.01, 100, 'Outer Radius of the star'),\
	('Inner Radius:', PREF_INNR_RAD,  0.01, 100, 'Inner Radius of the star'),\
	('Depth:', PREF_DEPTH,  0.01, 100, 'Depth of the star'),\
	]):
		return
	
	verts, faces = add_star(PREF_POINTS.val, PREF_OUTR_RAD.val, PREF_INNR_RAD.val, PREF_DEPTH.val)
	
	BPyAddMesh.add_mesh_simple('Star', verts, [], faces)

main()

