#!BPY
"""
Name: 'Paraboloid'
Blender: 248
Group: 'AddMesh'
"""
__author__ = ["Zoel"]
__version__ = '1.00'
__url__ = ["Script Index, http://wiki.blender.org/index.php/Scripts/Manual/Add/Add_Mesh_Paraboloid"]
__email__=["Zoel{at}"]


__bpydoc__ = """

Usage:

* Launch from Add Mesh menu

* Modify parameters as desired or keep defaults

"""
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2008, Zoel
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****

import BPyAddMesh
import Blender
from math import sqrt, sin, cos, pi


def add_paraboloid(segments,rings,radius,height):
	v=[]
	f=[]

	#Creating the verticies

        for i in range(1,rings+1):
            z=height*(float(i)/rings)**2
            r=radius/rings*i
            for j in range(0,segments):
                angle=float(j)/segments*2*pi
                x=cos(angle)*r
                y=sin(angle)*r
                v.append([x,y,z])


        #adding the central vertex
        v.append([0,0,0])
        

        #creating the faces not around the center
        for j in range(0,rings-1):
            for i in range(0,segments):
                if i==segments-1:
                    c=segments
                else:
                    c=0
                i+=j*segments
                f.append([i,i+segments,i+segments+1-c,i+1-c])


        #creating the faces at the bottom
        for i in range(0,segments):
            if i==segments-1:
                c=segments
            else:
                c=0
            f.append([i,i+1-c,len(v)-1])

        return v,f







def main():
    segments=Blender.Draw.Create(32)
    rings=Blender.Draw.Create(16)
    radius=Blender.Draw.Create(1.0)
    height=Blender.Draw.Create(1.0)

    if not Blender.Draw.PupBlock('Add Paraboloid',[\
    ('segments:',segments,3,500,'number of segments per ring'),\
    ('rings:',rings,2,500,'number of rings'),\
    ('height:',height,0.0,10.0,'height of paraboloid'),\
    ('radius:',radius,0.0,10.0,'radius of paraboloid'),\
    ]):
        return    
    
    v,f = add_paraboloid(segments.val,rings.val,radius.val,height.val)

    BPyAddMesh.add_mesh_simple('Paraboloid',v,[],f)

main()


    
                     
                    
