#ifndef _GHOST_WINDOWZETA_H_
#define _GHOST_WINDOWZETA_H_

#include "GHOST_SystemZETA.h"
#include "GHOST_Window.h"

class GHOSTBWindow;
class GHOSTBGLView;

class GHOST_WindowZETA : public GHOST_Window
{
	public:
									GHOST_WindowZETA(
										GHOST_SystemZETA* systemZETA,
										const STR_String& title,
										GHOST_TInt32 left,
										GHOST_TInt32 top,
										GHOST_TUns32 width,
										GHOST_TUns32 height,
										GHOST_TWindowState state,
										GHOST_TDrawingContextType type = GHOST_kDrawingContextTypeNone,
										const bool stereoVisual = false );
		
									~GHOST_WindowZETA();
		/*
		 * GHOST_IWindow methods for GHOST_WindowZETA
		 */
		
		GHOST_TSuccess				activateDrawingContext();
		
		void						clientToScreen(
										GHOST_TInt32 inX,
										GHOST_TInt32 inY,
										GHOST_TInt32& outX,
										GHOST_TInt32& outY ) const;
		
		void						getClientBounds(
										GHOST_Rect& bounds ) const;
		
		GHOST_TWindowState			getState() const;
		
		void						getTitle(
										STR_String& title ) const;
				
		bool						getValid() const;
		
		void						getWindowBounds(
										GHOST_Rect& bounds ) const;
		
		GHOST_TSuccess				invalidate();
		
		void						screenToClient(
										GHOST_TInt32 inX,
										GHOST_TInt32 inY,
										GHOST_TInt32& outX,
										GHOST_TInt32& outY ) const;
		
		GHOST_TSuccess				setClientHeight(
										GHOST_TUns32 height );
		
		GHOST_TSuccess				setClientSize(
										GHOST_TUns32 width,
										GHOST_TUns32 height );
		
		GHOST_TSuccess				setClientWidth(
										GHOST_TUns32 width );
		
		GHOST_TSuccess				setOrder(
										GHOST_TWindowOrder order );
		
		GHOST_TSuccess				setState(
										GHOST_TWindowState state );
		
		void						setTitle(
										const STR_String& title );
		
		GHOST_TSuccess				swapBuffers();
		
		/*
		 * GHOST_Window methods for GHOST_WindowZETA
		 */
		
		GHOST_TSuccess				installDrawingContext(
										GHOST_TDrawingContextType type );
		
		GHOST_TSuccess				removeDrawingContext();
		
		GHOST_TSuccess				setWindowCursorShape(
										GHOST_TStandardCursor shape );
		
		GHOST_TSuccess				setWindowCursorVisibility(
										bool visible );
		
		GHOST_TSuccess				setWindowCustomCursorShape(
										GHOST_TUns8 bitmap[16][2],
										GHOST_TUns8 mask[16][2],
										int hotX,
										int hotY );
									
		GHOST_TSuccess				setWindowCustomCursorShape(
										GHOST_TUns8* bitmap,
										GHOST_TUns8* mask,
										int szx,
										int szy,
										int hotX,
										int hotY,
										int fg,
										int bg );
				
		/*
		 * ZETA methods for GHOST_WindowZETA
		 */
		
		GHOST_SystemZETA*			getSystemZETA();
		
	private:
		GHOST_SystemZETA*			fSystemZETA;
	
		GHOSTBWindow*				fBWindow;

		GHOSTBGLView*				fBGLView;
		
};

#endif

/*
 * ZETA stuff
 */

/*
 * GHOSTBWindow
 * TODO: Make this a BDirectWindow when the MESA driver has this functionality.
 */

#ifndef GHOSTBDIRECTWINDOW
#define GHOSTBDIRECTWINDOW

#include <Window.h>


class GHOSTBWindow : public BWindow
{
	public:
									GHOSTBWindow(
										GHOST_WindowZETA* windowZETA,
										BRect frame,
										const char* title,
										window_look look,
										window_feel feel,
										uint32 flags,
										uint32 workspaces = B_CURRENT_WORKSPACE );
									
									~GHOSTBWindow();
		
		void						DispatchMessage(
										BMessage* msg,
										BHandler* target );
				
		void						LockContext();
		
		void						UnlockContext();
		
		void						SwapGLBuffers();
		
	private:
		GHOST_WindowZETA*			fWindowZETA;
		
		GHOSTBGLView*				fBGLView;
		
		int32						fLastMouseButton;
		
};

#endif

/*
 * GHOSTBGLView
 */

#ifndef GHOSTBGLVIEW
#define GHOSTBGLVIEW

#include <GLView.h>

class GHOSTBGLView : public BGLView
{
	public:
								GHOSTBGLView(
									BRect frame,
									char* name,
									uint32 resizingmode,
									uint32 flags,
									uint32 type );
};

#endif
