#!BPY

"""
Name: 'Save Current Theme...'
Blender: 236
Group: 'Export'
Tooltip: 'Save current theme as a bpython script'
"""

__author__ = "Willian P. Germano"
__url__ = ("blender", "elysiun")
__version__ = "1.2 2005/05/17"

__bpydoc__ = """\
This script saves the current Theme in Blender as a Blender Python script.

Usage:

Use Blender's Theme tab in the User Preferences window to create and name your
theme, then run this script from the File->Export menu to save it.

It is saved as a bpython script, meaning that you can simply run it to change
the current theme.  By default it is currently saved under the
"Misc" group, available only from the Scripts window "Scripts->Misc" menu.

To appear in the menu, a theme saved with this script must be put in your
Blender's scripts dir, that's what happens by default when you save one by
yourself.  If you don't know where this dir is, running

import Blender<br>print Blender.Get("scriptsdir")

on the Text Editor window (use menu or ALT+P to run it) will write the path on
the console.

Remember to edit your exported theme's source file to put your name and
some information on it before sharing it with others.
"""

# $Id: save_theme.py,v 1.5 2005/05/17 07:17:52 ianwill Exp $
#
# --------------------------------------------------------------------------
# save_theme version 2.34 Sep 20, 2004
# Copyright (C) 2004: Willian P. Germano, wgermano _at_ ig.com.br
# --------------------------------------------------------------------------
# Released under the Blender Artistic License (BAL):
#   http://download.blender.org/documentation/html/x21254.html
#
# The scripts generated by this script are put under Public Domain by
# default, but you are free to edit the ones you generate with this script
# and change their license to another one of your choice.
# --------------------------------------------------------------------------

import Blender
from Blender.Window import Theme, FileSelector

theme = Theme.Get()[0] # get current theme

# default filename: theme's name + '_theme.py' in user's scripts dir:
default_fname = Blender.Get("scriptsdir")
default_fname = Blender.sys.join(default_fname, theme.name + '_theme.py')
default_fname = default_fname.replace(' ','_')

def write_theme(filename):
	"Write the current theme as a bpython script"

	if not filename.endswith('.py'): filename += '.py'

	fout = file(filename, "w")

	fout.write("""#!BPY

# \"\"\"
# Name: '%s'
# Blender: 236
# Group: 'Themes'
# Tooltip: 'Change current theme'
# \"\"\"

__%s__ = "????"
__%s__ = "1.2"
__%s__ = ["blender"]
__%s__ = \"\"\"\\
You can edit this section to write something about your script that can
be read then with the Scripts Help Browser script in Blender.

Remember to also set author, version and possibly url(s) above.  You can also
define an __email__ tag, check some bundled script's source for examples.
\"\"\"

# This script was automatically generated by the save_theme.py bpython script.
# By default, these generated scripts are released as Public Domain, but you
# are free to change the license of the scripts you generate with
# save_theme.py before releasing them.

import Blender
from Blender.Window import Theme

theme = Theme.New('%s')
""" % (theme.name, "author", "version", "url", "bpydoc", theme.name))

	for tsp in theme.get(): # 
		command = "\n%s = theme.get('%s')" % (tsp, tsp)
		fout.write(command + "\n")
		exec(command)
		exec("vars = dir(%s)" % tsp)
		vars.remove('theme')

		for var in vars:
			v = "%s.%s" % (tsp, var)
			exec("value = %s" % v)
			fout.write("%s = %s\n" % (v, value))

	fout.write('\nBlender.Redraw(-1)')
	fout.close()
	try:
		Blender.UpdateMenus()
	except:
		Blender.Draw.PupMenu("Warning - check console!%t|Menus could not be automatically updated")

FileSelector(write_theme, "Save Current Theme", default_fname)
