"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateFileTypes = exports.mergeCustomizerForPreview = exports.isValidObject = exports.isValidDate = exports.isNumericType = exports.isBooleanType = exports.fetchDepthLimit = exports.decideClient = void 0;
var _moment = _interopRequireDefault(require("moment"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const decideClient = async (dataSourceEnabled, context, dataSourceId) => {
  return dataSourceEnabled && dataSourceId ? await context.dataSource.opensearch.getClient(dataSourceId) : context.core.opensearch.client.asCurrentUser;
};
exports.decideClient = decideClient;
const validateFileTypes = (fileTypes, fileProcessors) => {
  const nonRegisteredFileTypes = fileTypes.filter(fileType => !fileProcessors.hasFileProcessorBeenRegistered(fileType));
  if (nonRegisteredFileTypes.length > 0) {
    throw new Error(`The following enabledFileTypes are not registered: ${nonRegisteredFileTypes.join(', ')}`);
  }
};
exports.validateFileTypes = validateFileTypes;
const isValidDate = date => {
  return (0, _moment.default)(date, _moment.default.ISO_8601, true).isValid() || (0, _moment.default)(date, _moment.default.RFC_2822, true).isValid();
};
exports.isValidDate = isValidDate;
const isBooleanType = value => {
  return value === 'true' || value === 'false' || typeof value === 'boolean';
};
exports.isBooleanType = isBooleanType;
const isNumericType = value => {
  return !isNaN(Number(value));
};
exports.isNumericType = isNumericType;
const mergeCustomizerForPreview = (objValue, srcValue) => {
  if (!isBooleanType(objValue) && !isNumericType(objValue)) {
    return objValue;
  } else {
    return srcValue;
  }
};
exports.mergeCustomizerForPreview = mergeCustomizerForPreview;
const flattenObject = obj => {
  const result = {};
  for (const key of Object.keys(obj)) {
    if (obj[key] && typeof obj[key] === 'object') {
      const nested = flattenObject(obj[key]);
      if (Object.keys(nested).length === 0) {
        result[`${key}.`] = null;
      }
      for (const nestedKey of Object.keys(nested)) {
        result[`${key}.${nestedKey}`] = nested[nestedKey];
      }
    } else {
      result[key] = obj[key];
    }
  }
  return result;
};
const isValidObject = obj => {
  if (Object.keys(obj).length === 0) {
    return false;
  }
  const flattenedObject = flattenObject(obj);
  if (Object.keys(flattenedObject).length === 0) {
    return false;
  }
  const keys = Object.keys(flattenedObject).map(key => key.replace(/\s/g, ''));
  return keys.every(key => key.length > 0 && !key.startsWith('.') && !key.endsWith('.') && !!!key.match(/(\.\.)+/g));
};
exports.isValidObject = isValidObject;
const fetchDepthLimit = async client => {
  const defaultLimit = 20;
  try {
    var _clusterSettings$defa, _clusterSettings$pers, _clusterSettings$tran;
    const clusterSettings = (await client.cluster.getSettings({
      include_defaults: true,
      filter_path: '**.depth.limit'
    })).body;
    const defaultSettingsRaw = Number((_clusterSettings$defa = clusterSettings.defaults) === null || _clusterSettings$defa === void 0 || (_clusterSettings$defa = _clusterSettings$defa.indices) === null || _clusterSettings$defa === void 0 || (_clusterSettings$defa = _clusterSettings$defa.mapping) === null || _clusterSettings$defa === void 0 || (_clusterSettings$defa = _clusterSettings$defa.depth) === null || _clusterSettings$defa === void 0 ? void 0 : _clusterSettings$defa.limit);
    const defaultSettings = !isNaN(defaultSettingsRaw) ? defaultSettingsRaw : defaultLimit;
    const persistentSettingsRaw = Number((_clusterSettings$pers = clusterSettings.persistent.indices) === null || _clusterSettings$pers === void 0 || (_clusterSettings$pers = _clusterSettings$pers.mapping) === null || _clusterSettings$pers === void 0 || (_clusterSettings$pers = _clusterSettings$pers.depth) === null || _clusterSettings$pers === void 0 ? void 0 : _clusterSettings$pers.limit);
    const persistentSettings = !isNaN(persistentSettingsRaw) ? persistentSettingsRaw : defaultLimit;
    const transientSettingsRaw = Number((_clusterSettings$tran = clusterSettings.transient.indices) === null || _clusterSettings$tran === void 0 || (_clusterSettings$tran = _clusterSettings$tran.mapping) === null || _clusterSettings$tran === void 0 || (_clusterSettings$tran = _clusterSettings$tran.depth) === null || _clusterSettings$tran === void 0 ? void 0 : _clusterSettings$tran.limit);
    const transientSettings = !isNaN(transientSettingsRaw) ? transientSettingsRaw : defaultLimit;

    // To ensure maximum compatibility, we're only considering the minimum of all 3 settings
    return Math.min(defaultSettings, persistentSettings, transientSettings);
  } catch (e) {
    return defaultLimit;
  }
};
exports.fetchDepthLimit = fetchDepthLimit;