/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.CompressedDataPacket;
import org.bouncycastle.bcpg.ExperimentalPacket;
import org.bouncycastle.bcpg.LiteralDataPacket;
import org.bouncycastle.bcpg.MarkerPacket;
import org.bouncycastle.bcpg.ModDetectionCodePacket;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PacketTags;
import org.bouncycastle.bcpg.PaddingPacket;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.ReservedPacket;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.bcpg.SymmetricEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UnknownPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.util.io.Streams;

public class BCPGInputStream
extends InputStream
implements PacketTags {
    InputStream in;
    boolean next = false;
    int nextB;
    boolean mNext = false;
    int mNextB;

    public static BCPGInputStream wrap(InputStream in) {
        if (in instanceof BCPGInputStream) {
            return (BCPGInputStream)in;
        }
        return new BCPGInputStream(in);
    }

    public BCPGInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.mNext = this.next;
        this.mNextB = this.nextB;
        this.in.mark(readLimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.next = this.mNext;
        this.nextB = this.mNextB;
        this.in.reset();
    }

    @Override
    public int read() throws IOException {
        if (this.next) {
            this.next = false;
            return this.nextB;
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (!this.next) {
            return this.in.read(buf, off, len);
        }
        if (this.nextB < 0) {
            return -1;
        }
        buf[off] = (byte)this.nextB;
        this.next = false;
        return 1;
    }

    public void readFully(byte[] buf, int off, int len) throws IOException {
        if (Streams.readFully((InputStream)this, (byte[])buf, (int)off, (int)len) < len) {
            throw new EOFException();
        }
    }

    public byte[] readAll() throws IOException {
        return Streams.readAll((InputStream)this);
    }

    public void readFully(byte[] buf) throws IOException {
        this.readFully(buf, 0, buf.length);
    }

    public int nextPacketTag() throws IOException {
        if (!this.next) {
            try {
                this.nextB = this.read();
            }
            catch (EOFException e) {
                this.nextB = -1;
            }
            this.next = true;
        }
        if (this.nextB < 0) {
            return this.nextB;
        }
        int maskB = this.nextB & 0x3F;
        if ((this.nextB & 0x40) == 0) {
            maskB >>= 2;
        }
        return maskB;
    }

    public Packet readPacket() throws IOException {
        int hdr = this.read();
        if (hdr < 0) {
            return null;
        }
        if ((hdr & 0x80) == 0) {
            throw new IOException("invalid header encountered");
        }
        boolean newPacket = (hdr & 0x40) != 0;
        int tag = 0;
        int bodyLen = 0;
        boolean partial = false;
        if (newPacket) {
            tag = hdr & 0x3F;
            boolean[] flags = new boolean[3];
            bodyLen = StreamUtil.readBodyLen(this, flags);
            partial = flags[StreamUtil.flag_partial];
        } else {
            int lengthType = hdr & 3;
            tag = (hdr & 0x3F) >> 2;
            switch (lengthType) {
                case 0: {
                    bodyLen = this.read();
                    break;
                }
                case 1: {
                    bodyLen = StreamUtil.read2OctetLength(this);
                    break;
                }
                case 2: {
                    bodyLen = StreamUtil.read4OctetLength(this);
                    break;
                }
                case 3: {
                    partial = true;
                    break;
                }
                default: {
                    throw new IOException("unknown length type encountered");
                }
            }
        }
        BCPGInputStream objStream = bodyLen == 0 && partial ? this : new BCPGInputStream(new BufferedInputStream(new PartialInputStream(this, partial, bodyLen)));
        switch (tag) {
            case 0: {
                return new ReservedPacket(objStream, newPacket);
            }
            case 1: {
                return new PublicKeyEncSessionPacket(objStream, newPacket);
            }
            case 2: {
                return new SignaturePacket(objStream, newPacket);
            }
            case 3: {
                return new SymmetricKeyEncSessionPacket(objStream, newPacket);
            }
            case 4: {
                return new OnePassSignaturePacket(objStream, newPacket);
            }
            case 5: {
                return new SecretKeyPacket(objStream, newPacket);
            }
            case 6: {
                return new PublicKeyPacket(objStream, newPacket);
            }
            case 7: {
                return new SecretSubkeyPacket(objStream, newPacket);
            }
            case 8: {
                return new CompressedDataPacket(objStream, newPacket);
            }
            case 9: {
                return new SymmetricEncDataPacket(objStream, newPacket);
            }
            case 10: {
                return new MarkerPacket(objStream, newPacket);
            }
            case 11: {
                return new LiteralDataPacket(objStream, newPacket);
            }
            case 12: {
                return new TrustPacket(objStream, newPacket);
            }
            case 13: {
                return new UserIDPacket(objStream, newPacket);
            }
            case 17: {
                return new UserAttributePacket(objStream, newPacket);
            }
            case 14: {
                return new PublicSubkeyPacket(objStream, newPacket);
            }
            case 18: {
                return new SymmetricEncIntegrityPacket(objStream, newPacket);
            }
            case 19: {
                return new ModDetectionCodePacket(objStream, newPacket);
            }
            case 20: {
                return new AEADEncDataPacket(objStream, newPacket);
            }
            case 21: {
                return new PaddingPacket(objStream, newPacket);
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return new ExperimentalPacket(tag, objStream, newPacket);
            }
        }
        return new UnknownPacket(tag, objStream, newPacket);
    }

    public int skipMarkerPackets() throws IOException {
        return this.skipMarkerAndPaddingPackets();
    }

    public int skipMarkerAndPaddingPackets() throws IOException {
        int tag;
        while ((tag = this.nextPacketTag()) == 10 || tag == 21) {
            this.readPacket();
        }
        return tag;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private static class PartialInputStream
    extends InputStream {
        private BCPGInputStream in;
        private boolean partial;
        private int dataLength;

        PartialInputStream(BCPGInputStream in, boolean partial, int dataLength) {
            this.in = in;
            this.partial = partial;
            this.dataLength = dataLength;
        }

        @Override
        public int available() throws IOException {
            int avail = this.in.available();
            if (avail <= this.dataLength || this.dataLength < 0) {
                return avail;
            }
            if (this.partial && this.dataLength == 0) {
                return 1;
            }
            return this.dataLength;
        }

        private int loadDataLength() throws IOException {
            boolean[] flags = new boolean[3];
            this.dataLength = StreamUtil.readBodyLen(this.in, flags);
            if (flags[StreamUtil.flag_eof]) {
                return -1;
            }
            this.partial = flags[StreamUtil.flag_partial];
            return this.dataLength;
        }

        @Override
        public int read(byte[] buf, int offset, int len) throws IOException {
            do {
                if (this.dataLength == 0) continue;
                int readLen = this.dataLength > len || this.dataLength < 0 ? len : this.dataLength;
                if ((readLen = this.in.read(buf, offset, readLen)) < 0) {
                    throw new EOFException("premature end of stream in PartialInputStream");
                }
                this.dataLength -= readLen;
                if (this.partial && this.dataLength == 0) {
                    this.loadDataLength();
                }
                return readLen;
            } while (this.partial && this.loadDataLength() >= 0);
            return -1;
        }

        @Override
        public int read() throws IOException {
            do {
                if (this.dataLength == 0) continue;
                int ch = this.in.read();
                if (ch < 0) {
                    throw new EOFException("premature end of stream in PartialInputStream");
                }
                --this.dataLength;
                if (this.partial && this.dataLength == 0) {
                    this.loadDataLength();
                }
                return ch;
            } while (this.partial && this.loadDataLength() >= 0);
            return -1;
        }
    }
}

