/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.matchers.AbstractMatcherEditorListenerSupport;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;

public class ThreadedMatcherEditor<E>
extends AbstractMatcherEditorListenerSupport<E> {
    private static final Executor DEFAULT_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable runnable) {
            new Thread(runnable, "MatcherQueueThread").start();
        }
    };
    private final MatcherEditor<E> source;
    private final List<MatcherEditor.Event<E>> matcherEventQueue = new LinkedList<MatcherEditor.Event<E>>();
    private MatcherEditor.Listener<E> queuingMatcherEditorListener = new QueuingMatcherEditorListener();
    private boolean isDrainingQueue = false;
    private Runnable drainMatcherEventQueueRunnable = new DrainMatcherEventQueueRunnable();
    private Executor executor;

    public ThreadedMatcherEditor(MatcherEditor<E> source) {
        this(source, DEFAULT_EXECUTOR);
    }

    public ThreadedMatcherEditor(MatcherEditor<E> source, Executor executor) {
        if (source == null) {
            throw new NullPointerException("source may not be null");
        }
        if (executor == null) {
            throw new NullPointerException("executor may not be null");
        }
        this.source = source;
        this.executor = executor;
        this.source.addMatcherEditorListener(this.queuingMatcherEditorListener);
    }

    @Override
    public Matcher<E> getMatcher() {
        return this.source.getMatcher();
    }

    public Executor getExecutor() {
        return this.executor;
    }

    protected MatcherEditor.Event<E> coalesceMatcherEvents(List<MatcherEditor.Event<E>> matcherEvents) {
        boolean changeType = false;
        MatcherEditor.Event<E> lastMatcherEvent = matcherEvents.get(matcherEvents.size() - 1);
        int lastMatcherEventType = lastMatcherEvent.getType();
        if (lastMatcherEventType != 0 && lastMatcherEventType != 1) {
            boolean constrained = false;
            boolean relaxed = false;
            Iterator<MatcherEditor.Event<E>> i = matcherEvents.iterator();
            while (i.hasNext()) {
                switch (i.next().getType()) {
                    case 0: {
                        relaxed = true;
                        break;
                    }
                    case 1: {
                        constrained = true;
                        break;
                    }
                    case 3: {
                        relaxed = true;
                        break;
                    }
                    case 2: {
                        constrained = true;
                        break;
                    }
                    case 4: {
                        relaxed = true;
                        constrained = true;
                    }
                }
            }
            changeType = constrained && relaxed;
        }
        return new MatcherEditor.Event<E>(this, changeType ? 4 : lastMatcherEventType, lastMatcherEvent.getMatcher());
    }

    protected void executeMatcherEventQueueRunnable(Runnable runnable) {
        this.executor.execute(runnable);
    }

    private class DrainMatcherEventQueueRunnable
    implements Runnable {
        private DrainMatcherEventQueueRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                MatcherEditor.Event matcherEvent;
                List list = ThreadedMatcherEditor.this.matcherEventQueue;
                synchronized (list) {
                    if (ThreadedMatcherEditor.this.matcherEventQueue.isEmpty()) {
                        ThreadedMatcherEditor.this.isDrainingQueue = false;
                        return;
                    }
                    matcherEvent = ThreadedMatcherEditor.this.coalesceMatcherEvents(ThreadedMatcherEditor.this.matcherEventQueue);
                    ThreadedMatcherEditor.this.matcherEventQueue.clear();
                }
                try {
                    ThreadedMatcherEditor.this.fireChangedMatcher(matcherEvent);
                }
                catch (Error e) {
                    List list2 = ThreadedMatcherEditor.this.matcherEventQueue;
                    synchronized (list2) {
                        ThreadedMatcherEditor.this.isDrainingQueue = false;
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    List list3 = ThreadedMatcherEditor.this.matcherEventQueue;
                    synchronized (list3) {
                        ThreadedMatcherEditor.this.isDrainingQueue = false;
                    }
                    throw e;
                }
            }
        }
    }

    private class QueuingMatcherEditorListener
    implements MatcherEditor.Listener<E> {
        private QueuingMatcherEditorListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void changedMatcher(MatcherEditor.Event<E> matcherEvent) {
            List list = ThreadedMatcherEditor.this.matcherEventQueue;
            synchronized (list) {
                ThreadedMatcherEditor.this.matcherEventQueue.add(matcherEvent);
                if (!ThreadedMatcherEditor.this.isDrainingQueue) {
                    ThreadedMatcherEditor.this.isDrainingQueue = true;
                    ThreadedMatcherEditor.this.executeMatcherEventQueueRunnable(ThreadedMatcherEditor.this.drainMatcherEventQueueRunnable);
                }
            }
        }
    }
}

