/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.scopes.DelicateScopeAPI;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\nH\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0017R+\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScopeImpl;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/FirSession;)V", "classIndex", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getClassIndex", "()Ljava/util/Map;", "classIndex$delegate", "Lkotlin/Lazy;", "getNestedClassSymbol", "name", "isEmpty", "", "getClassifierNames", "", "withReplacedSessionOrNull", "newSession", "newScopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "providers"})
public final class FirNestedClassifierScopeImpl
extends FirNestedClassifierScope {
    @NotNull
    private final Lazy classIndex$delegate;

    public FirNestedClassifierScopeImpl(@NotNull FirClass klass, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        super(klass, useSiteSession);
        this.classIndex$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, () -> FirNestedClassifierScopeImpl.classIndex_delegate$lambda$0(klass));
    }

    private final Map<Name, FirClassLikeSymbol<?>> getClassIndex() {
        Lazy lazy = this.classIndex$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @Nullable
    protected FirClassLikeSymbol<?> getNestedClassSymbol(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return this.getClassIndex().get(name2);
    }

    @Override
    public boolean isEmpty() {
        return this.getClassIndex().isEmpty();
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return this.getClassIndex().keySet();
    }

    @Override
    @DelicateScopeAPI
    @NotNull
    public FirNestedClassifierScopeImpl withReplacedSessionOrNull(@NotNull FirSession newSession, @NotNull ScopeSession newScopeSession) {
        Intrinsics.checkNotNullParameter(newSession, "newSession");
        Intrinsics.checkNotNullParameter(newScopeSession, "newScopeSession");
        return new FirNestedClassifierScopeImpl(this.getKlass(), newSession);
    }

    private static final Map classIndex_delegate$lambda$0(FirClass $klass) {
        Map result2 = new LinkedHashMap();
        for (FirDeclaration declaration : $klass.getDeclarations()) {
            FirDeclaration firDeclaration = declaration;
            if (firDeclaration instanceof FirRegularClass) {
                result2.put(((FirRegularClass)declaration).getName(), ((FirRegularClass)declaration).getSymbol());
                continue;
            }
            if (!(firDeclaration instanceof FirTypeAlias)) continue;
            result2.put(((FirTypeAlias)declaration).getName(), ((FirTypeAlias)declaration).getSymbol());
        }
        return result2;
    }
}

