/*
  ==============================================================================

   This file is part of the JUCE library.
   Copyright (c) 2022 - Raw Material Software Limited

   JUCE is an open source library subject to commercial or open-source
   licensing.

   By using JUCE, you agree to the terms of both the JUCE 7 End-User License
   Agreement and JUCE Privacy Policy.

   End User License Agreement: www.juce.com/juce-7-licence
   Privacy Policy: www.juce.com/juce-privacy-policy

   Or: You may also use this code under the terms of the GPL v3 (see
   www.gnu.org/licenses).

   JUCE IS PROVIDED "AS IS" WITHOUT ANY WARRANTY, AND ALL WARRANTIES, WHETHER
   EXPRESSED OR IMPLIED, INCLUDING MERCHANTABILITY AND FITNESS FOR PURPOSE, ARE
   DISCLAIMED.

  ==============================================================================
*/

namespace juce
{

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  METHOD (getProductId,                     "getProductId",                         "()Ljava/lang/String;") \
  METHOD (getTitle,                         "getTitle",                             "()Ljava/lang/String;") \
  METHOD (getDescription,                   "getDescription",                       "()Ljava/lang/String;") \
  METHOD (getOneTimePurchaseOfferDetails,   "getOneTimePurchaseOfferDetails",       "()Lcom/android/billingclient/api/ProductDetails$OneTimePurchaseOfferDetails;") \
  METHOD (getSubscriptionOfferDetails,      "getSubscriptionOfferDetails",          "()Ljava/util/List;")

DECLARE_JNI_CLASS (ProductDetails, "com/android/billingclient/api/ProductDetails")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  METHOD (getFormattedPrice,                "getFormattedPrice",                    "()Ljava/lang/String;") \
  METHOD (getPriceCurrencyCode,             "getPriceCurrencyCode",                 "()Ljava/lang/String;")

DECLARE_JNI_CLASS (OneTimePurchaseOfferDetails, "com/android/billingclient/api/ProductDetails$OneTimePurchaseOfferDetails")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  METHOD (getFormattedPrice,                "getFormattedPrice",                    "()Ljava/lang/String;") \
  METHOD (getPriceCurrencyCode,             "getPriceCurrencyCode",                 "()Ljava/lang/String;")

DECLARE_JNI_CLASS (PricingPhase, "com/android/billingclient/api/ProductDetails$PricingPhase")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  METHOD (getOfferToken,                "getOfferToken",                    "()Ljava/lang/String;") \
  METHOD (getPricingPhases,             "getPricingPhases",                 "()Lcom/android/billingclient/api/ProductDetails$PricingPhases;")

DECLARE_JNI_CLASS (SubscriptionOfferDetails, "com/android/billingclient/api/ProductDetails$SubscriptionOfferDetails")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  METHOD (getPricingPhaseList,             "getPricingPhaseList",                 "()Ljava/util/List;")

DECLARE_JNI_CLASS (PricingPhases, "com/android/billingclient/api/ProductDetails$PricingPhases")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  STATICMETHOD (newBuilder, "newBuilder", "()Lcom/android/billingclient/api/BillingFlowParams$ProductDetailsParams$Builder;")

DECLARE_JNI_CLASS (BillingFlowParamsProductDetailsParams, "com/android/billingclient/api/BillingFlowParams$ProductDetailsParams")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  STATICMETHOD (newBuilder, "newBuilder", "()Lcom/android/billingclient/api/BillingFlowParams$Builder;")

DECLARE_JNI_CLASS (BillingFlowParams, "com/android/billingclient/api/BillingFlowParams")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  STATICMETHOD (newBuilder, "newBuilder", "()Lcom/android/billingclient/api/BillingFlowParams$SubscriptionUpdateParams$Builder;")

DECLARE_JNI_CLASS (BillingFlowParamsSubscriptionUpdateParams, "com/android/billingclient/api/BillingFlowParams$SubscriptionUpdateParams")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  METHOD (build,                       "build",                       "()Lcom/android/billingclient/api/BillingFlowParams;") \
  METHOD (setSubscriptionUpdateParams, "setSubscriptionUpdateParams", "(Lcom/android/billingclient/api/BillingFlowParams$SubscriptionUpdateParams;)Lcom/android/billingclient/api/BillingFlowParams$Builder;") \
  METHOD (setProductDetailsParamsList, "setProductDetailsParamsList", "(Ljava/util/List;)Lcom/android/billingclient/api/BillingFlowParams$Builder;")

DECLARE_JNI_CLASS (BillingFlowParamsBuilder, "com/android/billingclient/api/BillingFlowParams$Builder")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  METHOD (build,                       "build",                       "()Lcom/android/billingclient/api/BillingFlowParams$SubscriptionUpdateParams;") \
  METHOD (setOldPurchaseToken,         "setOldPurchaseToken",         "(Ljava/lang/String;)Lcom/android/billingclient/api/BillingFlowParams$SubscriptionUpdateParams$Builder;") \
  METHOD (setReplaceProrationMode,     "setReplaceProrationMode",     "(I)Lcom/android/billingclient/api/BillingFlowParams$SubscriptionUpdateParams$Builder;")

DECLARE_JNI_CLASS (BillingFlowParamsSubscriptionUpdateParamsBuilder, "com/android/billingclient/api/BillingFlowParams$SubscriptionUpdateParams$Builder")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  METHOD (build,                       "build",                       "()Lcom/android/billingclient/api/BillingFlowParams$ProductDetailsParams;") \
  METHOD (setOfferToken,               "setOfferToken",               "(Ljava/lang/String;)Lcom/android/billingclient/api/BillingFlowParams$ProductDetailsParams$Builder;") \
  METHOD (setProductDetails,           "setProductDetails",           "(Lcom/android/billingclient/api/ProductDetails;)Lcom/android/billingclient/api/BillingFlowParams$ProductDetailsParams$Builder;")

DECLARE_JNI_CLASS (BillingFlowParamsProductDetailsParamsBuilder, "com/android/billingclient/api/BillingFlowParams$ProductDetailsParams$Builder")
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
  METHOD (getOrderId,       "getOrderId",       "()Ljava/lang/String;") \
  METHOD (getPurchaseState, "getPurchaseState", "()I") \
  METHOD (getProducts,      "getProducts",      "()Ljava/util/List;") \
  METHOD (getPackageName,   "getPackageName",   "()Ljava/lang/String;") \
  METHOD (getPurchaseTime,  "getPurchaseTime",  "()J") \
  METHOD (getPurchaseToken, "getPurchaseToken", "()Ljava/lang/String;")

DECLARE_JNI_CLASS (AndroidPurchase, "com/android/billingclient/api/Purchase")
#undef JNI_CLASS_MEMBERS

template <typename Fn>
static void callOnMainThread (Fn&& fn)
{
    if (MessageManager::getInstance()->isThisTheMessageThread())
        fn();
    else
        MessageManager::callAsync (std::forward<Fn> (fn));
}

inline StringArray javaListOfStringToJuceStringArray (const LocalRef<jobject>& javaArray)
{
    if (javaArray.get() == nullptr)
        return {};

    auto* env = getEnv();

    StringArray result;

    const auto size = env->CallIntMethod (javaArray, JavaList.size);

    for (int i = 0; i < size; ++i)
        result.add (juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (javaArray, JavaList.get, i) }.get()));

    return result;
}

//==============================================================================
constexpr uint8 juceBillingClientCompiled[]
{
    0x1f, 0x8b, 0x08, 0x08, 0xa4, 0x53, 0xd0, 0x62, 0x04, 0x03, 0x63, 0x6c,
    0x61, 0x73, 0x73, 0x65, 0x73, 0x2e, 0x64, 0x65, 0x78, 0x00, 0x9d, 0x5a,
    0x0b, 0x70, 0x54, 0xe7, 0x75, 0x3e, 0xff, 0xdd, 0xab, 0xf7, 0x4a, 0x5a,
    0xad, 0x1e, 0x2b, 0xf4, 0x5c, 0xed, 0x0a, 0x10, 0x42, 0xef, 0x87, 0x11,
    0xac, 0x82, 0x25, 0xc4, 0xc3, 0x02, 0x81, 0x01, 0x2d, 0xd8, 0x20, 0xa7,
    0xf6, 0xb2, 0x7b, 0x41, 0x0b, 0xab, 0xbb, 0xab, 0xdd, 0x15, 0x2f, 0xc7,
    0x94, 0x60, 0xec, 0x90, 0xc6, 0x8e, 0x69, 0x70, 0x1a, 0xc7, 0x66, 0xa6,
    0xee, 0x14, 0x4f, 0xdd, 0x09, 0xd3, 0x26, 0xa9, 0x99, 0x71, 0x62, 0xa6,
    0xf5, 0xc4, 0x6e, 0xea, 0x66, 0x68, 0x1b, 0x27, 0xa4, 0xd3, 0xcc, 0xb8,
    0x0d, 0xd3, 0x24, 0xa5, 0x9d, 0xe0, 0x3e, 0x5c, 0x77, 0xc6, 0x6d, 0x3d,
    0x6d, 0xbf, 0xf3, 0xdf, 0xff, 0xae, 0xae, 0x84, 0x5d, 0xc9, 0xbe, 0xf0,
    0xed, 0x39, 0xff, 0x39, 0xe7, 0x3f, 0xff, 0xf9, 0xcf, 0xff, 0xdc, 0xab,
    0x8d, 0x19, 0x27, 0x8b, 0x7b, 0xfa, 0x07, 0xe9, 0x77, 0x66, 0x07, 0x1f,
    0x79, 0xed, 0x89, 0xde, 0x5f, 0xfe, 0xe1, 0xa5, 0x7d, 0xcf, 0x5e, 0xf9,
    0x97, 0xa1, 0xef, 0xad, 0x2e, 0xdb, 0xfd, 0x83, 0xd1, 0x3f, 0xb8, 0x9d,
    0x7c, 0xb3, 0x8d, 0x28, 0x45, 0x44, 0x27, 0xf7, 0x0f, 0x78, 0x41, 0xac,
    0x07, 0xb2, 0xcb, 0xe0, 0x58, 0xde, 0x0f, 0xdc, 0xd2, 0x88, 0x36, 0x81,
    0x5e, 0x75, 0x11, 0xd5, 0x82, 0xbe, 0x99, 0x4f, 0xf4, 0x59, 0xd0, 0xf3,
    0x05, 0x44, 0x25, 0xa0, 0x89, 0x62, 0xa2, 0x0f, 0x1a, 0x88, 0x6e, 0xa0,
    0x70, 0xb8, 0x86, 0x28, 0x0e, 0xcc, 0x00, 0xb3, 0xc0, 0x29, 0xe0, 0x31,
    0xe0, 0x71, 0xe0, 0x49, 0xe0, 0x8b, 0xc0, 0xd3, 0xc0, 0x4b, 0xc0, 0xcb,
    0xc0, 0x55, 0xe0, 0x5b, 0xc0, 0x35, 0xe0, 0xbb, 0xc0, 0x8f, 0x80, 0x77,
    0x81, 0x1e, 0x1f, 0xd1, 0x31, 0xe0, 0x9b, 0xc0, 0x6d, 0xa0, 0x06, 0x0d,
    0xef, 0x05, 0x9e, 0x00, 0x5e, 0x01, 0x7e, 0x05, 0xd4, 0xad, 0x20, 0x9a,
    0x04, 0x1e, 0x07, 0xde, 0x00, 0xde, 0x05, 0xda, 0xea, 0x88, 0x0e, 0x01,
    0x2f, 0x01, 0xff, 0x0a, 0xf4, 0xd7, 0x13, 0x99, 0xc0, 0x55, 0xe0, 0xef,
    0x81, 0x02, 0xc4, 0xd9, 0x01, 0xec, 0x01, 0x8e, 0x03, 0x2f, 0x00, 0xdf,
    0x03, 0x6e, 0x03, 0xee, 0x46, 0xd8, 0x03, 0x0f, 0x02, 0x8f, 0x02, 0x2f,
    0x02, 0xaf, 0x03, 0x3f, 0x03, 0xfe, 0x1d, 0x28, 0x6a, 0x22, 0x6a, 0x04,
    0x06, 0x80, 0x1d, 0xc0, 0xc3, 0xc0, 0x09, 0xe0, 0x69, 0xe0, 0xb7, 0x81,
    0x6f, 0x01, 0xaf, 0x00, 0xdf, 0x01, 0xfe, 0x04, 0x78, 0x03, 0x78, 0x0b,
    0xf8, 0x0b, 0xe0, 0x26, 0xf0, 0x53, 0xe0, 0x67, 0xc0, 0x3f, 0x00, 0xff,
    0x04, 0xbc, 0x0b, 0x68, 0xcd, 0x44, 0x3e, 0x20, 0x08, 0x74, 0x03, 0x21,
    0x60, 0x1b, 0x10, 0x06, 0xe2, 0x80, 0x09, 0x1c, 0x07, 0xce, 0x00, 0x4f,
    0x03, 0xcf, 0x02, 0xbf, 0x07, 0x5c, 0x03, 0xbe, 0x0f, 0xfc, 0x1d, 0xf0,
    0x2e, 0x50, 0xee, 0x27, 0xaa, 0x02, 0xda, 0x81, 0x61, 0x60, 0x17, 0xf0,
    0x30, 0x90, 0x04, 0x4e, 0x02, 0x67, 0x80, 0x27, 0x80, 0xaf, 0x02, 0xbf,
    0x0f, 0x7c, 0x1b, 0xf8, 0x3e, 0xf0, 0x57, 0xc0, 0x4f, 0x81, 0x3b, 0xc0,
    0x7b, 0xc0, 0xff, 0x00, 0x7a, 0x0b, 0xe2, 0x01, 0x46, 0x81, 0x03, 0x40,
    0x02, 0x78, 0x12, 0x78, 0x1e, 0x78, 0x05, 0x78, 0x1b, 0xb8, 0x03, 0xe4,
    0x07, 0x88, 0x02, 0xc0, 0x3a, 0x60, 0x0f, 0x70, 0x14, 0x38, 0x0d, 0x3c,
    0x03, 0xfc, 0x2e, 0xf0, 0x32, 0x70, 0x0d, 0x78, 0x03, 0xf8, 0x31, 0xf0,
    0x73, 0xe0, 0x3f, 0x80, 0xff, 0x06, 0xdc, 0x41, 0xa2, 0x6a, 0xa0, 0x1e,
    0x68, 0x07, 0xfa, 0x80, 0x0d, 0xc0, 0x7d, 0xc0, 0x3e, 0xe0, 0x18, 0x70,
    0x02, 0xf8, 0x32, 0xf0, 0x22, 0x70, 0x0d, 0x78, 0x03, 0xf8, 0x6b, 0xe0,
    0x97, 0xc0, 0x7b, 0xc0, 0x7f, 0x02, 0x98, 0x8a, 0x84, 0x69, 0x48, 0xe5,
    0x80, 0x07, 0xa8, 0x00, 0x78, 0x22, 0x57, 0x02, 0x55, 0x40, 0x35, 0x80,
    0xe9, 0x44, 0x98, 0x42, 0x72, 0xee, 0x62, 0x8a, 0x10, 0xa6, 0x05, 0x61,
    0x2a, 0x10, 0x86, 0x94, 0x30, 0x04, 0x84, 0xf4, 0x91, 0x1f, 0x40, 0x97,
    0x08, 0xa1, 0x11, 0xdc, 0x52, 0x2b, 0xb0, 0x12, 0x58, 0x05, 0xac, 0x06,
    0xb0, 0x24, 0x68, 0x0d, 0xd0, 0x0e, 0xac, 0x05, 0x3a, 0x80, 0x4e, 0xa0,
    0x0b, 0xe8, 0x06, 0x7a, 0x80, 0x5e, 0xa0, 0x0f, 0xe0, 0x35, 0x33, 0x00,
    0x0c, 0x02, 0xf7, 0x00, 0xeb, 0x80, 0x21, 0x60, 0x03, 0x10, 0x02, 0x86,
    0x81, 0xcf, 0x00, 0xf7, 0x02, 0xe3, 0xc0, 0x0e, 0x60, 0x02, 0xe0, 0xbe,
    0xd8, 0x4f, 0x21, 0x18, 0x01, 0xb8, 0xd1, 0x01, 0x2c, 0x2f, 0xd2, 0x95,
    0xa2, 0x54, 0xf1, 0x55, 0x4a, 0x9e, 0xa7, 0xe4, 0x6c, 0xc3, 0x79, 0xe0,
    0x87, 0x6d, 0x98, 0x6f, 0x80, 0x8d, 0xcd, 0xb7, 0x2a, 0x7b, 0xf6, 0xcb,
    0x0f, 0xcb, 0x99, 0x67, 0xff, 0x65, 0xa0, 0x58, 0xba, 0xd4, 0xa1, 0xec,
    0x99, 0xb7, 0xfd, 0xbb, 0xc1, 0xf3, 0xc3, 0xf6, 0xcc, 0xdb, 0x72, 0x2e,
    0xf3, 0xc3, 0xed, 0x72, 0xae, 0xf9, 0x61, 0x19, 0xf3, 0x03, 0xaa, 0x2d,
    0xce, 0x3f, 0x3f, 0x2c, 0x67, 0xde, 0xae, 0x0b, 0xb5, 0x7c, 0xb8, 0x2e,
    0x8f, 0x0d, 0x3f, 0x1c, 0x03, 0xf3, 0xc3, 0xaa, 0x2e, 0x8f, 0x17, 0x3f,
    0x5c, 0x97, 0x79, 0xbb, 0x2e, 0x96, 0xbd, 0x7c, 0xb8, 0x2e, 0x8f, 0x0b,
    0x3f, 0x1c, 0x2f, 0xf3, 0x9b, 0x55, 0x5d, 0x1e, 0x27, 0x7e, 0xd8, 0xa6,
    0x53, 0x72, 0x56, 0xec, 0x3c, 0x56, 0x13, 0xb0, 0x61, 0x9f, 0xcc, 0x87,
    0xc1, 0xf3, 0x18, 0xf0, 0xf8, 0xf1, 0x33, 0x0a, 0x30, 0xff, 0x10, 0xe4,
    0x36, 0x3f, 0x0d, 0x7e, 0x44, 0xc9, 0xb3, 0xe0, 0xb7, 0x2a, 0x9e, 0x73,
    0xb5, 0x59, 0xf1, 0x9f, 0x73, 0xc8, 0xcf, 0x83, 0xdf, 0xa4, 0xe4, 0xef,
    0xa3, 0xd3, 0x36, 0xff, 0x94, 0xc3, 0xe6, 0x59, 0x07, 0x7f, 0xd9, 0xc1,
    0x5f, 0x01, 0x3f, 0xa6, 0xea, 0x5e, 0x75, 0xc8, 0x5f, 0x71, 0xf0, 0xd7,
    0xc1, 0xdb, 0x3e, 0xdf, 0x74, 0xf0, 0x37, 0x1c, 0xbc, 0x1b, 0xfc, 0x16,
    0xe5, 0xe7, 0x26, 0xf8, 0x6d, 0x8a, 0xbf, 0x05, 0xde, 0x8e, 0xff, 0x8e,
    0x83, 0x7f, 0xdf, 0x61, 0xf3, 0xa1, 0x83, 0x2f, 0xc4, 0x80, 0xd8, 0x75,
    0xab, 0xc0, 0xdf, 0xa7, 0xfc, 0xf8, 0xc1, 0xdb, 0x7e, 0x3a, 0xc0, 0xdb,
    0xf1, 0xbc, 0x83, 0xfe, 0xda, 0xf2, 0x01, 0x87, 0xcd, 0xb0, 0xc3, 0x66,
    0x33, 0x78, 0xdb, 0xe7, 0x04, 0x78, 0x9e, 0xff, 0xbc, 0x76, 0xf8, 0xd9,
    0x0e, 0x30, 0xff, 0x20, 0xe4, 0x36, 0xff, 0x08, 0xf8, 0x15, 0x58, 0x91,
    0x4f, 0x43, 0xbe, 0x02, 0xa3, 0x76, 0x51, 0xd1, 0x67, 0x25, 0xed, 0xa3,
    0xaf, 0x82, 0xd6, 0x29, 0x7d, 0x1d, 0x56, 0x1f, 0x97, 0xeb, 0x55, 0xb9,
    0x9e, 0x34, 0x7a, 0x46, 0x96, 0x8b, 0xe9, 0x2b, 0xa0, 0x0d, 0x4a, 0xde,
    0x80, 0x55, 0xfc, 0x9c, 0x2c, 0x77, 0xd1, 0xd7, 0x41, 0x1b, 0x95, 0xbc,
    0x09, 0x3b, 0xc1, 0x97, 0x51, 0x6e, 0x56, 0xe5, 0x66, 0xac, 0xf8, 0x4b,
    0xb2, 0xbc, 0x86, 0xbe, 0x06, 0xea, 0x57, 0x72, 0x3f, 0x76, 0x83, 0xdf,
    0x44, 0xb9, 0x05, 0xbb, 0x05, 0xdb, 0x07, 0x94, 0x3c, 0x80, 0x1d, 0xe8,
    0xb7, 0x50, 0x0e, 0x62, 0x65, 0xed, 0x97, 0x54, 0x90, 0x01, 0xaa, 0xe3,
    0xdf, 0x03, 0x92, 0xba, 0xe8, 0x0b, 0xa0, 0x79, 0x88, 0x2b, 0x09, 0x5a,
    0x00, 0x3b, 0x96, 0x17, 0x40, 0x32, 0x25, 0x69, 0x01, 0x3d, 0x0e, 0x5a,
    0x88, 0x9d, 0x67, 0xaf, 0xa4, 0xed, 0x74, 0x40, 0xd2, 0x66, 0x7a, 0x48,
    0xd2, 0x12, 0x3a, 0x2a, 0xe9, 0xbd, 0x74, 0x4c, 0xd2, 0x62, 0x9a, 0x91,
    0x34, 0x5f, 0xfa, 0x2b, 0xc4, 0xae, 0xf4, 0x98, 0x2c, 0x77, 0xd2, 0x59,
    0x49, 0x57, 0xd1, 0x17, 0x41, 0x79, 0x7d, 0x1c, 0x02, 0xdc, 0x58, 0x65,
    0xdc, 0x9e, 0x1b, 0x2b, 0x80, 0xe3, 0x28, 0x05, 0xc7, 0x71, 0x78, 0x80,
    0x47, 0x24, 0xad, 0xa7, 0x88, 0xa4, 0xf7, 0xd2, 0x11, 0xd0, 0x4a, 0xac,
    0x5a, 0xb6, 0xaf, 0x84, 0xc5, 0x13, 0xa0, 0x55, 0xe0, 0xb8, 0x5c, 0x85,
    0x1d, 0xf6, 0xbc, 0xa2, 0x4f, 0x82, 0x56, 0x63, 0xd7, 0x65, 0x3f, 0x35,
    0xd8, 0x85, 0x99, 0xfa, 0xb0, 0xd3, 0xb2, 0x9d, 0x0f, 0xff, 0x58, 0x5f,
    0x0b, 0x0d, 0xcb, 0x57, 0x60, 0x17, 0x74, 0x49, 0xba, 0x86, 0xe6, 0x40,
    0xeb, 0x68, 0xbd, 0x2c, 0xd7, 0x21, 0xe3, 0xe7, 0x50, 0xae, 0xc7, 0xf8,
    0xb1, 0xbe, 0x5e, 0x95, 0x1b, 0xb0, 0x7b, 0x72, 0xb9, 0x01, 0xe3, 0x70,
    0x02, 0xb4, 0x11, 0xb3, 0x83, 0xcb, 0x8d, 0x4a, 0xdf, 0x84, 0xf9, 0xc0,
    0xe5, 0x26, 0x8c, 0x47, 0x16, 0xb4, 0x19, 0x3b, 0x2e, 0x97, 0x9b, 0x95,
    0xde, 0x8f, 0x5d, 0x98, 0xcb, 0x7e, 0x94, 0xd3, 0x92, 0xae, 0xa6, 0x0c,
    0x68, 0x0b, 0x56, 0x39, 0xcb, 0x5b, 0xb0, 0x6b, 0xcc, 0x82, 0x06, 0xb0,
    0x63, 0x73, 0x39, 0xa0, 0xea, 0x05, 0xb1, 0xfb, 0x73, 0x39, 0x48, 0x45,
    0xb4, 0x53, 0xd2, 0x75, 0xb4, 0x4b, 0x52, 0x41, 0xf7, 0x4b, 0xda, 0x4b,
    0xbb, 0x25, 0xdd, 0x40, 0x0f, 0x4a, 0x1a, 0xa2, 0x83, 0x92, 0x5a, 0xe3,
    0x14, 0xc4, 0x4e, 0xff, 0x59, 0x59, 0xae, 0xa6, 0x87, 0x25, 0x5d, 0x4b,
    0x51, 0x49, 0xef, 0xa5, 0x69, 0x45, 0x79, 0xfc, 0x82, 0xf8, 0xc7, 0xe3,
    0x17, 0x54, 0xf1, 0x05, 0x11, 0x0f, 0xc7, 0x17, 0x44, 0x7f, 0x8f, 0x4b,
    0x1a, 0xa0, 0x93, 0x92, 0xfa, 0xe9, 0x94, 0xa4, 0x2d, 0x74, 0x5a, 0xc9,
    0x1f, 0x95, 0xf4, 0x33, 0xf4, 0x39, 0x49, 0x37, 0xd2, 0x19, 0x49, 0x9b,
    0xe9, 0xd7, 0x25, 0x1d, 0xa6, 0xcf, 0x83, 0xae, 0x86, 0x5f, 0xee, 0x47,
    0x9b, 0xea, 0x57, 0xbb, 0x2a, 0xb7, 0xd3, 0x08, 0x4d, 0x42, 0xde, 0x8e,
    0x5d, 0x2e, 0x0c, 0xba, 0x16, 0x19, 0xdc, 0x07, 0xda, 0x89, 0xdd, 0x30,
    0x26, 0xe9, 0x0a, 0x79, 0xf7, 0xeb, 0x52, 0xfa, 0x2e, 0x8c, 0xd4, 0xaf,
    0x41, 0xde, 0x05, 0x7d, 0x5c, 0xd2, 0x06, 0x4a, 0x48, 0x4a, 0x74, 0x41,
    0xd2, 0x46, 0xfa, 0x0d, 0x50, 0x3e, 0x5b, 0xf9, 0x59, 0x0d, 0xdc, 0xc4,
    0x5e, 0x50, 0x04, 0x5a, 0x8b, 0xc2, 0xaa, 0x95, 0x2c, 0xb5, 0xce, 0x5d,
    0xa6, 0xac, 0xe7, 0xbd, 0x82, 0xf5, 0x3d, 0x28, 0x8c, 0x28, 0x3d, 0x9f,
    0xc9, 0xfc, 0x38, 0xf5, 0x23, 0x28, 0x84, 0x95, 0x1e, 0x57, 0x34, 0xf9,
    0xb0, 0xfe, 0x17, 0xaa, 0xfe, 0x6e, 0x14, 0x8e, 0x29, 0x3d, 0x9f, 0xe7,
    0xfc, 0x38, 0xeb, 0x4f, 0xa3, 0x70, 0x4e, 0xe9, 0xf9, 0xac, 0xe7, 0x87,
    0xf5, 0x77, 0x54, 0xfd, 0x93, 0x28, 0x5c, 0x52, 0xfa, 0x66, 0xa9, 0x5d,
    0x58, 0xff, 0x02, 0xf4, 0x57, 0x94, 0xde, 0xef, 0xd0, 0xf3, 0xde, 0xce,
    0xf1, 0x3f, 0x07, 0xfd, 0x6b, 0x4a, 0xdf, 0xe2, 0xd0, 0x7f, 0xa8, 0xf4,
    0x2f, 0x43, 0xff, 0x63, 0xa5, 0x0f, 0x38, 0xf4, 0x76, 0xff, 0x5f, 0x85,
    0xfe, 0x17, 0x4a, 0x1f, 0x84, 0x5e, 0x00, 0x10, 0x91, 0x5e, 0x6d, 0xf9,
    0x7f, 0x0b, 0x85, 0x0f, 0x94, 0x3e, 0x0f, 0xfb, 0x04, 0xeb, 0x7f, 0x50,
    0x69, 0x9d, 0x67, 0x53, 0x28, 0x4c, 0x69, 0x82, 0xa6, 0x5c, 0x2e, 0x9a,
    0xd2, 0x35, 0x4a, 0x79, 0x78, 0x76, 0x96, 0xe1, 0x1e, 0xe1, 0x92, 0xf7,
    0x85, 0x1f, 0xc1, 0x6e, 0x2d, 0x24, 0xa6, 0xc7, 0x83, 0x72, 0xb1, 0xbe,
    0x5e, 0x6f, 0xa0, 0xf0, 0x80, 0xa0, 0xb4, 0xff, 0x01, 0x8c, 0x7b, 0x78,
    0x00, 0x99, 0x1d, 0x74, 0x51, 0xb8, 0x47, 0x23, 0x6f, 0x45, 0xda, 0xc3,
    0x3b, 0x50, 0xb1, 0x96, 0xee, 0x79, 0x88, 0x3c, 0x9a, 0x9b, 0xc2, 0xbd,
    0x82, 0xcc, 0x91, 0x09, 0x0a, 0x7b, 0xda, 0x4a, 0x6c, 0x4b, 0xaf, 0x43,
    0x5a, 0x06, 0x6b, 0x17, 0xfe, 0x71, 0x3c, 0x7f, 0x8b, 0x76, 0xf8, 0x2e,
    0x31, 0x25, 0x74, 0xc4, 0x93, 0x97, 0x8b, 0x83, 0xa3, 0xd5, 0x21, 0xff,
    0x39, 0xf4, 0x9c, 0x7b, 0xaf, 0x3f, 0x88, 0x15, 0xee, 0x15, 0x75, 0xda,
    0x61, 0xda, 0xa9, 0x91, 0xf0, 0x56, 0xd4, 0x69, 0x5f, 0x92, 0x5c, 0x78,
    0x54, 0xa7, 0xf0, 0xa6, 0x3c, 0x9a, 0xf5, 0x84, 0x61, 0xe7, 0xa6, 0x80,
    0xab, 0x1d, 0x5e, 0xf6, 0xc0, 0x3f, 0xc7, 0xd0, 0xd2, 0x53, 0x06, 0x3f,
    0xba, 0x6c, 0xeb, 0x36, 0x7c, 0x15, 0xcb, 0xb6, 0xf2, 0xd1, 0x56, 0x01,
    0xfa, 0x5e, 0x98, 0x6b, 0x8f, 0x2d, 0x78, 0xbe, 0xff, 0x33, 0x6c, 0x38,
    0xbe, 0x70, 0x4f, 0x3e, 0x3c, 0xae, 0x93, 0x1e, 0xc3, 0xbd, 0x05, 0x14,
    0xee, 0x2b, 0x24, 0xb3, 0xa7, 0x04, 0xfd, 0x9b, 0xf7, 0xf7, 0x5e, 0xce,
    0x5f, 0x11, 0xfc, 0x15, 0xc3, 0x5f, 0x49, 0xce, 0x5f, 0x9e, 0xec, 0x21,
    0xee, 0x99, 0xb0, 0xe1, 0x31, 0xe1, 0x3c, 0xba, 0xa8, 0xd8, 0xb5, 0xde,
    0x55, 0x47, 0xe1, 0x60, 0x31, 0x99, 0xfe, 0x49, 0x9c, 0xd7, 0xe1, 0x60,
    0x11, 0x85, 0x5b, 0x4b, 0xc8, 0xeb, 0xe1, 0x1c, 0x22, 0xcf, 0x82, 0x73,
    0xa8, 0x0b, 0xb7, 0x1e, 0xf6, 0x17, 0xd3, 0x6c, 0xcf, 0x10, 0x6c, 0xda,
    0x8a, 0xd8, 0xca, 0xeb, 0x90, 0x70, 0x7c, 0x1a, 0xfe, 0x71, 0xfe, 0x74,
    0xcc, 0x95, 0x7c, 0xd0, 0x29, 0xe1, 0xce, 0xb5, 0x6d, 0xf7, 0xa5, 0x08,
    0x3a, 0x9e, 0xf7, 0xff, 0x4f, 0xee, 0x7a, 0xdd, 0xf3, 0x79, 0xd3, 0xac,
    0xbc, 0x69, 0xb2, 0x5d, 0x81, 0x7e, 0xda, 0x6d, 0x94, 0xe5, 0xda, 0x28,
    0xcd, 0xb5, 0xc1, 0xf3, 0x24, 0x0f, 0xbe, 0xab, 0xa0, 0xe3, 0x7b, 0x55,
    0x78, 0xb0, 0x94, 0xc2, 0xfb, 0xca, 0x90, 0x37, 0x50, 0x64, 0x70, 0xd6,
    0xb3, 0x1e, 0xd2, 0x12, 0xe4, 0x0d, 0xe5, 0x40, 0x79, 0x6e, 0x1e, 0xcd,
    0x86, 0x37, 0x50, 0x5e, 0xcb, 0x7c, 0x0e, 0xeb, 0x51, 0xdf, 0x1a, 0x93,
    0x32, 0xe4, 0xd0, 0x83, 0x1c, 0x96, 0xe7, 0xda, 0xb0, 0xfb, 0x11, 0x84,
    0x0d, 0xaf, 0xcf, 0x59, 0x9c, 0x21, 0x3c, 0xc2, 0xe1, 0x5e, 0x0f, 0xf2,
    0xe7, 0xc5, 0xc9, 0xe2, 0x86, 0x5f, 0xbe, 0xb5, 0xb3, 0x8c, 0xdb, 0x5c,
    0x87, 0x9c, 0xb8, 0x45, 0x40, 0x6b, 0xa2, 0x94, 0x7f, 0x2d, 0xe6, 0x8b,
    0xd9, 0x53, 0x40, 0xdc, 0x93, 0xf9, 0xf9, 0xb6, 0x16, 0xbe, 0xac, 0xf9,
    0x56, 0x81, 0xf6, 0xbc, 0xb9, 0xb6, 0x84, 0xcc, 0x26, 0x0c, 0xf1, 0x70,
    0x5e, 0x9d, 0x39, 0xee, 0x43, 0x1d, 0x2e, 0xf3, 0x18, 0x0a, 0x8c, 0xd1,
    0x7a, 0x81, 0x51, 0x13, 0x5e, 0x1a, 0x12, 0x79, 0x94, 0xf6, 0xec, 0x86,
    0x6c, 0x3e, 0x57, 0x1b, 0x60, 0x6b, 0x8d, 0x47, 0x65, 0xce, 0x37, 0xe7,
    0xd1, 0x7e, 0x6c, 0xdf, 0xf6, 0xfc, 0x1f, 0xc9, 0xc5, 0x53, 0x85, 0x78,
    0xaa, 0x73, 0x75, 0xec, 0xbe, 0x6f, 0x83, 0xbe, 0x05, 0x95, 0x67, 0xa5,
    0x0f, 0xee, 0x67, 0x35, 0xe2, 0xa8, 0x46, 0x9b, 0x6e, 0x61, 0xfa, 0x85,
    0xca, 0x01, 0x7b, 0x67, 0x5d, 0x95, 0x23, 0x07, 0x2d, 0xc8, 0x41, 0x9f,
    0xcc, 0x41, 0x7e, 0x2e, 0x07, 0x42, 0x7a, 0xb9, 0x1f, 0x3e, 0xbd, 0xa8,
    0x11, 0xc6, 0x65, 0xac, 0x4e, 0x3c, 0x85, 0x5c, 0x16, 0x29, 0x3f, 0x7c,
    0x9a, 0x17, 0xe3, 0x64, 0xd5, 0x31, 0x23, 0xdb, 0x90, 0x9d, 0x72, 0xd8,
    0x5b, 0x99, 0x99, 0x44, 0x9d, 0x02, 0xae, 0xe3, 0xa9, 0x41, 0xfb, 0x3c,
    0x62, 0xc5, 0xf2, 0x7b, 0x93, 0x9d, 0xb7, 0x07, 0xa0, 0xe7, 0xf5, 0x13,
    0xc6, 0x79, 0xcd, 0x23, 0x52, 0x88, 0x12, 0xf7, 0xfa, 0x21, 0xc8, 0xbb,
    0x40, 0x03, 0x38, 0x31, 0x78, 0x55, 0xa2, 0x37, 0x11, 0xaf, 0x36, 0xe8,
    0xad, 0xa3, 0xad, 0xae, 0x7c, 0x6d, 0x56, 0xce, 0x4f, 0xb7, 0x6e, 0xfa,
    0xeb, 0x70, 0xde, 0xba, 0x5d, 0xa6, 0xbf, 0x1e, 0xa7, 0x18, 0xa8, 0x67,
    0x05, 0xea, 0x73, 0x79, 0x2f, 0xce, 0xed, 0xbf, 0xd1, 0x34, 0xd1, 0x76,
    0x7b, 0x56, 0xce, 0x01, 0x77, 0xbe, 0xe9, 0xaf, 0x45, 0x86, 0x41, 0x3d,
    0x3e, 0x49, 0x2b, 0xf2, 0xad, 0x9d, 0x84, 0xc8, 0x8e, 0x61, 0xd2, 0xef,
    0x43, 0x7f, 0xac, 0xbb, 0x13, 0xc7, 0x70, 0x04, 0x31, 0xf0, 0xf9, 0x60,
    0xed, 0x71, 0x07, 0x35, 0x1f, 0xb2, 0xe4, 0xb6, 0x32, 0xe8, 0xe1, 0x3c,
    0x73, 0x26, 0x79, 0xbf, 0x01, 0xf5, 0xb0, 0x2f, 0xb7, 0x98, 0x12, 0xe8,
    0xa5, 0xbf, 0x1c, 0xbc, 0x3d, 0x77, 0xb8, 0x6f, 0x19, 0xf8, 0xe1, 0x3d,
    0x29, 0xd5, 0xb3, 0x4b, 0xee, 0x03, 0xbc, 0xa7, 0xf2, 0x1a, 0x38, 0x6d,
    0xcb, 0xc3, 0xe3, 0xe4, 0xe9, 0xe3, 0xb9, 0xad, 0xc9, 0x5c, 0x9c, 0x83,
    0x9c, 0xef, 0x4f, 0x9c, 0xe7, 0x80, 0xf0, 0xa3, 0x5e, 0x37, 0xb5, 0xa0,
    0x4f, 0xe5, 0x88, 0x8e, 0xfd, 0xea, 0xb0, 0x62, 0x7f, 0x17, 0x60, 0xc7,
    0xe7, 0x01, 0xdf, 0x21, 0x52, 0x23, 0x9d, 0xe4, 0x09, 0xa6, 0xfc, 0x1b,
    0x55, 0xdb, 0x76, 0xfe, 0x9f, 0x81, 0x0d, 0xcf, 0x2b, 0x2b, 0xff, 0x3c,
    0x83, 0xcb, 0x64, 0x86, 0xb9, 0x7f, 0x97, 0xa0, 0xe3, 0xfe, 0x3a, 0xc7,
    0x66, 0x08, 0xd6, 0x3c, 0x37, 0x35, 0x6a, 0xd3, 0x53, 0xfe, 0x10, 0xe6,
    0x50, 0x19, 0x62, 0xb5, 0xd6, 0xec, 0x0b, 0xb0, 0xe7, 0xf5, 0xc4, 0x79,
    0x4a, 0x85, 0xef, 0x23, 0xad, 0x77, 0xbd, 0xee, 0xc3, 0xa8, 0x56, 0x41,
    0x5f, 0xac, 0x7b, 0x3d, 0xfd, 0x3a, 0xd6, 0x17, 0xc6, 0x99, 0x4b, 0xeb,
    0xf5, 0x62, 0x0a, 0xe8, 0x01, 0xc4, 0x3e, 0x40, 0xad, 0x2e, 0x8e, 0x6b,
    0xd3, 0x82, 0xd8, 0x5f, 0xca, 0xc5, 0x5e, 0x8f, 0xd8, 0x57, 0xa2, 0xff,
    0xf3, 0xb1, 0xdb, 0x73, 0x03, 0x4d, 0xa1, 0x37, 0xf3, 0x6b, 0x8a, 0xcb,
    0xfc, 0xd8, 0x32, 0x3b, 0xae, 0x6f, 0xc0, 0x17, 0xcf, 0x75, 0x7b, 0xaf,
    0x1c, 0xd2, 0x6b, 0xd0, 0x87, 0x83, 0xc8, 0x91, 0x5b, 0x4f, 0x7b, 0xf6,
    0x81, 0x16, 0xe3, 0x16, 0xe8, 0x85, 0x6c, 0x3f, 0xcb, 0x90, 0x2d, 0x0f,
    0xe2, 0x1a, 0x21, 0xcd, 0xd5, 0xf6, 0x6f, 0xdc, 0x17, 0xaf, 0x9e, 0x9a,
    0x44, 0x6f, 0x46, 0xad, 0x31, 0xb3, 0xc6, 0xe0, 0x5a, 0x2e, 0xbe, 0x3a,
    0xd8, 0x06, 0x31, 0x6e, 0xf3, 0xf1, 0x15, 0xc0, 0x0b, 0x8f, 0xdf, 0x77,
    0x61, 0xc3, 0xc7, 0xe4, 0x50, 0x1e, 0xee, 0x7a, 0x9e, 0x03, 0x90, 0x71,
    0x3b, 0x2e, 0x6a, 0xf3, 0x85, 0x7b, 0x6a, 0x70, 0xe6, 0xa4, 0xfd, 0x0f,
    0xe2, 0x9e, 0xea, 0x16, 0xcd, 0x62, 0x0d, 0x76, 0x94, 0x7b, 0x69, 0x4c,
    0xf0, 0x1e, 0x83, 0x7b, 0xce, 0xbe, 0x16, 0xea, 0xdb, 0x6a, 0x62, 0xc7,
    0xf3, 0x68, 0x6d, 0xf9, 0x93, 0x03, 0xc8, 0xe6, 0xc8, 0x36, 0x1a, 0x33,
    0xb8, 0x7d, 0x1e, 0x37, 0x1e, 0x9b, 0x3f, 0xcd, 0xb5, 0xdf, 0x88, 0xf5,
    0xb8, 0x86, 0x23, 0xce, 0x8d, 0xad, 0x7d, 0xd6, 0xfe, 0x39, 0x6c, 0x3a,
    0xb9, 0x7d, 0x7d, 0xb5, 0x6c, 0xdf, 0xea, 0x27, 0xda, 0x6f, 0xe6, 0xf6,
    0x67, 0xc9, 0x0f, 0x9d, 0x5b, 0x78, 0x35, 0x8e, 0xa3, 0x95, 0xdc, 0x5a,
    0xb3, 0x86, 0x38, 0xfc, 0xcd, 0xc8, 0x15, 0xcf, 0xd8, 0x26, 0xb4, 0xc4,
    0xf1, 0x34, 0xa0, 0xf5, 0xd5, 0xd4, 0xb7, 0xc5, 0xc4, 0x89, 0x27, 0xe3,
    0xc1, 0x6b, 0xb0, 0xd4, 0xc8, 0x76, 0x72, 0xed, 0x29, 0xa3, 0xed, 0x3c,
    0xcd, 0x30, 0x6e, 0x38, 0x39, 0xa9, 0x2c, 0x7e, 0x50, 0x54, 0x7b, 0xe8,
    0x00, 0xb3, 0xb8, 0x6a, 0xbe, 0x4d, 0x51, 0x9e, 0xdb, 0x65, 0x74, 0x18,
    0x48, 0x5a, 0x6c, 0x5a, 0x99, 0x55, 0x7a, 0xe8, 0x0c, 0x2f, 0x81, 0x73,
    0x02, 0x66, 0xcf, 0x08, 0x66, 0xbf, 0x22, 0x64, 0xbd, 0x0b, 0xc2, 0xb2,
    0xfc, 0x12, 0x64, 0xf1, 0x1d, 0x13, 0xf4, 0x9a, 0x25, 0xfe, 0x63, 0xb6,
    0x89, 0xef, 0xa0, 0x9f, 0x48, 0xdb, 0xb7, 0x2d, 0xe1, 0x4d, 0xc8, 0x84,
    0xb7, 0x1c, 0xdb, 0x4a, 0x19, 0x2e, 0xd9, 0x65, 0xd4, 0xc4, 0x7e, 0x36,
    0xb2, 0x9b, 0xa9, 0xb8, 0xa8, 0xf1, 0xd0, 0x4a, 0x66, 0x87, 0xbb, 0x76,
    0xec, 0xd8, 0x71, 0x94, 0x9a, 0x2c, 0xb7, 0x4d, 0x2a, 0xde, 0xd7, 0xa4,
    0x9f, 0x0b, 0x96, 0x9f, 0x5e, 0x54, 0xfb, 0x23, 0x16, 0x7c, 0x61, 0x82,
    0x6e, 0x48, 0xd1, 0xe9, 0x93, 0x71, 0x8a, 0xca, 0x78, 0x5e, 0x90, 0xe5,
    0x63, 0xff, 0xbb, 0x93, 0x0e, 0xb0, 0xf7, 0x6d, 0xec, 0xa6, 0xe3, 0xb4,
    0xa8, 0x71, 0xe3, 0x72, 0x5b, 0x46, 0x09, 0xd8, 0xa0, 0xd4, 0x84, 0x97,
    0x10, 0x3c, 0xe7, 0xca, 0x01, 0xa6, 0x6d, 0x8a, 0xf2, 0x7e, 0xc5, 0x65,
    0x1e, 0x37, 0xa6, 0xbc, 0x16, 0x99, 0xf2, 0x7a, 0x43, 0x4d, 0xcc, 0xb8,
    0x22, 0x59, 0x0e, 0x2a, 0xf9, 0x1a, 0x45, 0xb9, 0x11, 0xb6, 0xe3, 0xbd,
    0x94, 0xed, 0x34, 0xcc, 0x1b, 0x2e, 0x77, 0xa9, 0x72, 0x1f, 0xee, 0xe2,
    0x5c, 0xe6, 0x87, 0xf5, 0xfc, 0x70, 0xb9, 0x17, 0xb0, 0xea, 0xf2, 0xaa,
    0xb5, 0x79, 0xf6, 0x6a, 0xd9, 0x09, 0x78, 0x60, 0x7b, 0xde, 0x8b, 0x98,
    0xe6, 0x21, 0x12, 0xae, 0xc7, 0x7b, 0x09, 0x97, 0x4b, 0xe0, 0xd7, 0xa2,
    0x96, 0x5d, 0x29, 0x22, 0xe7, 0x32, 0x7b, 0x63, 0xca, 0xdf, 0xa5, 0x98,
    0xd6, 0x62, 0x27, 0xe6, 0x7a, 0x7c, 0x37, 0x65, 0x1a, 0x00, 0x38, 0xb1,
    0x41, 0x94, 0xb8, 0x35, 0x8e, 0x21, 0x08, 0x4b, 0xde, 0xcd, 0xd9, 0x1e,
    0xab, 0x43, 0xd1, 0x36, 0xa5, 0x5b, 0xe3, 0xb0, 0x6b, 0x97, 0xfd, 0xb2,
    0xea, 0x74, 0xc9, 0x77, 0x59, 0x96, 0xaf, 0x2e, 0x9c, 0x31, 0x56, 0x1c,
    0x7c, 0x43, 0x63, 0x3f, 0x5c, 0x8b, 0x29, 0x5b, 0x71, 0xbb, 0x7d, 0x00,
    0xd7, 0x63, 0x3b, 0xce, 0x0d, 0xcb, 0xf8, 0x4e, 0xc4, 0xb4, 0x83, 0x44,
    0x1b, 0x69, 0x6d, 0xdb, 0x81, 0x29, 0xca, 0x1f, 0x8e, 0x9b, 0xf1, 0xec,
    0x46, 0xd2, 0x36, 0x86, 0x48, 0xdf, 0x18, 0x5a, 0xb3, 0x9f, 0xc4, 0x38,
    0x09, 0xe8, 0xb6, 0x4f, 0x50, 0xcd, 0xf6, 0xb9, 0xa8, 0xb1, 0x29, 0x9e,
    0x48, 0xc4, 0xcd, 0x23, 0x63, 0x89, 0xb8, 0x61, 0x66, 0xbb, 0x8e, 0x46,
    0x8e, 0x47, 0x48, 0x4c, 0x90, 0x36, 0x31, 0x4e, 0xae, 0x89, 0xf1, 0x71,
    0x30, 0x13, 0x60, 0xf0, 0x51, 0x33, 0x11, 0x31, 0x63, 0xe9, 0x64, 0x3c,
    0xd6, 0x1d, 0x49, 0xa5, 0xba, 0x47, 0xa3, 0xd9, 0xf8, 0xf1, 0x78, 0xf6,
    0x54, 0x88, 0x56, 0xe4, 0xe4, 0xd1, 0xa4, 0x99, 0x85, 0x8f, 0xee, 0x31,
    0xa6, 0x27, 0xb3, 0x21, 0x1a, 0x9d, 0x88, 0x26, 0x67, 0xba, 0xed, 0x6a,
    0x87, 0xac, 0x86, 0xa2, 0xb2, 0x21, 0x38, 0x89, 0xc3, 0xc9, 0x31, 0x33,
    0x79, 0x22, 0x61, 0xc4, 0x8e, 0x18, 0xbb, 0xe7, 0xd2, 0xd1, 0xe9, 0x48,
    0xc6, 0xd8, 0x1d, 0x49, 0x47, 0x66, 0x32, 0xad, 0x9b, 0xe6, 0xe2, 0x89,
    0x98, 0x91, 0x0e, 0xd1, 0xfa, 0x4f, 0xeb, 0x22, 0x44, 0x63, 0x9f, 0xbc,
    0xea, 0x5e, 0x23, 0x93, 0x4a, 0x9a, 0x19, 0x63, 0x22, 0x9e, 0x41, 0x4f,
    0xb8, 0xfd, 0xc1, 0x25, 0x9c, 0x2c, 0xc8, 0xde, 0x7c, 0xd8, 0x9d, 0x9f,
    0xa4, 0x5a, 0x88, 0x36, 0x7c, 0x12, 0xf3, 0xc9, 0x6c, 0x24, 0xeb, 0x88,
    0xb0, 0x77, 0x79, 0x75, 0xb7, 0x26, 0x92, 0x27, 0xac, 0xe4, 0x86, 0x68,
    0x99, 0xd1, 0x21, 0x1b, 0x73, 0x09, 0x0c, 0xe3, 0x52, 0x39, 0xc0, 0x78,
    0x67, 0xe6, 0x66, 0xee, 0x1a, 0xba, 0xa5, 0x5a, 0x59, 0x50, 0x2d, 0x44,
    0xeb, 0x96, 0xe8, 0x87, 0x32, 0xbf, 0x7b, 0x88, 0xba, 0x96, 0xa8, 0xb8,
    0x3b, 0x9d, 0x8c, 0xcd, 0x45, 0xb3, 0x9b, 0x8d, 0x6c, 0x24, 0x9e, 0xc8,
    0x84, 0x68, 0xe3, 0x27, 0xb2, 0xbf, 0xbb, 0xbd, 0xb6, 0xa5, 0xea, 0xab,
    0xa9, 0xbc, 0xf4, 0xe4, 0xb5, 0x27, 0x7d, 0xe6, 0xee, 0x46, 0x86, 0x96,
    0xd9, 0x48, 0x66, 0x5f, 0x2a, 0x86, 0xe9, 0x10, 0x9b, 0x9f, 0xb1, 0x4b,
    0x2d, 0xba, 0x3d, 0x73, 0x46, 0xfa, 0xd4, 0xc2, 0x9c, 0x2c, 0x5e, 0x74,
    0xe3, 0x4b, 0x34, 0xfe, 0xf1, 0x2e, 0x94, 0xdf, 0xf9, 0x85, 0xf0, 0xe9,
    0xa3, 0x51, 0xae, 0x96, 0xce, 0xe2, 0xc7, 0x46, 0x13, 0xa2, 0xe1, 0x65,
    0x75, 0x44, 0x8d, 0x57, 0x66, 0x71, 0x1a, 0x06, 0x3e, 0x45, 0xed, 0x10,
    0x05, 0x65, 0xad, 0xf4, 0x4c, 0x26, 0xd1, 0x7d, 0x14, 0xdb, 0x6b, 0xf7,
    0x5d, 0x7b, 0x6c, 0x6b, 0xef, 0x72, 0x8c, 0xfa, 0x96, 0x63, 0xd4, 0xbf,
    0x1c, 0xa3, 0x81, 0xe5, 0x18, 0x0d, 0x86, 0x68, 0xe5, 0x92, 0x81, 0xdf,
    0xb3, 0xbc, 0xd0, 0xef, 0x59, 0x4e, 0x83, 0xeb, 0x96, 0xd3, 0xe0, 0xd0,
    0xf2, 0x1a, 0x1c, 0xc2, 0x5d, 0x7c, 0xa9, 0xe0, 0x39, 0xa6, 0x58, 0x24,
    0x71, 0x3c, 0x7e, 0x0c, 0x07, 0x92, 0x99, 0xc4, 0x1e, 0x1a, 0x4f, 0x9a,
    0xdd, 0x5b, 0xcc, 0x68, 0x22, 0x99, 0xc1, 0xf1, 0xb7, 0xd3, 0xc8, 0x4e,
    0x27, 0x63, 0x21, 0x6a, 0xfa, 0x08, 0xa3, 0x71, 0x13, 0x47, 0xc1, 0x58,
    0x22, 0x92, 0xc1, 0xe6, 0xd1, 0xf8, 0x11, 0xfa, 0xc9, 0xf8, 0x11, 0x33,
    0x92, 0x9d, 0x4b, 0x1b, 0x21, 0xf2, 0x4e, 0xf0, 0x01, 0xda, 0x9d, 0x88,
    0x98, 0x47, 0xba, 0xef, 0x3f, 0x74, 0xd4, 0x88, 0x62, 0xfb, 0xac, 0x72,
    0xc8, 0xf6, 0xce, 0x99, 0x66, 0xe4, 0x50, 0x62, 0x91, 0xe5, 0x64, 0x36,
    0x8d, 0x10, 0x42, 0x54, 0x6d, 0x59, 0xce, 0x65, 0xe3, 0x89, 0xee, 0xd1,
    0x74, 0x3a, 0x72, 0x8a, 0x57, 0xf5, 0xc7, 0x88, 0x87, 0xed, 0xb6, 0xe6,
    0xad, 0x11, 0x5e, 0x8d, 0xc3, 0xc3, 0x58, 0x32, 0x91, 0x40, 0x00, 0xe8,
    0x66, 0x2e, 0x06, 0x69, 0x3b, 0x9e, 0x35, 0xd2, 0x91, 0x6c, 0x12, 0x87,
    0x9b, 0xc7, 0x61, 0x6d, 0x35, 0xb5, 0x58, 0x32, 0x4c, 0x62, 0x3f, 0xb9,
    0xf6, 0xe3, 0xae, 0xa0, 0xe3, 0x03, 0xb7, 0x81, 0xfd, 0xb8, 0x0d, 0xec,
    0xe7, 0xbb, 0xc1, 0xfe, 0x89, 0xed, 0x94, 0x87, 0x0f, 0x8b, 0x67, 0x3d,
    0x5f, 0x12, 0x20, 0x61, 0x22, 0x0e, 0x92, 0x76, 0x70, 0x82, 0x2a, 0xa7,
    0x1c, 0x5d, 0xb7, 0xd3, 0xb1, 0x40, 0x68, 0xf7, 0xbc, 0x38, 0x12, 0x8d,
    0x1a, 0x99, 0x4c, 0x6b, 0x4f, 0x4f, 0x0f, 0xd9, 0x7c, 0xaf, 0x83, 0xef,
    0x73, 0xf0, 0xfd, 0xe0, 0x4b, 0x2c, 0xfb, 0xad, 0x89, 0xc8, 0x91, 0x0c,
    0x55, 0x46, 0xee, 0xbe, 0x47, 0x90, 0x2b, 0x12, 0x8b, 0x51, 0x3e, 0x3e,
    0x46, 0x13, 0x09, 0xd0, 0x0c, 0xf7, 0x8f, 0x4a, 0xd5, 0x1d, 0xc4, 0xba,
    0xec, 0x50, 0xde, 0x21, 0xbe, 0x66, 0x50, 0x45, 0x34, 0x89, 0x11, 0x8e,
    0x66, 0x47, 0xcd, 0xd8, 0x96, 0x93, 0x46, 0x74, 0x2e, 0x6b, 0x90, 0x1b,
    0x22, 0x3e, 0xd3, 0x46, 0x33, 0xa7, 0xcc, 0x28, 0x95, 0xab, 0x92, 0xbd,
    0x5f, 0x53, 0x8d, 0x21, 0x47, 0x71, 0xb7, 0x61, 0xc6, 0x30, 0x70, 0xb6,
    0x38, 0x43, 0xa5, 0x10, 0xe0, 0x9c, 0x62, 0x67, 0x48, 0x3b, 0xf9, 0x0d,
    0xcb, 0xdd, 0xfd, 0xe6, 0x82, 0x6b, 0x82, 0xc3, 0xc2, 0x75, 0xc4, 0xc8,
    0x52, 0x15, 0x3e, 0xd4, 0x6e, 0xc7, 0x51, 0x5a, 0xdb, 0x10, 0x79, 0x58,
    0xaa, 0xb6, 0x26, 0x79, 0xe4, 0x2f, 0x90, 0x84, 0x93, 0xc7, 0x0c, 0x93,
    0xca, 0x61, 0x63, 0x9f, 0x1d, 0x63, 0xc9, 0x98, 0x41, 0x65, 0xd3, 0xb8,
    0x6d, 0x25, 0x72, 0xb7, 0x29, 0x2a, 0xc0, 0x9d, 0x6a, 0x17, 0xee, 0x62,
    0xa4, 0x4f, 0x27, 0xd1, 0xff, 0xbc, 0xb8, 0x89, 0xcb, 0x1b, 0xbe, 0x4e,
    0x64, 0x1c, 0x57, 0xaf, 0x18, 0x79, 0xe3, 0x19, 0x15, 0xe0, 0xe4, 0x5c,
    0x2a, 0x95, 0x4c, 0xe3, 0x3c, 0xa1, 0x82, 0x78, 0x66, 0xcb, 0x4c, 0x2a,
    0x7b, 0x8a, 0x95, 0x5b, 0x0d, 0x39, 0xbd, 0x17, 0x28, 0xf7, 0x1a, 0x91,
    0xd8, 0x29, 0x2a, 0x8c, 0xab, 0xc9, 0x44, 0x15, 0x89, 0xc8, 0x9c, 0x19,
    0x9d, 0x56, 0x7e, 0xf8, 0xb6, 0x41, 0xba, 0x19, 0x99, 0x31, 0xa8, 0xd8,
    0x34, 0x4e, 0xa8, 0xeb, 0x1c, 0x24, 0x1c, 0x4b, 0x63, 0xd2, 0x74, 0x34,
    0x6f, 0xf7, 0xd1, 0xee, 0x07, 0x35, 0x24, 0xed, 0x74, 0x4d, 0x1a, 0xe9,
    0xe3, 0xf1, 0xa8, 0xb1, 0x39, 0x9e, 0xc1, 0x00, 0x70, 0x52, 0x11, 0x57,
    0x8d, 0x43, 0x9b, 0x9d, 0x4b, 0x6d, 0xc5, 0xed, 0x36, 0x33, 0x0d, 0x79,
    0x45, 0xd2, 0x44, 0x5e, 0x79, 0xcc, 0x72, 0x8e, 0x6a, 0x93, 0xe6, 0xc2,
    0x73, 0x2e, 0xa7, 0xf1, 0x42, 0x63, 0xef, 0xfa, 0xea, 0x00, 0x25, 0x58,
    0x5b, 0x27, 0x89, 0xad, 0xc8, 0x59, 0xd7, 0xa7, 0x16, 0xdc, 0x20, 0xa4,
    0xd5, 0x58, 0x24, 0x91, 0x38, 0x84, 0x79, 0x47, 0x2b, 0x52, 0xca, 0x7e,
    0x2c, 0x39, 0x93, 0x4a, 0x18, 0x08, 0x31, 0xa7, 0xaa, 0x9d, 0x57, 0xc9,
    0xc0, 0xe6, 0x35, 0x75, 0xb6, 0x46, 0x4e, 0xcb, 0x85, 0x0e, 0x2b, 0x67,
    0xef, 0x3e, 0xa0, 0xa9, 0xf6, 0x23, 0x84, 0xd6, 0xdc, 0xf4, 0x7d, 0x84,
    0x66, 0x1c, 0x91, 0x50, 0x99, 0xa5, 0xb0, 0x7b, 0x43, 0xca, 0xaf, 0x5d,
    0xb6, 0x6a, 0x7b, 0x17, 0x1a, 0xc9, 0x8a, 0xae, 0xf4, 0x9c, 0x49, 0x25,
    0x19, 0x23, 0xcb, 0x93, 0x91, 0x6f, 0xc1, 0xe4, 0x46, 0x41, 0x65, 0x72,
    0x3c, 0x46, 0x65, 0xf3, 0x25, 0xb9, 0xa8, 0x1c, 0xe5, 0xf0, 0xa9, 0x94,
    0x41, 0x1e, 0xd6, 0xab, 0x66, 0xac, 0x69, 0xaa, 0x67, 0xe2, 0xa7, 0x0d,
    0x2a, 0xcf, 0x64, 0x23, 0xe9, 0xac, 0x63, 0xf2, 0x17, 0x64, 0xe6, 0x0e,
    0x49, 0x0f, 0x3a, 0x18, 0x2c, 0x1e, 0xfe, 0x8c, 0xa6, 0xe3, 0x29, 0x5e,
    0x3b, 0x19, 0xca, 0xcf, 0x4e, 0xc7, 0xb1, 0x21, 0x28, 0xda, 0x4b, 0xee,
    0xe3, 0x91, 0x44, 0x6b, 0x44, 0x7d, 0xed, 0xa0, 0x12, 0x2e, 0xc5, 0xac,
    0x2b, 0x1d, 0x55, 0x71, 0x21, 0xb7, 0xd6, 0x26, 0xe7, 0xe4, 0x5e, 0x42,
    0xc5, 0x2c, 0x4d, 0xc9, 0xef, 0x13, 0x54, 0x2d, 0x79, 0x6b, 0x18, 0xc7,
    0x63, 0xf8, 0x92, 0x12, 0x3f, 0x1c, 0x47, 0xc7, 0x3c, 0x0e, 0x31, 0xc7,
    0x8e, 0xbd, 0xc4, 0x21, 0xc9, 0x84, 0x93, 0x7b, 0x78, 0x2c, 0xac, 0xa6,
    0xed, 0x21, 0xa3, 0x0a, 0x69, 0xb2, 0xa0, 0x83, 0xa5, 0x4e, 0x51, 0xc6,
    0x0a, 0x2e, 0x9b, 0x1c, 0x9b, 0x36, 0x30, 0x41, 0xf2, 0xa0, 0x9b, 0x33,
    0x68, 0xf6, 0xcc, 0x99, 0xcd, 0x43, 0x8f, 0x06, 0x78, 0xce, 0x60, 0x93,
    0x08, 0x6c, 0x08, 0xc4, 0x8c, 0x93, 0x81, 0x8e, 0x00, 0xbe, 0x20, 0xa5,
    0xe2, 0x09, 0x79, 0x18, 0x75, 0xce, 0x60, 0x05, 0x43, 0x91, 0x36, 0x12,
    0x06, 0xbe, 0x09, 0x41, 0x89, 0xc5, 0xdb, 0x19, 0x65, 0x27, 0x98, 0xd6,
    0x99, 0xc0, 0x86, 0xc3, 0x91, 0x44, 0xc6, 0xe8, 0x08, 0xcc, 0xc4, 0xcd,
    0x4e, 0x7c, 0x7b, 0x0a, 0x6c, 0xe8, 0xed, 0x08, 0x1c, 0x37, 0xd2, 0x19,
    0x64, 0x0b, 0xb5, 0xfa, 0xbb, 0xfa, 0xbb, 0xfa, 0x7a, 0x3a, 0x63, 0xc6,
    0xf1, 0xb5, 0x91, 0x64, 0x26, 0xd5, 0x1b, 0x78, 0x8c, 0xb4, 0x55, 0xe2,
    0x79, 0xd1, 0x90, 0x87, 0x3f, 0xfb, 0xd5, 0xfa, 0x36, 0xfa, 0x1a, 0x7c,
    0x79, 0x5a, 0x2b, 0x04, 0x75, 0x13, 0xda, 0x4a, 0x6d, 0x8f, 0x4e, 0x66,
    0x93, 0x55, 0xdc, 0x61, 0x91, 0xb1, 0x85, 0xd6, 0x4d, 0xb6, 0xf5, 0x2e,
    0x4b, 0xbd, 0xd3, 0x22, 0x5d, 0x16, 0x19, 0xb6, 0x48, 0xc8, 0x22, 0x83,
    0x16, 0x19, 0xb1, 0x3c, 0xe8, 0x3e, 0xa1, 0x5a, 0x93, 0xcd, 0x5b, 0x45,
    0x76, 0x27, 0x8b, 0x05, 0x88, 0x66, 0xa3, 0x6f, 0x9d, 0x4f, 0xf7, 0xad,
    0xf7, 0xe5, 0x84, 0x85, 0x3e, 0x0d, 0x22, 0x4b, 0x2c, 0x03, 0xc5, 0xeb,
    0x7a, 0x41, 0x17, 0xfd, 0xc2, 0xfe, 0xdf, 0x72, 0xf6, 0xac, 0x7e, 0xc3,
    0x17, 0x10, 0xef, 0xfb, 0x48, 0x13, 0x42, 0x97, 0xe2, 0x20, 0x64, 0xef,
    0xd4, 0xb6, 0x8a, 0x0f, 0x6b, 0xc9, 0x25, 0x44, 0xbe, 0x6d, 0xba, 0x12,
    0xe2, 0xb7, 0x56, 0xac, 0x12, 0x77, 0xf0, 0xb6, 0x53, 0x88, 0x22, 0x5b,
    0xbc, 0x1a, 0xe2, 0xe7, 0xea, 0xda, 0xc4, 0xf5, 0x3a, 0x12, 0x42, 0xb8,
    0x2f, 0xfa, 0xd7, 0x40, 0x70, 0xb9, 0xbe, 0x5d, 0xbc, 0x5a, 0xcf, 0x82,
    0xd2, 0x8b, 0xfe, 0xb5, 0x10, 0x9c, 0x6d, 0xe8, 0x10, 0x97, 0x1b, 0xb8,
    0x62, 0x99, 0x5d, 0xb1, 0x13, 0xe2, 0x77, 0x1a, 0xba, 0xc4, 0xd9, 0x46,
    0x34, 0xad, 0x55, 0x48, 0x71, 0x37, 0x64, 0x37, 0x1a, 0x7b, 0xc4, 0x9d,
    0x46, 0x21, 0xce, 0xe2, 0x5d, 0x91, 0x10, 0x95, 0x17, 0xfd, 0x7d, 0x10,
    0x5e, 0x6d, 0xea, 0x17, 0xf8, 0x85, 0x11, 0x62, 0xac, 0x92, 0x86, 0x03,
    0x5c, 0xb9, 0x69, 0x50, 0x7c, 0x08, 0x59, 0xa9, 0xbb, 0xc6, 0x2b, 0xb4,
    0x7b, 0x3e, 0x7f, 0x56, 0x7f, 0xbd, 0x45, 0x5c, 0xf0, 0x5f, 0xf1, 0xe3,
    0xe3, 0x42, 0x00, 0x1f, 0x2f, 0x73, 0xf1, 0xc5, 0x80, 0xd0, 0x5e, 0x0d,
    0xb8, 0xb4, 0x17, 0x83, 0x9a, 0xf6, 0xc3, 0x60, 0xc1, 0x39, 0xbc, 0xeb,
    0x72, 0x40, 0xd7, 0x6e, 0xad, 0x1a, 0x16, 0xb7, 0x02, 0x42, 0x9c, 0x0f,
    0x6a, 0xe2, 0xba, 0x5f, 0x13, 0x3f, 0x6c, 0x06, 0xef, 0x17, 0xe2, 0x72,
    0xab, 0x10, 0xaf, 0x03, 0x37, 0x81, 0x7f, 0x6c, 0xcd, 0x13, 0xd7, 0x57,
    0x0a, 0x71, 0x0b, 0xb8, 0xbe, 0x0a, 0x2f, 0x02, 0xf0, 0xf0, 0xfb, 0x80,
    0x44, 0xab, 0xf5, 0x2e, 0xe2, 0x31, 0xd0, 0xf3, 0x8a, 0x7f, 0xca, 0xc1,
    0x5f, 0x52, 0x3c, 0xdb, 0x3e, 0xaf, 0xf4, 0xdf, 0x70, 0xe8, 0xbf, 0xed,
    0xe0, 0xbf, 0xe3, 0xe0, 0x5f, 0x77, 0xf0, 0x7f, 0xe6, 0xe0, 0xff, 0xd2,
    0xc1, 0xff, 0x44, 0xf1, 0xec, 0xfb, 0x1d, 0xf0, 0x4c, 0x7f, 0xa5, 0xe8,
    0x7f, 0x29, 0x5a, 0x8e, 0x17, 0x85, 0x27, 0x1d, 0xf1, 0xc2, 0x44, 0xbe,
    0x57, 0x49, 0x41, 0x76, 0x5e, 0xc9, 0x59, 0xc6, 0xcf, 0xc5, 0x45, 0xe5,
    0x2b, 0x8b, 0xea, 0xf1, 0xfb, 0xa7, 0xcb, 0x90, 0x7d, 0x73, 0x91, 0x9d,
    0x9d, 0x0f, 0xe9, 0x04, 0x1f, 0x6f, 0x2d, 0xd2, 0xdf, 0x5c, 0x54, 0xbe,
    0xb5, 0xa8, 0x7c, 0x67, 0x51, 0x39, 0xa1, 0xca, 0xfc, 0xae, 0x93, 0x9f,
    0xad, 0x00, 0xb7, 0xbb, 0x0d, 0xf4, 0x03, 0xd0, 0xed, 0x2c, 0xc4, 0x0b,
    0x99, 0x09, 0x10, 0x0f, 0xe8, 0x2e, 0xd0, 0x42, 0x50, 0xeb, 0xed, 0x94,
    0x95, 0x07, 0x36, 0xe1, 0x7c, 0x5c, 0x06, 0x52, 0x00, 0xbf, 0xdf, 0xe9,
    0x07, 0x6e, 0x81, 0xe1, 0x77, 0x3b, 0x9b, 0x00, 0xfe, 0x8d, 0x9f, 0x0e,
    0xca, 0x7f, 0x0f, 0xe2, 0xdf, 0xf9, 0x71, 0x7b, 0xfc, 0xb7, 0x6c, 0xfe,
    0xad, 0x1f, 0x8a, 0xf2, 0xfd, 0x15, 0xff, 0xde, 0x4f, 0xf8, 0xad, 0xdf,
    0x42, 0xf1, 0x6f, 0xfe, 0x5c, 0xe0, 0xf9, 0xdd, 0x2b, 0xff, 0x5d, 0x52,
    0xa0, 0x41, 0x7e, 0x3f, 0xc4, 0x7f, 0xff, 0xd5, 0x20, 0xe7, 0xb6, 0xf8,
    0x37, 0x81, 0x3a, 0x78, 0x7e, 0x47, 0xc7, 0x73, 0x83, 0xc0, 0xf3, 0x7b,
    0x30, 0xfe, 0xbb, 0xb0, 0x0b, 0xf6, 0x52, 0x8e, 0x3e, 0xe4, 0x2b, 0x39,
    0xff, 0xcd, 0x98, 0x03, 0xe7, 0x58, 0xf9, 0x05, 0xdf, 0xff, 0x01, 0x8d,
    0xe0, 0xfe, 0xb8, 0xc4, 0x28, 0x00, 0x00
};

//==============================================================================
struct InAppPurchases::Pimpl
{
    Pimpl (InAppPurchases& parent)
        : owner (parent),
          billingClient (LocalRef<jobject> { getEnv()->NewObject (JuceBillingClient,
                                                                  JuceBillingClient.constructor,
                                                                  getAppContext().get(),
                                                                  (jlong) this) })
    {
    }

    ~Pimpl()
    {
        getEnv()->CallVoidMethod (billingClient, JuceBillingClient.endConnection);
    }

    //==============================================================================
    bool isInAppPurchasesSupported() const
    {
        return isReady() && getEnv()->CallBooleanMethod (billingClient, JuceBillingClient.isBillingSupported);
    }

    void getProductsInformation (const StringArray& productIdentifiers)
    {
        productDetailsQueryCallbackQueue.emplace ([this] (LocalRef<jobject> productDetailsList)
        {
            if (productDetailsList != nullptr)
            {
                auto* env = getEnv();
                Array<InAppPurchases::Product> products;

                for (int i = 0; i < env->CallIntMethod (productDetailsList, JavaList.size); ++i)
                    products.add (buildProduct (LocalRef<jobject> { env->CallObjectMethod (productDetailsList, JavaList.get, i) }));

                callMemberOnMainThread ([this, products]
                {
                    owner.listeners.call ([&] (Listener& l) { l.productsInfoReturned (products); });
                });
            }
        });

        queryProductDetailsAsync (convertToLowerCase (productIdentifiers));
    }

    void purchaseProduct (const String& productIdentifier,
                          const String& subscriptionIdentifier,
                          bool creditForUnusedSubscription)
    {
        productDetailsQueryCallbackQueue.emplace ([=] (LocalRef<jobject> productDetailsList)
        {
            if (productDetailsList != nullptr)
            {
                auto* env = getEnv();

                if (env->CallIntMethod (productDetailsList, JavaList.size) > 0)
                {
                    GlobalRef productDetails (LocalRef<jobject> { env->CallObjectMethod (productDetailsList, JavaList.get, 0) });

                    callMemberOnMainThread ([this, productDetails, subscriptionIdentifier, creditForUnusedSubscription]
                    {
                        if (subscriptionIdentifier.isNotEmpty())
                            changeExistingSubscription (productDetails, subscriptionIdentifier, creditForUnusedSubscription);
                        else
                            purchaseProductWithProductDetails (productDetails);
                    });
                }
            }
        });

        queryProductDetailsAsync (convertToLowerCase ({ productIdentifier }));
    }

    void restoreProductsBoughtList (bool, const juce::String&)
    {
        purchasesListQueryCallbackQueue.emplace ([this] (LocalRef<jobject> purchasesList)
        {
            if (purchasesList != nullptr)
            {
                auto* env = getEnv();
                Array<InAppPurchases::Listener::PurchaseInfo> purchases;

                for (int i = 0; i < env->CallIntMethod (purchasesList, JavaArrayList.size); ++i)
                {
                    const LocalRef<jobject> purchase { env->CallObjectMethod (purchasesList, JavaArrayList.get, i) };
                    purchases.add ({ buildPurchase (purchase), {} });
                }

                callMemberOnMainThread ([this, purchases]
                {
                        owner.listeners.call ([&] (Listener& l) { l.purchasesListRestored (purchases, true, NEEDS_TRANS ("Success")); });
                });
            }
            else
            {
                callMemberOnMainThread ([this]
                {
                    owner.listeners.call ([&] (Listener& l) { l.purchasesListRestored ({}, false, NEEDS_TRANS ("Failure")); });
                });
            }
        });

        getProductsBoughtAsync();
    }

    void consumePurchase (const String& productIdentifier, const String& purchaseToken)
    {
        if (purchaseToken.isEmpty())
        {
            productDetailsQueryCallbackQueue.emplace ([=] (LocalRef<jobject> productDetailsList)
            {
                if (productDetailsList != nullptr)
                {
                    auto* env = getEnv();

                    if (env->CallIntMethod (productDetailsList, JavaList.size) > 0)
                    {
                        const LocalRef<jobject> product { env->CallObjectMethod (productDetailsList, JavaList.get, 0) };

                        auto token = juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (product, ProductDetails.getProductId) });

                        if (token.isNotEmpty())
                        {
                            consumePurchaseWithToken (productIdentifier, token);
                            return;
                        }
                    }
                }

                callMemberOnMainThread ([this, productIdentifier]
                {
                    notifyListenersAboutConsume (productIdentifier, false, NEEDS_TRANS ("Item unavailable"));
                });
            });

            queryProductDetailsAsync (convertToLowerCase ({ productIdentifier }));
        }

        consumePurchaseWithToken (productIdentifier, purchaseToken);
    }

    //==============================================================================
    void startDownloads ([[maybe_unused]] const Array<Download*>& downloads)
    {
        // Not available on this platform.
        jassertfalse;
    }

    void pauseDownloads ([[maybe_unused]] const Array<Download*>& downloads)
    {
        // Not available on this platform.
        jassertfalse;
    }

    void resumeDownloads ([[maybe_unused]] const Array<Download*>& downloads)
    {
        // Not available on this platform.
        jassertfalse;
    }

    void cancelDownloads ([[maybe_unused]] const Array<Download*>& downloads)
    {
        // Not available on this platform.
        jassertfalse;
    }

private:
    #define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
      METHOD (constructor,                   "<init>",                      "(Landroid/content/Context;J)V")                                              \
      METHOD (endConnection,                 "endConnection",               "()V")                                                                        \
      METHOD (isReady,                       "isReady",                     "()Z")                                                                        \
      METHOD (isBillingSupported,            "isBillingSupported",          "()Z")                                                                        \
      METHOD (queryProductDetails,           "queryProductDetails",         "([Ljava/lang/String;)V")                                                     \
      METHOD (launchBillingFlow,             "launchBillingFlow",           "(Landroid/app/Activity;Lcom/android/billingclient/api/BillingFlowParams;)V") \
      METHOD (queryPurchases,                "queryPurchases",              "()V")                                                                        \
      METHOD (consumePurchase,               "consumePurchase",             "(Ljava/lang/String;Ljava/lang/String;)V")                                    \
                                                                                                                                                          \
      CALLBACK (generatedCallback<&Pimpl::updateProductDetails>, "productDetailsQueryCallback", "(JLjava/util/List;)V")                                                       \
      CALLBACK (generatedCallback<&Pimpl::updatePurchasesList>,  "purchasesListQueryCallback",  "(JLjava/util/List;)V")                                                       \
      CALLBACK (generatedCallback<&Pimpl::purchaseCompleted>,    "purchaseCompletedCallback",   "(JLcom/android/billingclient/api/Purchase;I)V")                              \
      CALLBACK (generatedCallback<&Pimpl::purchaseConsumed>,     "purchaseConsumedCallback",    "(JLjava/lang/String;I)V")

    DECLARE_JNI_CLASS_WITH_BYTECODE (JuceBillingClient,
                                     "com/rmsl/juce/JuceBillingClient",
                                     16,
                                     juceBillingClientCompiled)
    #undef JNI_CLASS_MEMBERS

    //==============================================================================
    bool isReady() const
    {
        return getEnv()->CallBooleanMethod (billingClient, JuceBillingClient.isReady);
    }

    bool checkIsReady() const
    {
        for (int i = 0; i < 10; ++i)
        {
            if (isReady())
                return true;

            Thread::sleep (500);
        }

        return false;
    }

    //==============================================================================
    static StringArray convertToLowerCase (const StringArray& stringsToConvert)
    {
        StringArray lowerCase;

        for (auto& s : stringsToConvert)
            lowerCase.add (s.toLowerCase());

        return lowerCase;
    }

    void queryProductDetailsAsync (const StringArray& productIdentifiers)
    {
        Thread::launch ([=]
        {
            if (! checkIsReady())
                return;

            MessageManager::callAsync ([=]
            {
                getEnv()->CallVoidMethod (billingClient,
                                          JuceBillingClient.queryProductDetails,
                                          juceStringArrayToJava (productIdentifiers).get());
            });
        });
    }

    void getProductsBoughtAsync()
    {
        Thread::launch ([=]
        {
            if (! checkIsReady())
                return;

            MessageManager::callAsync ([=]
            {
                getEnv()->CallVoidMethod (billingClient,
                                          JuceBillingClient.queryPurchases);
            });
        });
    }

    //==============================================================================
    void notifyListenersAboutPurchase (const InAppPurchases::Purchase& purchase, bool success, const String& statusDescription)
    {
        owner.listeners.call ([&] (Listener& l) { l.productPurchaseFinished ({ purchase, {} }, success, statusDescription); });
    }

    void notifyListenersAboutConsume (const String& productIdentifier, bool success, const String& statusDescription)
    {
        owner.listeners.call ([&] (Listener& l) { l.productConsumed (productIdentifier, success, statusDescription); });
    }

    void launchBillingFlowWithParameters (LocalRef<jobject> params)
    {
        const auto activity = []
        {
            if (auto current = getCurrentActivity())
                return current;

            return getMainActivity();
        }();

        getEnv()->CallVoidMethod (billingClient,
                                  JuceBillingClient.launchBillingFlow,
                                  activity.get(),
                                  params.get());
    }

    void changeExistingSubscription (GlobalRef productDetails, const String& subscriptionIdentifier, bool creditForUnusedSubscription)
    {
        if (! isReady())
        {
            notifyListenersAboutPurchase ({}, false, NEEDS_TRANS ("In-App purchases unavailable"));
            return;
        }

        purchasesListQueryCallbackQueue.emplace ([=] (LocalRef<jobject> purchasesList)
        {
            if (purchasesList != nullptr)
            {
                auto* env = getEnv();

                for (int i = 0; i < env->CallIntMethod (purchasesList, JavaArrayList.size); ++i)
                {
                    auto purchase = buildPurchase (LocalRef<jobject> { env->CallObjectMethod (purchasesList.get(), JavaArrayList.get, i) });

                    if (purchase.productIds.contains (subscriptionIdentifier))
                    {
                        const LocalRef<jobject> subscriptionBuilder { getEnv()->CallStaticObjectMethod (BillingFlowParamsSubscriptionUpdateParams,
                                                                                                        BillingFlowParamsSubscriptionUpdateParams.newBuilder) };
                        env->CallObjectMethod (subscriptionBuilder.get(),
                                               BillingFlowParamsSubscriptionUpdateParamsBuilder.setOldPurchaseToken,
                                               javaString (purchase.purchaseToken).get());

                        if (! creditForUnusedSubscription)
                        {
                            env->CallObjectMethod (subscriptionBuilder.get(),
                                                   BillingFlowParamsSubscriptionUpdateParamsBuilder.setReplaceProrationMode,
                                                   3 /*IMMEDIATE_WITHOUT_PRORATION*/);
                        }

                        const LocalRef<jobject> subscriptionParams { env->CallObjectMethod (subscriptionBuilder.get(),
                                                                                            BillingFlowParamsSubscriptionUpdateParamsBuilder.build) };

                        const LocalRef<jobject> builder { env->CallStaticObjectMethod (BillingFlowParams, BillingFlowParams.newBuilder) };
                        env->CallObjectMethod (builder.get(),
                                               BillingFlowParamsBuilder.setSubscriptionUpdateParams,
                                               subscriptionParams.get());
                        const LocalRef<jobject> params { env->CallObjectMethod (builder.get(), BillingFlowParamsBuilder.build) };

                        launchBillingFlowWithParameters (params);
                    }
                }
            }

            callMemberOnMainThread ([this]
            {
                notifyListenersAboutPurchase ({}, false, NEEDS_TRANS ("Unable to get subscription details"));
            });
        });

        getProductsBoughtAsync();
    }

    void purchaseProductWithProductDetails (GlobalRef productDetails)
    {
        if (! isReady())
        {
            notifyListenersAboutPurchase ({}, false, NEEDS_TRANS ("In-App purchases unavailable"));
            return;
        }

        auto* env = getEnv();
        const LocalRef<jobject> billingFlowParamsProductDetailsParamsBuilder { env->CallStaticObjectMethod (BillingFlowParamsProductDetailsParams, BillingFlowParamsProductDetailsParams.newBuilder) };
        env->CallObjectMethod (billingFlowParamsProductDetailsParamsBuilder, BillingFlowParamsProductDetailsParamsBuilder.setProductDetails, productDetails.get());

        if (const LocalRef<jobject> subscriptionDetailsList { env->CallObjectMethod (productDetails, ProductDetails.getSubscriptionOfferDetails) })
        {
            if (env->CallIntMethod (subscriptionDetailsList, JavaList.size) > 0)
            {
                const LocalRef<jobject> subscriptionDetails { env->CallObjectMethod (subscriptionDetailsList, JavaList.get, 0) };
                const LocalRef<jobject> offerToken { env->CallObjectMethod (subscriptionDetails, SubscriptionOfferDetails.getOfferToken) };
                env->CallObjectMethod (billingFlowParamsProductDetailsParamsBuilder, BillingFlowParamsProductDetailsParamsBuilder.setOfferToken, offerToken.get());
            }
        }

        const LocalRef<jobject> billingFlowParamsProductDetailsParams { env->CallObjectMethod (billingFlowParamsProductDetailsParamsBuilder, BillingFlowParamsProductDetailsParamsBuilder.build) };

        const LocalRef<jobject> list { env->NewObject (JavaArrayList, JavaArrayList.constructor, 0) };
        env->CallBooleanMethod (list, JavaArrayList.add, billingFlowParamsProductDetailsParams.get());

        const LocalRef<jobject> billingFlowParamsBuilder { env->CallStaticObjectMethod (BillingFlowParams, BillingFlowParams.newBuilder) };
        env->CallObjectMethod (billingFlowParamsBuilder, BillingFlowParamsBuilder.setProductDetailsParamsList, list.get());
        const LocalRef<jobject> params { env->CallObjectMethod (billingFlowParamsBuilder, BillingFlowParamsBuilder.build) };

        launchBillingFlowWithParameters (params);
    }

    void consumePurchaseWithToken (const String& productIdentifier, const String& purchaseToken)
    {
        if (! isReady())
        {
            callMemberOnMainThread ([this, productIdentifier]
            {
                notifyListenersAboutConsume (productIdentifier, false, NEEDS_TRANS ("In-App purchases unavailable"));
            });

            return;
        }

        getEnv()->CallVoidMethod (billingClient,
                                  JuceBillingClient.consumePurchase,
                                  LocalRef<jstring> { javaString (productIdentifier) }.get(),
                                  LocalRef<jstring> { javaString (purchaseToken) }.get());
    }

    //==============================================================================
    static InAppPurchases::Purchase buildPurchase (LocalRef<jobject> purchase)
    {
        if (purchase == nullptr)
            return {};

        auto* env = getEnv();

        if (env->CallIntMethod (purchase, AndroidPurchase.getPurchaseState) != 1 /* PURCHASED */)
            return {};

        return { juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (purchase, AndroidPurchase.getOrderId) }),
                 javaListOfStringToJuceStringArray (LocalRef<jobject> { env->CallObjectMethod (purchase, AndroidPurchase.getProducts) }),
                 juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (purchase, AndroidPurchase.getPackageName) }),
                 Time (env->CallLongMethod (purchase, AndroidPurchase.getPurchaseTime)).toString (true, true, true, true),
                 juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (purchase, AndroidPurchase.getPurchaseToken) }) };
    }

    static InAppPurchases::Product buildProduct (LocalRef<jobject> productDetails)
    {
        if (productDetails == nullptr)
            return {};

        auto* env = getEnv();

        if (LocalRef<jobject> oneTimePurchase { env->CallObjectMethod (productDetails, ProductDetails.getOneTimePurchaseOfferDetails) })
        {
            return { juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (productDetails, ProductDetails.getProductId) }),
                     juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (productDetails, ProductDetails.getTitle) }),
                     juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (productDetails, ProductDetails.getDescription) }),
                     juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (oneTimePurchase, OneTimePurchaseOfferDetails.getFormattedPrice) }),
                     juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (oneTimePurchase, OneTimePurchaseOfferDetails.getPriceCurrencyCode) }) };
        }

        LocalRef<jobject> subscription { env->CallObjectMethod (productDetails, ProductDetails.getSubscriptionOfferDetails) };

        if (env->CallIntMethod (subscription, JavaList.size) == 0)
            return {};

        // We can only return a single subscription price for this subscription,
        // but the subscription has more than one pricing scheme.
        jassert (env->CallIntMethod (subscription, JavaList.size) == 1);

        const LocalRef<jobject> offerDetails { env->CallObjectMethod (subscription, JavaList.get, 0) };
        const LocalRef<jobject> pricingPhases { env->CallObjectMethod (offerDetails, SubscriptionOfferDetails.getPricingPhases) };
        const LocalRef<jobject> phaseList { env->CallObjectMethod (pricingPhases, PricingPhases.getPricingPhaseList) };

        if (env->CallIntMethod (phaseList, JavaList.size) == 0)
            return {};

        // We can only return a single subscription price for this subscription,
        // but the pricing scheme for this subscription has more than one phase.
        jassert (env->CallIntMethod (phaseList, JavaList.size) == 1);

        const LocalRef<jobject> phase { env->CallObjectMethod (phaseList, JavaList.get, 0) };

        return { juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (productDetails, ProductDetails.getProductId) }),
                 juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (productDetails, ProductDetails.getTitle) }),
                 juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (productDetails, ProductDetails.getDescription) }),
                 juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (phase, PricingPhase.getFormattedPrice) }),
                 juceString (LocalRef<jstring> { (jstring) env->CallObjectMethod (phase, PricingPhase.getPriceCurrencyCode) }) };
    }

    static String getStatusDescriptionFromResponseCode (int responseCode)
    {
        switch (responseCode)
        {
            case 0:   return NEEDS_TRANS ("Success");
            case 1:   return NEEDS_TRANS ("Cancelled by user");
            case 2:   return NEEDS_TRANS ("Service unavailable");
            case 3:   return NEEDS_TRANS ("Billing unavailable");
            case 4:   return NEEDS_TRANS ("Item unavailable");
            case 5:   return NEEDS_TRANS ("Internal error");
            case 6:   return NEEDS_TRANS ("Generic error");
            case 7:   return NEEDS_TRANS ("Item already owned");
            case 8:   return NEEDS_TRANS ("Item not owned");
            default:  return NEEDS_TRANS ("Unknown status");
        }
    }

    static bool wasSuccessful (int responseCode)
    {
        return responseCode == 0;
    }

    static void purchaseCompleted (JNIEnv*, Pimpl& t, jobject purchase, int responseCode)
    {
        t.notifyListenersAboutPurchase (buildPurchase (LocalRef<jobject> { purchase }),
                                        wasSuccessful (responseCode),
                                        getStatusDescriptionFromResponseCode (responseCode));
    }

    static void purchaseConsumed (JNIEnv*, Pimpl& t, jstring productIdentifier, int responseCode)
    {
        t.notifyListenersAboutConsume (juceString (LocalRef<jstring> { productIdentifier }),
                                       wasSuccessful (responseCode),
                                       getStatusDescriptionFromResponseCode (responseCode));
    }

    static void updateProductDetails (JNIEnv*, Pimpl& t, jobject productDetailsList)
    {
        jassert (! t.productDetailsQueryCallbackQueue.empty());
        t.productDetailsQueryCallbackQueue.front() (LocalRef<jobject> { productDetailsList });
        t.productDetailsQueryCallbackQueue.pop();
    }

    static void updatePurchasesList (JNIEnv*, Pimpl& t, jobject purchasesList)
    {
        jassert (! t.purchasesListQueryCallbackQueue.empty());
        t.purchasesListQueryCallbackQueue.front() (LocalRef<jobject> { purchasesList });
        t.purchasesListQueryCallbackQueue.pop();
    }

    //==============================================================================
    InAppPurchases& owner;
    GlobalRef billingClient;

    std::queue<std::function<void (LocalRef<jobject>)>> productDetailsQueryCallbackQueue,
                                                        purchasesListQueryCallbackQueue;

    //==============================================================================
    void callMemberOnMainThread (std::function<void()> callback)
    {
        callOnMainThread ([ref = WeakReference<Pimpl> (this), callback]
        {
            if (ref != nullptr)
                callback();
        });
    }

    //==============================================================================
    JUCE_DECLARE_WEAK_REFERENCEABLE (Pimpl)
    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (Pimpl)
};

void juce_handleOnResume()
{
    callOnMainThread ([]
    {
        InAppPurchases::getInstance()->restoreProductsBoughtList (false);
    });
}

} // namespace juce
