/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerPanel;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenDisablePanelCheckbox;
import org.jetbrains.idea.maven.project.MavenProjectBundle;

public class MavenRunnerSettingsEditor
extends SettingsEditor<MavenRunConfiguration> {
    private final MavenRunnerPanel myPanel;
    private JCheckBox myUseProjectSettings;

    public MavenRunnerSettingsEditor(@NotNull Project project) {
        if (project == null) {
            MavenRunnerSettingsEditor.$$$reportNull$$$0(0);
        }
        this.myPanel = new MavenRunnerPanel(project, true);
    }

    protected void resetEditorFrom(@NotNull MavenRunConfiguration runConfiguration) {
        boolean localTarget;
        if (runConfiguration == null) {
            MavenRunnerSettingsEditor.$$$reportNull$$$0(1);
        }
        boolean bl = localTarget = MavenRunConfiguration.getTargetName(this) == null;
        if (localTarget) {
            this.myUseProjectSettings.setSelected(runConfiguration.getRunnerSettings() == null);
        } else {
            this.myUseProjectSettings.setSelected(false);
        }
        if (runConfiguration.getRunnerSettings() == null) {
            MavenRunnerSettings settings = MavenRunner.getInstance(this.myPanel.getProject()).getSettings();
            this.myPanel.getData(settings);
        } else {
            this.myPanel.getData(runConfiguration.getRunnerSettings());
        }
    }

    protected void applyEditorTo(@NotNull MavenRunConfiguration runConfiguration) throws ConfigurationException {
        String targetName;
        if (runConfiguration == null) {
            MavenRunnerSettingsEditor.$$$reportNull$$$0(2);
        }
        boolean localTarget = (targetName = MavenRunConfiguration.getTargetName(this)) == null;
        this.myUseProjectSettings.setEnabled(localTarget);
        if (!localTarget) {
            this.myUseProjectSettings.setSelected(false);
            this.myUseProjectSettings.setToolTipText(MavenConfigurableBundle.message("maven.settings.on.targets.runner.use.project.settings.tooltip", new Object[0]));
        } else {
            this.myUseProjectSettings.setToolTipText(MavenConfigurableBundle.message("maven.settings.runner.use.project.settings.tooltip", new Object[0]));
        }
        if (this.myUseProjectSettings.isSelected()) {
            runConfiguration.setRunnerSettings(null);
        } else {
            MavenRunnerSettings runnerSettings = runConfiguration.getRunnerSettings();
            this.myPanel.applyTargetEnvironmentConfiguration(targetName);
            if (runnerSettings != null) {
                this.myPanel.setData(runnerSettings);
            } else {
                MavenRunnerSettings settings = MavenRunner.getInstance(this.myPanel.getProject()).getSettings().clone();
                this.myPanel.setData(settings);
                runConfiguration.setRunnerSettings(settings);
            }
        }
    }

    @NotNull
    protected JComponent createEditor() {
        Pair<JPanel, JCheckBox> pair = MavenDisablePanelCheckbox.createPanel(this.myPanel.createComponent(), MavenProjectBundle.message("label.use.project.settings", new Object[0]));
        this.myUseProjectSettings = (JCheckBox)pair.second;
        JComponent jComponent = (JComponent)pair.first;
        if (jComponent == null) {
            MavenRunnerSettingsEditor.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunnerSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunnerSettingsEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

