/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Tarjan;
import org.testng.log4testng.Logger;

public class Graph<T> {
    private final Map<T, Node<T>> m_nodes = Maps.newLinkedHashMap();
    private List<T> m_strictlySortedNodes = null;
    private final Comparator<Node<T>> comparator;
    private Map<T, Node<T>> m_independentNodes = null;

    public Graph(Comparator<Node<T>> comparator) {
        this.comparator = comparator;
    }

    public void addNode(T tm) {
        Graph.log(() -> "ADDING NODE " + tm + " " + tm.hashCode());
        this.m_nodes.put(tm, new Node<T>(tm));
    }

    public Set<T> getPredecessors(T node) {
        return this.findNode(node).getPredecessors().keySet();
    }

    public boolean isIndependent(T object) {
        return this.m_independentNodes.containsKey(object);
    }

    private Node<T> findNode(T object) {
        return this.m_nodes.get(object);
    }

    public void addPredecessor(T tm, T predecessor) {
        Node<T> node = this.findNode(tm);
        if (null == node) {
            throw new TestNGException("Non-existing node: " + tm);
        }
        node.addPredecessor(predecessor);
        this.initializeIndependentNodes();
        this.m_independentNodes.remove(predecessor);
        this.m_independentNodes.remove(tm);
        Graph.log(() -> "  REMOVED " + predecessor + " FROM INDEPENDENT OBJECTS");
    }

    private Collection<Node<T>> getNodes() {
        return this.m_nodes.values();
    }

    public Set<T> getIndependentNodes() {
        return this.m_independentNodes.keySet();
    }

    public List<T> getStrictlySortedNodes() {
        return this.m_strictlySortedNodes;
    }

    public void topologicalSort() {
        Graph.log("================ SORTING");
        this.m_strictlySortedNodes = Lists.newArrayList();
        this.initializeIndependentNodes();
        List<Node<T>> nodes2 = this.getNodes().parallelStream().filter(n -> !this.isIndependent(n.getObject())).map(Node::clone).sorted(this.comparator).collect(Collectors.toList());
        while (!nodes2.isEmpty()) {
            Node<T> node = this.findNodeWithNoPredecessors(nodes2);
            if (null == node) {
                List<T> cycle = new Tarjan<T>(this, nodes2.get(0).getObject()).getCycle();
                StringBuilder sb = new StringBuilder();
                sb.append("The following methods have cyclic dependencies:\n");
                for (T m : cycle) {
                    sb.append(m).append("\n");
                }
                throw new TestNGException(sb.toString());
            }
            this.m_strictlySortedNodes.add(node.getObject());
            this.removeFromNodes(nodes2, node);
        }
        Graph.log("=============== DONE SORTING");
        this.dumpSortedNodes();
    }

    private void initializeIndependentNodes() {
        if (null == this.m_independentNodes) {
            List<Node<T>> list = Lists.newArrayList(this.m_nodes.values());
            list.sort(this.comparator);
            this.m_independentNodes = Maps.newLinkedHashMap();
            for (Node<T> node : list) {
                this.m_independentNodes.put(node.getObject(), node);
            }
        }
    }

    private void dumpSortedNodes() {
        Graph.log("====== SORTED NODES");
        for (T n : this.m_strictlySortedNodes) {
            Graph.log("              " + n);
        }
        Graph.log("====== END SORTED NODES");
    }

    private void removeFromNodes(List<Node<T>> nodes, Node<T> node) {
        nodes.remove(node);
        for (Node<T> n : nodes) {
            n.removePredecessor(node.getObject());
        }
    }

    private static void log(String s) {
        Graph.log(() -> s);
    }

    private static void log(Supplier<String> s) {
        Logger.getLogger(Graph.class).trace("[Graph] " + s.get());
    }

    private Node<T> findNodeWithNoPredecessors(List<Node<T>> nodes) {
        for (Node<T> n : nodes) {
            if (n.hasPredecessors()) continue;
            return n;
        }
        return null;
    }

    public List<T> findPredecessors(T o) {
        Node<T> node = this.findNode(o);
        if (null == node) {
            return Lists.newArrayList();
        }
        LinkedList result = new LinkedList();
        HashSet<Object> visited = new HashSet<Object>();
        LinkedList<Object> queue = new LinkedList<Object>();
        visited.add(o);
        queue.addLast(o);
        while (!queue.isEmpty()) {
            for (Object obj : this.getPredecessors(queue.removeFirst())) {
                if (visited.contains(obj)) continue;
                visited.add(obj);
                queue.addLast(obj);
                result.addFirst(obj);
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[Graph ");
        for (T node : this.m_nodes.keySet()) {
            result.append(this.findNode(node)).append(" ");
        }
        result.append("]");
        return result.toString();
    }

    public static class Node<T> {
        private final T m_object;
        private final Map<T, T> m_predecessors = Maps.newHashMap();

        public Node(T tm) {
            this.m_object = tm;
        }

        public Node<T> clone() {
            Node<T> result = new Node<T>(this.m_object);
            for (T pred : this.m_predecessors.values()) {
                result.addPredecessor(pred);
            }
            return result;
        }

        public T getObject() {
            return this.m_object;
        }

        public Map<T, T> getPredecessors() {
            return this.m_predecessors;
        }

        public boolean removePredecessor(T o) {
            boolean result = false;
            T pred = this.m_predecessors.get(o);
            if (null != pred) {
                boolean bl = result = null != this.m_predecessors.remove(o);
                if (result) {
                    Graph.log(() -> "  REMOVED PRED " + o + " FROM NODE " + this.m_object);
                } else {
                    Graph.log(() -> "  FAILED TO REMOVE PRED " + o + " FROM NODE " + this.m_object);
                }
            }
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[Node:" + this.m_object);
            sb.append("  pred:");
            for (T o : this.m_predecessors.values()) {
                sb.append(" ").append(o);
            }
            sb.append("]");
            return sb.toString();
        }

        public void addPredecessor(T tm) {
            Graph.log("  ADDING PREDECESSOR FOR " + this.m_object + " ==> " + tm);
            this.m_predecessors.put(tm, tm);
        }

        public boolean hasPredecessors() {
            return this.m_predecessors.size() > 0;
        }
    }
}

