/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.dialogresults.DialogResult;
import net.sourceforge.jnlp.security.dialogresults.NamePassword;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;

public class PasswordAuthenticationPane
extends SecurityDialogPanel {
    private final JTextField jtfUserName = new JTextField();
    private final JPasswordField jpfPassword = new JPasswordField();
    private final String host;
    private final int port;
    private final String prompt;
    private final String type;

    public PasswordAuthenticationPane(SecurityDialog parent, Object[] extras) {
        super(parent);
        this.host = (String)extras[0];
        this.port = (Integer)extras[1];
        this.prompt = (String)extras[2];
        this.type = (String)extras[3];
        this.addComponents();
    }

    public final void addComponents() {
        JLabel jlInfo = new JLabel("");
        jlInfo.setText("<html>" + Translator.R("SAuthenticationPrompt", this.type, this.host, this.prompt) + "</html>");
        this.setLayout(new GridBagLayout());
        JLabel jlUserName = new JLabel(Translator.R("Username"));
        JLabel jlPassword = new JLabel(Translator.R("Password"));
        JButton jbOK = new JButton(Translator.R("ButOk"));
        JButton jbCancel = new JButton(Translator.R("ButCancel"));
        this.jtfUserName.setSize(20, 10);
        this.jpfPassword.setSize(20, 10);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.insets = new Insets(10, 5, 3, 3);
        this.add((Component)jlInfo, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(10, 5, 3, 3);
        this.add((Component)jlUserName, c);
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(10, 5, 3, 3);
        c.weightx = 1.0;
        this.add((Component)this.jtfUserName, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 3, 3);
        this.add((Component)jlPassword, c);
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 3, 3);
        c.weightx = 1.0;
        this.add((Component)this.jpfPassword, c);
        c = new GridBagConstraints();
        c.anchor = 14;
        c.gridx = 1;
        c.gridy = 3;
        c.insets = new Insets(5, 5, 3, 70);
        c.weightx = 0.0;
        this.add((Component)jbCancel, c);
        c = new GridBagConstraints();
        c.anchor = 14;
        c.gridx = 1;
        c.gridy = 3;
        c.insets = new Insets(5, 5, 3, 3);
        c.weightx = 0.0;
        this.add((Component)jbOK, c);
        this.setMinimumSize(new Dimension(400, 150));
        this.setMaximumSize(new Dimension(1024, 150));
        this.setSize(400, 150);
        if (this.parent != null) {
            this.parent.getViwableDialog().setLocationRelativeTo(null);
        }
        this.initialFocusComponent = this.jtfUserName;
        ActionListener acceptActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordAuthenticationPane.this.parent.setValue(new NamePassword(PasswordAuthenticationPane.this.jtfUserName.getText(), PasswordAuthenticationPane.this.jpfPassword.getPassword()));
                PasswordAuthenticationPane.this.parent.getViwableDialog().dispose();
            }
        };
        ActionListener cancelActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordAuthenticationPane.this.parent.setValue(null);
                PasswordAuthenticationPane.this.parent.getViwableDialog().dispose();
            }
        };
        jbOK.addActionListener(acceptActionListener);
        jbCancel.addActionListener(cancelActionListener);
        this.jtfUserName.addActionListener(acceptActionListener);
        this.jpfPassword.addActionListener(acceptActionListener);
    }

    @Override
    public DialogResult getDefaultNegativeAnswer() {
        return null;
    }

    @Override
    public DialogResult getDefaultPositiveAnswer() {
        return null;
    }

    @Override
    public DialogResult readFromStdIn(String what) {
        return NamePassword.readValue(what);
    }

    @Override
    public String helpToStdIn() {
        return Translator.R("PAPstdinInfo");
    }

    public static void main(String[] args) {
        PasswordAuthenticationPane w = new PasswordAuthenticationPane(null, new Object[]{"host", 666, "prompt", "type"});
        JFrame f = new JFrame();
        f.setSize(400, 200);
        f.add((Component)w, "Center");
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

