/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.util.ArrayList;
import javax.swing.AbstractListModel;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;

public class WaypointNameMatcher
extends AbstractListModel<String> {
    private ArrayList<DataPoint> _waypoints = null;
    private int _numPoints = 0;
    private String[] _waypointNames = null;
    private ArrayList<DataPoint> _matches = null;

    public void init(Track track) {
        this._waypoints = new ArrayList();
        track.getWaypoints(this._waypoints);
        this._numPoints = this._waypoints.size();
        this._waypointNames = new String[this._numPoints];
        int n = 0;
        while (n < this._numPoints) {
            this._waypointNames[n] = this._waypoints.get(n).getWaypointName().toLowerCase();
            ++n;
        }
        this._matches = new ArrayList();
        this.findMatches(null);
    }

    public void findMatches(String string) {
        this._matches.clear();
        String string2 = null;
        if (string != null && !string.equals("")) {
            string2 = string.toLowerCase();
        }
        int n = 0;
        while (n < this._numPoints) {
            if (string2 == null || this._waypointNames[n].indexOf(string2) >= 0) {
                this._matches.add(this._waypoints.get(n));
            }
            ++n;
        }
        this.fireChanged();
    }

    @Override
    public int getSize() {
        if (this._numPoints == 0) {
            return 0;
        }
        return this._matches.size();
    }

    @Override
    public String getElementAt(int n) {
        return this._matches.get(n).getWaypointName();
    }

    public DataPoint getWaypoint(int n) {
        return this._matches.get(n);
    }

    public void fireChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }
}

