/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.appearance;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gephi.appearance.api.Function;
import org.gephi.desktop.appearance.AppearanceUIController;
import org.openide.util.Lookup;

public class AutoAppyTransformer
implements Runnable {
    private static final long DEFAULT_DELAY = 500L;
    private final Function function;
    private final AppearanceUIController controller = (AppearanceUIController)Lookup.getDefault().lookup(AppearanceUIController.class);
    private ScheduledExecutorService executor;

    public AutoAppyTransformer(Function function) {
        this.function = function;
    }

    public void start() {
        this.executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "Appearance Auto Transformer"));
        this.executor.scheduleWithFixedDelay(this, 0L, this.getDelayInMs(), TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
        }
        this.executor = null;
    }

    @Override
    public void run() {
        this.controller.transform(this.function);
    }

    public boolean isRunning() {
        return this.executor != null;
    }

    private long getDelayInMs() {
        return 500L;
    }
}

