/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.renderers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.util.Locale;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.Item;
import org.gephi.preview.api.PDFTarget;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.PreviewProperty;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.api.SVGTarget;
import org.gephi.preview.api.Vector;
import org.gephi.preview.plugin.builders.EdgeBuilder;
import org.gephi.preview.plugin.builders.NodeBuilder;
import org.gephi.preview.plugin.items.EdgeItem;
import org.gephi.preview.plugin.renderers.PDFUtils;
import org.gephi.preview.plugin.renderers.SVGUtils;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.preview.spi.Renderer;
import org.gephi.preview.types.EdgeColor;
import org.gephi.utils.NumberUtils;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

public class EdgeRenderer
implements Renderer {
    public static final String EDGE_MIN_WEIGHT = "edge.min-weight";
    public static final String EDGE_MAX_WEIGHT = "edge.max-weight";
    @Deprecated
    public static final String BEZIER_CURVENESS = "edge.bezier-curveness";
    public static final String ARC_CURVENESS = "edge.arc-curveness";
    public static final String SOURCE = "source";
    public static final String TARGET = "target";
    public static final String TARGET_RADIUS = "edge.target.radius";
    public static final String SOURCE_RADIUS = "edge.source.radius";
    private static final StraightEdgeRenderer STRAIGHT_RENDERER = new StraightEdgeRenderer();
    private static final CurvedEdgeRenderer CURVED_RENDERER = new CurvedEdgeRenderer();
    private static final SelfLoopEdgeRenderer SELF_LOOP_RENDERER = new SelfLoopEdgeRenderer();
    protected boolean defaultShowEdges = true;
    protected float defaultThickness = 1.0f;
    protected boolean defaultRescaleWeight = true;
    protected float defaultRescaleWeightMin = 0.1f;
    protected float defaultRescaleWeightMax = 1.0f;
    protected EdgeColor defaultColor = new EdgeColor(EdgeColor.Mode.MIXED);
    protected boolean defaultEdgeCurved = true;
    protected static float defaultArcCurviness = 1.2f;
    protected int defaultOpacity = 100;
    protected float defaultRadius = 0.0f;

    public static Color getColor(Item item, PreviewProperties properties) {
        Item sourceItem = (Item)item.getData(SOURCE);
        Item targetItem = (Item)item.getData(TARGET);
        EdgeColor edgeColor = (EdgeColor)properties.getValue("edge.color");
        Color color = edgeColor.getColor((Color)item.getData("color"), (Color)sourceItem.getData("color"), (Color)targetItem.getData("color"));
        float opacity = (float)properties.getIntValue("edge.opacity") / 100.0f;
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((float)color.getAlpha() * opacity));
    }

    private static boolean isSelfLoopEdge(Item item) {
        Item sourceItem = (Item)item.getData(SOURCE);
        Item targetItem = (Item)item.getData(TARGET);
        return item instanceof EdgeItem && sourceItem == targetItem;
    }

    private static float getThickness(Item item) {
        return ((Double)item.getData("weight")).floatValue();
    }

    protected static void putNodesInEdgeItems(PreviewModel previewModel, Item[] edgeItems) {
        for (Item item : edgeItems) {
            Edge edge = (Edge)item.getSource();
            Node source = edge.getSource();
            Node target = edge.getTarget();
            Item nodeSource = previewModel.getItem("node", (Object)source);
            Item nodeTarget = previewModel.getItem("node", (Object)target);
            item.setData(SOURCE, (Object)nodeSource);
            item.setData(TARGET, (Object)nodeTarget);
        }
    }

    public void preProcess(PreviewModel previewModel) {
        boolean rescaleWeight;
        PreviewProperties properties = previewModel.getProperties();
        Item[] edgeItems = previewModel.getItems("edge");
        EdgeRenderer.putNodesInEdgeItems(previewModel, edgeItems);
        double minWeight = Double.POSITIVE_INFINITY;
        double maxWeight = Double.NEGATIVE_INFINITY;
        for (Item edge : edgeItems) {
            minWeight = Math.min(minWeight, (Double)edge.getData("weight"));
            maxWeight = Math.max(maxWeight, (Double)edge.getData("weight"));
        }
        properties.putValue(EDGE_MIN_WEIGHT, (Object)minWeight);
        properties.putValue(EDGE_MAX_WEIGHT, (Object)maxWeight);
        if (!properties.hasProperty(ARC_CURVENESS)) {
            properties.putValue(ARC_CURVENESS, (Object)Float.valueOf(defaultArcCurviness));
        }
        if (rescaleWeight = properties.getBooleanValue("edge.rescale-weight")) {
            double weightDiff = maxWeight - minWeight;
            double minRescaledWeight = properties.getFloatValue("edge.rescale-weight.min");
            double maxRescaledWeight = properties.getFloatValue("edge.rescale-weight.max");
            if (minRescaledWeight < 0.0) {
                minRescaledWeight = this.defaultRescaleWeightMin;
                properties.putValue("edge.rescale-weight.min", (Object)Float.valueOf(this.defaultRescaleWeightMin));
            }
            if (maxRescaledWeight < 0.0) {
                maxRescaledWeight = this.defaultRescaleWeightMax;
                properties.putValue("edge.rescale-weight.max", (Object)Float.valueOf(this.defaultRescaleWeightMax));
            }
            if (minRescaledWeight > maxRescaledWeight) {
                minRescaledWeight = maxRescaledWeight;
            }
            double rescaledWeightsDiff = maxRescaledWeight - minRescaledWeight;
            if (!(Double.isInfinite(minWeight) || Double.isInfinite(maxWeight) || NumberUtils.equalsEpsilon((double)maxWeight, (double)minWeight))) {
                for (Item item : edgeItems) {
                    double weight = (Double)item.getData("weight");
                    weight = rescaledWeightsDiff * (weight - minWeight) / weightDiff + minRescaledWeight;
                    this.setEdgeWeight(weight, properties, item);
                }
            } else {
                for (Item item : edgeItems) {
                    this.setEdgeWeight(1.0, properties, item);
                }
            }
        } else {
            for (Item item : edgeItems) {
                double weight = (Double)item.getData("weight");
                if (minWeight <= 0.0) {
                    weight += Math.abs(minWeight) + 1.0;
                }
                this.setEdgeWeight(weight, properties, item);
            }
        }
        for (Item item : edgeItems) {
            if (((Boolean)item.getData("self_loop")).booleanValue()) continue;
            float edgeRadius = properties.getFloatValue("edge.radius");
            boolean isDirected = (Boolean)item.getData("directed");
            Item targetItem = (Item)item.getData(TARGET);
            Double weight = (Double)item.getData("weight");
            float arrowSize = properties.getFloatValue("arrow.size");
            if (arrowSize < 0.0f) {
                arrowSize = 0.0f;
            }
            float arrowRadiusSize = isDirected ? arrowSize * weight.floatValue() : 0.0f;
            float targetRadius = -(edgeRadius + ((Float)targetItem.getData("size")).floatValue() / 2.0f + arrowRadiusSize);
            item.setData(TARGET_RADIUS, (Object)Float.valueOf(targetRadius));
            Item sourceItem = (Item)item.getData(SOURCE);
            float sourceRadius = -(edgeRadius + ((Float)sourceItem.getData("size")).floatValue() / 2.0f);
            item.setData(SOURCE_RADIUS, (Object)Float.valueOf(sourceRadius));
        }
    }

    private void setEdgeWeight(double weight, PreviewProperties properties, Item item) {
        item.setData("weight", (Object)(weight *= (double)properties.getFloatValue("edge.thickness")));
    }

    public void render(Item item, RenderTarget target, PreviewProperties properties) {
        if (EdgeRenderer.isSelfLoopEdge(item)) {
            SELF_LOOP_RENDERER.render(item, target, properties);
        } else if (properties.getBooleanValue("edge.curved")) {
            CURVED_RENDERER.render(item, target, properties);
        } else {
            STRAIGHT_RENDERER.render(item, target, properties);
        }
    }

    public void postProcess(PreviewModel previewModel, RenderTarget renderTarget, PreviewProperties properties) {
    }

    public CanvasSize getCanvasSize(Item item, PreviewProperties properties) {
        if (EdgeRenderer.isSelfLoopEdge(item)) {
            return SELF_LOOP_RENDERER.getCanvasSize(item, properties);
        }
        if (properties.getBooleanValue("edge.curved")) {
            return CURVED_RENDERER.getCanvasSize(item, properties);
        }
        return STRAIGHT_RENDERER.getCanvasSize(item, properties);
    }

    public PreviewProperty[] getProperties() {
        return new PreviewProperty[]{PreviewProperty.createProperty((Object)this, (String)"edge.show", Boolean.class, (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.display.displayName"), (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.display.description"), (String)PreviewProperty.CATEGORY_EDGES).setValue((Object)this.defaultShowEdges), PreviewProperty.createProperty((Object)this, (String)"edge.thickness", Float.class, (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.thickness.displayName"), (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.thickness.description"), (String)PreviewProperty.CATEGORY_EDGES, (String[])new String[]{"edge.show"}).setValue((Object)Float.valueOf(this.defaultThickness)), PreviewProperty.createProperty((Object)this, (String)"edge.rescale-weight", Boolean.class, (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.rescaleWeight.displayName"), (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.rescaleWeight.description"), (String)PreviewProperty.CATEGORY_EDGES, (String[])new String[]{"edge.show"}).setValue((Object)this.defaultRescaleWeight), PreviewProperty.createProperty((Object)this, (String)"edge.rescale-weight.min", Float.class, (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.rescaleWeight.min.displayName"), (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.rescaleWeight.min.description"), (String)PreviewProperty.CATEGORY_EDGES, (String[])new String[]{"edge.rescale-weight"}).setValue((Object)Float.valueOf(this.defaultRescaleWeightMin)), PreviewProperty.createProperty((Object)this, (String)"edge.rescale-weight.max", Float.class, (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.rescaleWeight.max.displayName"), (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.rescaleWeight.max.description"), (String)PreviewProperty.CATEGORY_EDGES, (String[])new String[]{"edge.rescale-weight"}).setValue((Object)Float.valueOf(this.defaultRescaleWeightMax)), PreviewProperty.createProperty((Object)this, (String)"edge.color", EdgeColor.class, (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.color.displayName"), (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.color.description"), (String)PreviewProperty.CATEGORY_EDGES, (String[])new String[]{"edge.show"}).setValue((Object)this.defaultColor), PreviewProperty.createProperty((Object)this, (String)"edge.opacity", Float.class, (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.opacity.displayName"), (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.opacity.description"), (String)PreviewProperty.CATEGORY_EDGES, (String[])new String[]{"edge.show"}).setValue((Object)this.defaultOpacity), PreviewProperty.createProperty((Object)this, (String)"edge.curved", Boolean.class, (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.curvedEdges.displayName"), (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.curvedEdges.description"), (String)PreviewProperty.CATEGORY_EDGES, (String[])new String[]{"edge.show"}).setValue((Object)this.defaultEdgeCurved), PreviewProperty.createProperty((Object)this, (String)"edge.radius", Float.class, (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.radius.displayName"), (String)NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.property.radius.description"), (String)PreviewProperty.CATEGORY_EDGES, (String[])new String[]{"edge.show"}).setValue((Object)Float.valueOf(this.defaultRadius))};
    }

    public boolean isRendererForitem(Item item, PreviewProperties properties) {
        if (item instanceof EdgeItem) {
            return this.showEdges(properties);
        }
        return false;
    }

    public boolean needsItemBuilder(ItemBuilder itemBuilder, PreviewProperties properties) {
        return (itemBuilder instanceof EdgeBuilder || itemBuilder instanceof NodeBuilder) && this.showEdges(properties);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(EdgeRenderer.class, (String)"EdgeRenderer.name");
    }

    private boolean showEdges(PreviewProperties properties) {
        return properties.getBooleanValue("edge.show") && !properties.getBooleanValue("canvas.moving");
    }

    private static class SelfLoopEdgeRenderer {
        public static final String ID = "SelfLoopEdge";

        private SelfLoopEdgeRenderer() {
        }

        public void render(Item item, RenderTarget target, PreviewProperties properties) {
            Helper h = new Helper(item);
            Color color = EdgeRenderer.getColor(item, properties);
            if (target instanceof G2DTarget) {
                Graphics2D graphics = ((G2DTarget)target).getGraphics();
                graphics.setStroke(new BasicStroke(EdgeRenderer.getThickness(item), 0, 0));
                graphics.setColor(color);
                GeneralPath gp = new GeneralPath(1);
                gp.moveTo(h.x.floatValue(), h.y.floatValue());
                gp.curveTo(h.v1.x, h.v1.y, h.v2.x, h.v2.y, h.x.floatValue(), h.y.floatValue());
                graphics.draw(gp);
            } else if (target instanceof SVGTarget) {
                SVGTarget svgTarget = (SVGTarget)target;
                Element selfLoopElem = svgTarget.createElement("path");
                selfLoopElem.setAttribute("d", String.format(Locale.ENGLISH, "M %f,%f C %f,%f %f,%f %f,%f", h.x, h.y, Float.valueOf(h.v1.x), Float.valueOf(h.v1.y), Float.valueOf(h.v2.x), Float.valueOf(h.v2.y), h.x, h.y));
                selfLoopElem.setAttribute("class", SVGUtils.idAsClassAttribute(h.node.getId()));
                selfLoopElem.setAttribute("stroke", svgTarget.toHexString(color));
                selfLoopElem.setAttribute("stroke-opacity", "" + (float)color.getAlpha() / 255.0f);
                selfLoopElem.setAttribute("stroke-width", Float.toString(EdgeRenderer.getThickness(item) * svgTarget.getScaleRatio()));
                selfLoopElem.setAttribute("fill", "none");
                svgTarget.getTopElement("edges").appendChild(selfLoopElem);
            } else if (target instanceof PDFTarget) {
                PDFTarget pdfTarget = (PDFTarget)target;
                PDPageContentStream cb = pdfTarget.getContentStream();
                try {
                    cb.moveTo(h.x.floatValue(), -h.y.floatValue());
                    cb.curveTo(h.v1.x, -h.v1.y, h.v2.x, -h.v2.y, h.x.floatValue(), -h.y.floatValue());
                    cb.setStrokingColor(color);
                    cb.setLineWidth(EdgeRenderer.getThickness(item));
                    if (color.getAlpha() < 255) {
                        PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
                        graphicsState.setStrokingAlphaConstant(Float.valueOf((float)color.getAlpha() / 255.0f));
                        cb.saveGraphicsState();
                        cb.setGraphicsStateParameters(graphicsState);
                    }
                    cb.stroke();
                    if (color.getAlpha() < 255) {
                        cb.restoreGraphicsState();
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        public CanvasSize getCanvasSize(Item item, PreviewProperties properties) {
            Helper h = new Helper(item);
            float minX = Math.min(Math.min(h.x.floatValue(), h.v1.x), h.v2.x);
            float minY = Math.min(Math.min(h.y.floatValue(), h.v1.y), h.v2.y);
            float maxX = Math.max(Math.max(h.x.floatValue(), h.v1.x), h.v2.x);
            float maxY = Math.max(Math.max(h.y.floatValue(), h.v1.y), h.v2.y);
            return new CanvasSize(minX, minY, maxX - minX, maxY - minY);
        }

        private static class Helper {
            public final Float x;
            public final Float y;
            public final Node node;
            public final Vector v1;
            public final Vector v2;

            public Helper(Item item) {
                this.node = ((Edge)item.getSource()).getSource();
                Item nodeSource = (Item)item.getData(EdgeRenderer.SOURCE);
                this.x = (Float)nodeSource.getData("x");
                this.y = (Float)nodeSource.getData("y");
                Float size = (Float)nodeSource.getData("size");
                this.v1 = new Vector(this.x.floatValue(), this.y.floatValue());
                this.v1.add(size.floatValue(), -size.floatValue());
                this.v2 = new Vector(this.x.floatValue(), this.y.floatValue());
                this.v2.add(size.floatValue(), size.floatValue());
            }
        }
    }

    private static class CurvedEdgeRenderer {
        private CurvedEdgeRenderer() {
        }

        public void render(Item item, RenderTarget target, PreviewProperties properties) {
            Helper h = new Helper(item, properties);
            Color color = EdgeRenderer.getColor(item, properties);
            if (h.asweep == 0.0) {
                return;
            }
            if (target instanceof G2DTarget) {
                Graphics2D graphics = ((G2DTarget)target).getGraphics();
                graphics.setStroke(new BasicStroke(EdgeRenderer.getThickness(item), 1, 0));
                graphics.setColor(color);
                graphics.draw(new Arc2D.Double(h.bbx, h.bby, h.bbw, h.bbh, h.astart, h.asweep, 0));
            } else if (target instanceof SVGTarget) {
                SVGTarget svgTarget = (SVGTarget)target;
                Element edgeElem = svgTarget.createElement("path");
                edgeElem.setAttribute("class", String.format("%s %s", SVGUtils.idAsClassAttribute(((Node)h.sourceItem.getSource()).getId()), SVGUtils.idAsClassAttribute(((Node)h.targetItem.getSource()).getId())));
                String path = String.format(Locale.ENGLISH, "M %f,%f A %f,%f %d,%d %d,%f,%f", h.x1WithRadius, h.y1WithRadius, h.r, h.r, 0, 0, 1, h.x2WithRadius, h.y2WithRadius);
                edgeElem.setAttribute("d", path);
                edgeElem.setAttribute("stroke", svgTarget.toHexString(color));
                edgeElem.setAttribute("stroke-width", Float.toString(EdgeRenderer.getThickness(item) * svgTarget.getScaleRatio()));
                edgeElem.setAttribute("stroke-linecap", "round");
                edgeElem.setAttribute("stroke-opacity", "" + (float)color.getAlpha() / 255.0f);
                edgeElem.setAttribute("fill", "none");
                svgTarget.getTopElement("edges").appendChild(edgeElem);
            } else if (target instanceof PDFTarget) {
                PDFTarget pdfTarget = (PDFTarget)target;
                PDPageContentStream cb = pdfTarget.getContentStream();
                try {
                    PDFUtils.drawArc(cb, (float)h.bbx, (float)(-h.bby), (float)(h.bbx + h.bbw), (float)(-(h.bby + h.bbh)), (float)h.astart, (float)h.asweep);
                    cb.setStrokingColor(color);
                    cb.setLineWidth(EdgeRenderer.getThickness(item));
                    cb.setLineJoinStyle(1);
                    cb.setLineCapStyle(1);
                    if (color.getAlpha() < 255) {
                        PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
                        graphicsState.setStrokingAlphaConstant(Float.valueOf((float)color.getAlpha() / 255.0f));
                        cb.saveGraphicsState();
                        cb.setGraphicsStateParameters(graphicsState);
                    }
                    cb.stroke();
                    if (color.getAlpha() < 255) {
                        cb.restoreGraphicsState();
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        public CanvasSize getCanvasSize(Item item, PreviewProperties properties) {
            Helper h = new Helper(item, properties);
            float minX = Math.min(h.x1.floatValue(), h.x2.floatValue());
            float minY = Math.min(h.y1.floatValue(), h.y2.floatValue());
            float maxX = Math.max(h.x1.floatValue(), h.x2.floatValue());
            float maxY = Math.max(h.y1.floatValue(), h.y2.floatValue());
            return new CanvasSize(minX, minY, maxX - minX, maxY - minY);
        }

        private static class Helper {
            public final Item sourceItem;
            public final Item targetItem;
            public final Float x1;
            public final Float x2;
            public final Float y1;
            public final Float y2;
            public final double r;
            public final double bbx;
            public final double bby;
            public final double bbw;
            public final double bbh;
            public final double astart;
            public final double asweep;
            public final Float x1WithRadius;
            public final Float x2WithRadius;
            public final Float y1WithRadius;
            public final Float y2WithRadius;

            public Helper(Item item, PreviewProperties properties) {
                double angle2;
                this.sourceItem = (Item)item.getData(EdgeRenderer.SOURCE);
                this.targetItem = (Item)item.getData(EdgeRenderer.TARGET);
                this.x1 = (Float)this.sourceItem.getData("x");
                this.x2 = (Float)this.targetItem.getData("x");
                this.y1 = (Float)this.sourceItem.getData("y");
                this.y2 = (Float)this.targetItem.getData("y");
                Vector direction = new Vector(this.x2.floatValue(), this.y2.floatValue());
                direction.sub(new Vector(this.x1.floatValue(), this.y1.floatValue()));
                float length = direction.mag();
                direction.normalize();
                this.r = (double)length / properties.getDoubleValue(EdgeRenderer.ARC_CURVENESS);
                double _xa = 0.5 * (double)(this.x1.floatValue() - this.x2.floatValue());
                double _ya = 0.5 * (double)(this.y1.floatValue() - this.y2.floatValue());
                double _x0 = (double)this.x2.floatValue() + _xa;
                double _y0 = (double)this.y2.floatValue() + _ya;
                double _a = Math.sqrt(Math.pow(_xa, 2.0) + Math.pow(_ya, 2.0));
                double _b = 0.0;
                if (_a < this.r) {
                    _b = Math.sqrt(Math.pow(this.r, 2.0) - Math.pow(_a, 2.0));
                }
                double xc = _x0 + _b * _ya / _a;
                double yc = _y0 - _b * _xa / _a;
                double angle1 = Math.atan2((double)this.y1.floatValue() - yc, (double)this.x1.floatValue() - xc);
                for (angle2 = Math.atan2((double)this.y2.floatValue() - yc, (double)this.x2.floatValue() - xc); angle2 < angle1; angle2 += Math.PI * 2) {
                }
                Float targetRadius = (Float)item.getData(EdgeRenderer.TARGET_RADIUS);
                if (targetRadius != null && targetRadius.floatValue() < 0.0f) {
                    Double targetOffset = this.computeTheThing(this.r, Double.valueOf(targetRadius.floatValue()));
                    this.x2WithRadius = Float.valueOf((float)(this.r * Math.cos(angle2 += targetOffset.doubleValue()) + xc));
                    this.y2WithRadius = Float.valueOf((float)(this.r * Math.sin(angle2) + yc));
                } else {
                    this.x2WithRadius = this.x2;
                    this.y2WithRadius = this.y2;
                }
                Float sourceRadius = (Float)item.getData(EdgeRenderer.SOURCE_RADIUS);
                if (sourceRadius != null && sourceRadius.floatValue() < 0.0f) {
                    Double sourceOffset = this.computeTheThing(this.r, Double.valueOf(sourceRadius.floatValue()));
                    this.x1WithRadius = Float.valueOf((float)(this.r * Math.cos(angle1 -= sourceOffset.doubleValue()) + xc));
                    this.y1WithRadius = Float.valueOf((float)(this.r * Math.sin(angle1) + yc));
                } else {
                    this.x1WithRadius = this.x1;
                    this.y1WithRadius = this.y1;
                }
                this.bbx = xc - this.r;
                this.bby = yc - this.r;
                this.bbw = 2.0 * this.r;
                this.bbh = 2.0 * this.r;
                this.astart = -180.0 * angle1 / Math.PI;
                this.asweep = 0.0 < angle1 - angle2 ? 0.0 : (180.0 * (angle1 - angle2) / Math.PI + 720.0) % 360.0 - 360.0;
            }

            private Double computeTheThing(Double radius_curvature_edge, Double truncature_length) {
                Double rt = truncature_length;
                Double r = radius_curvature_edge;
                if (!(r >= rt)) {
                    return 0.0;
                }
                double x = Math.sqrt(Math.pow(r, 2.0) - Math.pow(rt / 2.0, 2.0));
                return 2.0 * Math.atan2(rt / 2.0, x);
            }
        }
    }

    private static class StraightEdgeRenderer {
        private StraightEdgeRenderer() {
        }

        public void render(Item item, RenderTarget target, PreviewProperties properties) {
            Helper h = new Helper(item);
            Color color = EdgeRenderer.getColor(item, properties);
            if (target instanceof G2DTarget) {
                Graphics2D graphics = ((G2DTarget)target).getGraphics();
                graphics.setStroke(new BasicStroke(EdgeRenderer.getThickness(item), 0, 0));
                graphics.setColor(color);
                Line2D.Float line = new Line2D.Float(h.x1.floatValue(), h.y1.floatValue(), h.x2.floatValue(), h.y2.floatValue());
                graphics.draw(line);
            } else if (target instanceof SVGTarget) {
                SVGTarget svgTarget = (SVGTarget)target;
                Element edgeElem = svgTarget.createElement("path");
                edgeElem.setAttribute("class", String.format("%s %s", SVGUtils.idAsClassAttribute(((Node)h.sourceItem.getSource()).getId()), SVGUtils.idAsClassAttribute(((Node)h.targetItem.getSource()).getId())));
                edgeElem.setAttribute("d", String.format(Locale.ENGLISH, "M %f,%f L %f,%f", h.x1, h.y1, h.x2, h.y2));
                edgeElem.setAttribute("stroke", svgTarget.toHexString(color));
                edgeElem.setAttribute("stroke-width", Float.toString(EdgeRenderer.getThickness(item) * svgTarget.getScaleRatio()));
                edgeElem.setAttribute("stroke-opacity", "" + (float)color.getAlpha() / 255.0f);
                edgeElem.setAttribute("fill", "none");
                svgTarget.getTopElement("edges").appendChild(edgeElem);
            } else if (target instanceof PDFTarget) {
                PDFTarget pdfTarget = (PDFTarget)target;
                PDPageContentStream cb = pdfTarget.getContentStream();
                try {
                    cb.moveTo(h.x1.floatValue(), -h.y1.floatValue());
                    cb.lineTo(h.x2.floatValue(), -h.y2.floatValue());
                    cb.setStrokingColor(color);
                    cb.setLineWidth(EdgeRenderer.getThickness(item));
                    if (color.getAlpha() < 255) {
                        PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
                        graphicsState.setStrokingAlphaConstant(Float.valueOf((float)color.getAlpha() / 255.0f));
                        cb.saveGraphicsState();
                        cb.setGraphicsStateParameters(graphicsState);
                    }
                    cb.stroke();
                    if (color.getAlpha() < 255) {
                        cb.restoreGraphicsState();
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        public CanvasSize getCanvasSize(Item item, PreviewProperties properties) {
            Item sourceItem = (Item)item.getData(EdgeRenderer.SOURCE);
            Item targetItem = (Item)item.getData(EdgeRenderer.TARGET);
            Float x1 = (Float)sourceItem.getData("x");
            Float x2 = (Float)targetItem.getData("x");
            Float y1 = (Float)sourceItem.getData("y");
            Float y2 = (Float)targetItem.getData("y");
            float minX = Math.min(x1.floatValue(), x2.floatValue());
            float minY = Math.min(y1.floatValue(), y2.floatValue());
            float maxX = Math.max(x1.floatValue(), x2.floatValue());
            float maxY = Math.max(y1.floatValue(), y2.floatValue());
            return new CanvasSize(minX, minY, maxX - minX, maxY - minY);
        }

        private static class Helper {
            public final Item sourceItem;
            public final Item targetItem;
            public final Float x1;
            public final Float x2;
            public final Float y1;
            public final Float y2;

            public Helper(Item item) {
                Float sourceRadius;
                this.sourceItem = (Item)item.getData(EdgeRenderer.SOURCE);
                this.targetItem = (Item)item.getData(EdgeRenderer.TARGET);
                Float _x1 = (Float)this.sourceItem.getData("x");
                Float _x2 = (Float)this.targetItem.getData("x");
                Float _y1 = (Float)this.sourceItem.getData("y");
                Float _y2 = (Float)this.targetItem.getData("y");
                Float targetRadius = (Float)item.getData(EdgeRenderer.TARGET_RADIUS);
                if (targetRadius != null && targetRadius.floatValue() < 0.0f) {
                    Vector direction = new Vector(_x2.floatValue(), _y2.floatValue());
                    direction.sub(new Vector(_x1.floatValue(), _y1.floatValue()));
                    direction.normalize();
                    direction.mult(targetRadius.floatValue());
                    direction.add(new Vector(_x2.floatValue(), _y2.floatValue()));
                    _x2 = Float.valueOf(direction.x);
                    _y2 = Float.valueOf(direction.y);
                }
                if ((sourceRadius = (Float)item.getData(EdgeRenderer.SOURCE_RADIUS)) != null && sourceRadius.floatValue() < 0.0f) {
                    Vector direction = new Vector(_x1.floatValue(), _y1.floatValue());
                    direction.sub(new Vector(_x2.floatValue(), _y2.floatValue()));
                    direction.normalize();
                    direction.mult(sourceRadius.floatValue());
                    direction.add(new Vector(_x1.floatValue(), _y1.floatValue()));
                    _x1 = Float.valueOf(direction.x);
                    _y1 = Float.valueOf(direction.y);
                }
                this.x1 = _x1;
                this.y1 = _y1;
                this.x2 = _x2;
                this.y2 = _y2;
            }
        }
    }
}

