﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/ChartAxisLabelOptions.h>
#include <aws/quicksight/model/FunnelChartDataLabelOptions.h>
#include <aws/quicksight/model/FunnelChartFieldWells.h>
#include <aws/quicksight/model/FunnelChartSortConfiguration.h>
#include <aws/quicksight/model/TooltipOptions.h>
#include <aws/quicksight/model/VisualInteractionOptions.h>
#include <aws/quicksight/model/VisualPalette.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {

/**
 * <p>The configuration of a <code>FunnelChartVisual</code>.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/FunnelChartConfiguration">AWS
 * API Reference</a></p>
 */
class FunnelChartConfiguration {
 public:
  AWS_QUICKSIGHT_API FunnelChartConfiguration() = default;
  AWS_QUICKSIGHT_API FunnelChartConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API FunnelChartConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The field well configuration of a <code>FunnelChartVisual</code>.</p>
   */
  inline const FunnelChartFieldWells& GetFieldWells() const { return m_fieldWells; }
  inline bool FieldWellsHasBeenSet() const { return m_fieldWellsHasBeenSet; }
  template <typename FieldWellsT = FunnelChartFieldWells>
  void SetFieldWells(FieldWellsT&& value) {
    m_fieldWellsHasBeenSet = true;
    m_fieldWells = std::forward<FieldWellsT>(value);
  }
  template <typename FieldWellsT = FunnelChartFieldWells>
  FunnelChartConfiguration& WithFieldWells(FieldWellsT&& value) {
    SetFieldWells(std::forward<FieldWellsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The sort configuration of a <code>FunnelChartVisual</code>.</p>
   */
  inline const FunnelChartSortConfiguration& GetSortConfiguration() const { return m_sortConfiguration; }
  inline bool SortConfigurationHasBeenSet() const { return m_sortConfigurationHasBeenSet; }
  template <typename SortConfigurationT = FunnelChartSortConfiguration>
  void SetSortConfiguration(SortConfigurationT&& value) {
    m_sortConfigurationHasBeenSet = true;
    m_sortConfiguration = std::forward<SortConfigurationT>(value);
  }
  template <typename SortConfigurationT = FunnelChartSortConfiguration>
  FunnelChartConfiguration& WithSortConfiguration(SortConfigurationT&& value) {
    SetSortConfiguration(std::forward<SortConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The label options of the categories that are displayed in a
   * <code>FunnelChartVisual</code>.</p>
   */
  inline const ChartAxisLabelOptions& GetCategoryLabelOptions() const { return m_categoryLabelOptions; }
  inline bool CategoryLabelOptionsHasBeenSet() const { return m_categoryLabelOptionsHasBeenSet; }
  template <typename CategoryLabelOptionsT = ChartAxisLabelOptions>
  void SetCategoryLabelOptions(CategoryLabelOptionsT&& value) {
    m_categoryLabelOptionsHasBeenSet = true;
    m_categoryLabelOptions = std::forward<CategoryLabelOptionsT>(value);
  }
  template <typename CategoryLabelOptionsT = ChartAxisLabelOptions>
  FunnelChartConfiguration& WithCategoryLabelOptions(CategoryLabelOptionsT&& value) {
    SetCategoryLabelOptions(std::forward<CategoryLabelOptionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The label options for the values that are displayed in a
   * <code>FunnelChartVisual</code>.</p>
   */
  inline const ChartAxisLabelOptions& GetValueLabelOptions() const { return m_valueLabelOptions; }
  inline bool ValueLabelOptionsHasBeenSet() const { return m_valueLabelOptionsHasBeenSet; }
  template <typename ValueLabelOptionsT = ChartAxisLabelOptions>
  void SetValueLabelOptions(ValueLabelOptionsT&& value) {
    m_valueLabelOptionsHasBeenSet = true;
    m_valueLabelOptions = std::forward<ValueLabelOptionsT>(value);
  }
  template <typename ValueLabelOptionsT = ChartAxisLabelOptions>
  FunnelChartConfiguration& WithValueLabelOptions(ValueLabelOptionsT&& value) {
    SetValueLabelOptions(std::forward<ValueLabelOptionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tooltip configuration of a <code>FunnelChartVisual</code>.</p>
   */
  inline const TooltipOptions& GetTooltip() const { return m_tooltip; }
  inline bool TooltipHasBeenSet() const { return m_tooltipHasBeenSet; }
  template <typename TooltipT = TooltipOptions>
  void SetTooltip(TooltipT&& value) {
    m_tooltipHasBeenSet = true;
    m_tooltip = std::forward<TooltipT>(value);
  }
  template <typename TooltipT = TooltipOptions>
  FunnelChartConfiguration& WithTooltip(TooltipT&& value) {
    SetTooltip(std::forward<TooltipT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The options that determine the presentation of the data labels.</p>
   */
  inline const FunnelChartDataLabelOptions& GetDataLabelOptions() const { return m_dataLabelOptions; }
  inline bool DataLabelOptionsHasBeenSet() const { return m_dataLabelOptionsHasBeenSet; }
  template <typename DataLabelOptionsT = FunnelChartDataLabelOptions>
  void SetDataLabelOptions(DataLabelOptionsT&& value) {
    m_dataLabelOptionsHasBeenSet = true;
    m_dataLabelOptions = std::forward<DataLabelOptionsT>(value);
  }
  template <typename DataLabelOptionsT = FunnelChartDataLabelOptions>
  FunnelChartConfiguration& WithDataLabelOptions(DataLabelOptionsT&& value) {
    SetDataLabelOptions(std::forward<DataLabelOptionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The visual palette configuration of a <code>FunnelChartVisual</code>.</p>
   */
  inline const VisualPalette& GetVisualPalette() const { return m_visualPalette; }
  inline bool VisualPaletteHasBeenSet() const { return m_visualPaletteHasBeenSet; }
  template <typename VisualPaletteT = VisualPalette>
  void SetVisualPalette(VisualPaletteT&& value) {
    m_visualPaletteHasBeenSet = true;
    m_visualPalette = std::forward<VisualPaletteT>(value);
  }
  template <typename VisualPaletteT = VisualPalette>
  FunnelChartConfiguration& WithVisualPalette(VisualPaletteT&& value) {
    SetVisualPalette(std::forward<VisualPaletteT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The general visual interactions setup for a visual.</p>
   */
  inline const VisualInteractionOptions& GetInteractions() const { return m_interactions; }
  inline bool InteractionsHasBeenSet() const { return m_interactionsHasBeenSet; }
  template <typename InteractionsT = VisualInteractionOptions>
  void SetInteractions(InteractionsT&& value) {
    m_interactionsHasBeenSet = true;
    m_interactions = std::forward<InteractionsT>(value);
  }
  template <typename InteractionsT = VisualInteractionOptions>
  FunnelChartConfiguration& WithInteractions(InteractionsT&& value) {
    SetInteractions(std::forward<InteractionsT>(value));
    return *this;
  }
  ///@}
 private:
  FunnelChartFieldWells m_fieldWells;
  bool m_fieldWellsHasBeenSet = false;

  FunnelChartSortConfiguration m_sortConfiguration;
  bool m_sortConfigurationHasBeenSet = false;

  ChartAxisLabelOptions m_categoryLabelOptions;
  bool m_categoryLabelOptionsHasBeenSet = false;

  ChartAxisLabelOptions m_valueLabelOptions;
  bool m_valueLabelOptionsHasBeenSet = false;

  TooltipOptions m_tooltip;
  bool m_tooltipHasBeenSet = false;

  FunnelChartDataLabelOptions m_dataLabelOptions;
  bool m_dataLabelOptionsHasBeenSet = false;

  VisualPalette m_visualPalette;
  bool m_visualPaletteHasBeenSet = false;

  VisualInteractionOptions m_interactions;
  bool m_interactionsHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
