﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pca-connector-ad/PcaConnectorAd_EXPORTS.h>

namespace Aws {
namespace PcaConnectorAd {
namespace Model {
enum class ApplicationPolicyType {
  NOT_SET,
  ALL_APPLICATION_POLICIES,
  ANY_PURPOSE,
  ATTESTATION_IDENTITY_KEY_CERTIFICATE,
  CERTIFICATE_REQUEST_AGENT,
  CLIENT_AUTHENTICATION,
  CODE_SIGNING,
  CTL_USAGE,
  DIGITAL_RIGHTS,
  DIRECTORY_SERVICE_EMAIL_REPLICATION,
  DISALLOWED_LIST,
  DNS_SERVER_TRUST,
  DOCUMENT_ENCRYPTION,
  DOCUMENT_SIGNING,
  DYNAMIC_CODE_GENERATOR,
  EARLY_LAUNCH_ANTIMALWARE_DRIVER,
  EMBEDDED_WINDOWS_SYSTEM_COMPONENT_VERIFICATION,
  ENCLAVE,
  ENCRYPTING_FILE_SYSTEM,
  ENDORSEMENT_KEY_CERTIFICATE,
  FILE_RECOVERY,
  HAL_EXTENSION,
  IP_SECURITY_END_SYSTEM,
  IP_SECURITY_IKE_INTERMEDIATE,
  IP_SECURITY_TUNNEL_TERMINATION,
  IP_SECURITY_USER,
  ISOLATED_USER_MODE,
  KDC_AUTHENTICATION,
  KERNEL_MODE_CODE_SIGNING,
  KEY_PACK_LICENSES,
  KEY_RECOVERY,
  KEY_RECOVERY_AGENT,
  LICENSE_SERVER_VERIFICATION,
  LIFETIME_SIGNING,
  MICROSOFT_PUBLISHER,
  MICROSOFT_TIME_STAMPING,
  MICROSOFT_TRUST_LIST_SIGNING,
  OCSP_SIGNING,
  OEM_WINDOWS_SYSTEM_COMPONENT_VERIFICATION,
  PLATFORM_CERTIFICATE,
  PREVIEW_BUILD_SIGNING,
  PRIVATE_KEY_ARCHIVAL,
  PROTECTED_PROCESS_LIGHT_VERIFICATION,
  PROTECTED_PROCESS_VERIFICATION,
  QUALIFIED_SUBORDINATION,
  REVOKED_LIST_SIGNER,
  ROOT_PROGRAM_AUTO_UPDATE_CA_REVOCATION,
  ROOT_PROGRAM_AUTO_UPDATE_END_REVOCATION,
  ROOT_PROGRAM_NO_OSCP_FAILOVER_TO_CRL,
  ROOT_LIST_SIGNER,
  SECURE_EMAIL,
  SERVER_AUTHENTICATION,
  SMART_CARD_LOGIN,
  SPC_ENCRYPTED_DIGEST_RETRY_COUNT,
  SPC_RELAXED_PE_MARKER_CHECK,
  TIME_STAMPING,
  WINDOWS_HARDWARE_DRIVER_ATTESTED_VERIFICATION,
  WINDOWS_HARDWARE_DRIVER_EXTENDED_VERIFICATION,
  WINDOWS_HARDWARE_DRIVER_VERIFICATION,
  WINDOWS_HELLO_RECOVERY_KEY_ENCRYPTION,
  WINDOWS_KITS_COMPONENT,
  WINDOWS_RT_VERIFICATION,
  WINDOWS_SOFTWARE_EXTENSION_VERIFICATION,
  WINDOWS_STORE,
  WINDOWS_SYSTEM_COMPONENT_VERIFICATION,
  WINDOWS_TCB_COMPONENT,
  WINDOWS_THIRD_PARTY_APPLICATION_COMPONENT,
  WINDOWS_UPDATE
};

namespace ApplicationPolicyTypeMapper {
AWS_PCACONNECTORAD_API ApplicationPolicyType GetApplicationPolicyTypeForName(const Aws::String& name);

AWS_PCACONNECTORAD_API Aws::String GetNameForApplicationPolicyType(ApplicationPolicyType value);
}  // namespace ApplicationPolicyTypeMapper
}  // namespace Model
}  // namespace PcaConnectorAd
}  // namespace Aws
