﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoTRequest.h>
#include <aws/iot/IoT_EXPORTS.h>

#include <utility>

namespace Aws {
namespace IoT {
namespace Model {

/**
 */
class RemoveThingFromBillingGroupRequest : public IoTRequest {
 public:
  AWS_IOT_API RemoveThingFromBillingGroupRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "RemoveThingFromBillingGroup"; }

  AWS_IOT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The name of the billing group.</p>
   */
  inline const Aws::String& GetBillingGroupName() const { return m_billingGroupName; }
  inline bool BillingGroupNameHasBeenSet() const { return m_billingGroupNameHasBeenSet; }
  template <typename BillingGroupNameT = Aws::String>
  void SetBillingGroupName(BillingGroupNameT&& value) {
    m_billingGroupNameHasBeenSet = true;
    m_billingGroupName = std::forward<BillingGroupNameT>(value);
  }
  template <typename BillingGroupNameT = Aws::String>
  RemoveThingFromBillingGroupRequest& WithBillingGroupName(BillingGroupNameT&& value) {
    SetBillingGroupName(std::forward<BillingGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the billing group.</p>
   */
  inline const Aws::String& GetBillingGroupArn() const { return m_billingGroupArn; }
  inline bool BillingGroupArnHasBeenSet() const { return m_billingGroupArnHasBeenSet; }
  template <typename BillingGroupArnT = Aws::String>
  void SetBillingGroupArn(BillingGroupArnT&& value) {
    m_billingGroupArnHasBeenSet = true;
    m_billingGroupArn = std::forward<BillingGroupArnT>(value);
  }
  template <typename BillingGroupArnT = Aws::String>
  RemoveThingFromBillingGroupRequest& WithBillingGroupArn(BillingGroupArnT&& value) {
    SetBillingGroupArn(std::forward<BillingGroupArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the thing to be removed from the billing group.</p>
   */
  inline const Aws::String& GetThingName() const { return m_thingName; }
  inline bool ThingNameHasBeenSet() const { return m_thingNameHasBeenSet; }
  template <typename ThingNameT = Aws::String>
  void SetThingName(ThingNameT&& value) {
    m_thingNameHasBeenSet = true;
    m_thingName = std::forward<ThingNameT>(value);
  }
  template <typename ThingNameT = Aws::String>
  RemoveThingFromBillingGroupRequest& WithThingName(ThingNameT&& value) {
    SetThingName(std::forward<ThingNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the thing to be removed from the billing group.</p>
   */
  inline const Aws::String& GetThingArn() const { return m_thingArn; }
  inline bool ThingArnHasBeenSet() const { return m_thingArnHasBeenSet; }
  template <typename ThingArnT = Aws::String>
  void SetThingArn(ThingArnT&& value) {
    m_thingArnHasBeenSet = true;
    m_thingArn = std::forward<ThingArnT>(value);
  }
  template <typename ThingArnT = Aws::String>
  RemoveThingFromBillingGroupRequest& WithThingArn(ThingArnT&& value) {
    SetThingArn(std::forward<ThingArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_billingGroupName;
  bool m_billingGroupNameHasBeenSet = false;

  Aws::String m_billingGroupArn;
  bool m_billingGroupArnHasBeenSet = false;

  Aws::String m_thingName;
  bool m_thingNameHasBeenSet = false;

  Aws::String m_thingArn;
  bool m_thingArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
