﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/config/ConfigService_EXPORTS.h>
#include <aws/config/model/ResourceIdentifier.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ConfigService {
namespace Model {
/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResourcesResponse">AWS
 * API Reference</a></p>
 */
class ListDiscoveredResourcesResult {
 public:
  AWS_CONFIGSERVICE_API ListDiscoveredResourcesResult() = default;
  AWS_CONFIGSERVICE_API ListDiscoveredResourcesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CONFIGSERVICE_API ListDiscoveredResourcesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The details that identify a resource that is discovered by Config, including
   * the resource type, ID, and (if available) the custom resource name.</p>
   */
  inline const Aws::Vector<ResourceIdentifier>& GetResourceIdentifiers() const { return m_resourceIdentifiers; }
  template <typename ResourceIdentifiersT = Aws::Vector<ResourceIdentifier>>
  void SetResourceIdentifiers(ResourceIdentifiersT&& value) {
    m_resourceIdentifiersHasBeenSet = true;
    m_resourceIdentifiers = std::forward<ResourceIdentifiersT>(value);
  }
  template <typename ResourceIdentifiersT = Aws::Vector<ResourceIdentifier>>
  ListDiscoveredResourcesResult& WithResourceIdentifiers(ResourceIdentifiersT&& value) {
    SetResourceIdentifiers(std::forward<ResourceIdentifiersT>(value));
    return *this;
  }
  template <typename ResourceIdentifiersT = ResourceIdentifier>
  ListDiscoveredResourcesResult& AddResourceIdentifiers(ResourceIdentifiersT&& value) {
    m_resourceIdentifiersHasBeenSet = true;
    m_resourceIdentifiers.emplace_back(std::forward<ResourceIdentifiersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The string that you use in a subsequent request to get the next page of
   * results in a paginated response.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListDiscoveredResourcesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListDiscoveredResourcesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ResourceIdentifier> m_resourceIdentifiers;
  bool m_resourceIdentifiersHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConfigService
}  // namespace Aws
