﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/compute-optimizer/ComputeOptimizer_EXPORTS.h>
#include <aws/compute-optimizer/model/S3Destination.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ComputeOptimizer {
namespace Model {
class ExportLambdaFunctionRecommendationsResult {
 public:
  AWS_COMPUTEOPTIMIZER_API ExportLambdaFunctionRecommendationsResult() = default;
  AWS_COMPUTEOPTIMIZER_API ExportLambdaFunctionRecommendationsResult(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_COMPUTEOPTIMIZER_API ExportLambdaFunctionRecommendationsResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The identification number of the export job.</p> <p>Use the
   * <a>DescribeRecommendationExportJobs</a> action, and specify the job ID to view
   * the status of an export job.</p>
   */
  inline const Aws::String& GetJobId() const { return m_jobId; }
  template <typename JobIdT = Aws::String>
  void SetJobId(JobIdT&& value) {
    m_jobIdHasBeenSet = true;
    m_jobId = std::forward<JobIdT>(value);
  }
  template <typename JobIdT = Aws::String>
  ExportLambdaFunctionRecommendationsResult& WithJobId(JobIdT&& value) {
    SetJobId(std::forward<JobIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const S3Destination& GetS3Destination() const { return m_s3Destination; }
  template <typename S3DestinationT = S3Destination>
  void SetS3Destination(S3DestinationT&& value) {
    m_s3DestinationHasBeenSet = true;
    m_s3Destination = std::forward<S3DestinationT>(value);
  }
  template <typename S3DestinationT = S3Destination>
  ExportLambdaFunctionRecommendationsResult& WithS3Destination(S3DestinationT&& value) {
    SetS3Destination(std::forward<S3DestinationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ExportLambdaFunctionRecommendationsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_jobId;

  S3Destination m_s3Destination;

  Aws::String m_requestId;
  bool m_jobIdHasBeenSet = false;
  bool m_s3DestinationHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ComputeOptimizer
}  // namespace Aws
