/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Arrays;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.sort.IntSet;

public class IntArraySet
implements Serializable,
IntSet {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] contents;
    private int hashCode = -1;

    public IntArraySet() {
        this.contents = EMPTY_INT_ARRAY;
    }

    public IntArraySet(IntHashSet intHashSet) {
        this.contents = intHashSet.getValues();
        Arrays.sort(this.contents);
    }

    public IntArraySet(IntArraySet intArraySet) {
        this.contents = new int[intArraySet.contents.length];
        System.arraycopy(intArraySet.contents, 0, this.contents, 0, this.contents.length);
    }

    public void clear() {
        this.contents = EMPTY_INT_ARRAY;
        this.hashCode = -1;
    }

    public int size() {
        return this.contents.length;
    }

    public boolean isEmpty() {
        return this.contents.length == 0;
    }

    public int[] getValues() {
        return this.contents;
    }

    public boolean contains(int n) {
        return Arrays.binarySearch(this.contents, n) >= 0;
    }

    public boolean remove(int n) {
        this.hashCode = -1;
        int n2 = Arrays.binarySearch(this.contents, n);
        if (n2 < 0) {
            return false;
        }
        int[] nArray = new int[this.contents.length - 1];
        if (n2 > 0) {
            System.arraycopy(this.contents, 0, nArray, 0, n2);
        }
        if (n2 < nArray.length) {
            System.arraycopy(this.contents, n2 + 1, nArray, n2, this.contents.length - n2);
        }
        this.contents = nArray;
        return true;
    }

    public boolean add(int n) {
        this.hashCode = -1;
        if (this.contents.length == 0) {
            int[] nArray = new int[]{n};
            this.contents = nArray;
            return true;
        }
        int n2 = Arrays.binarySearch(this.contents, n);
        if (n2 >= 0) {
            return false;
        }
        n2 = -n2 - 1;
        int[] nArray = new int[this.contents.length + 1];
        if (n2 > 0) {
            System.arraycopy(this.contents, 0, nArray, 0, n2);
        }
        nArray[n2] = n;
        if (n2 < this.contents.length) {
            System.arraycopy(this.contents, n2, nArray, n2 + 1, nArray.length - n2);
        }
        this.contents = nArray;
        return true;
    }

    public int getFirst() {
        return this.contents[0];
    }

    public IntIterator iterator() {
        return new IntArraySetIterator();
    }

    public IntArraySet union(IntArraySet intArraySet) {
        if (this.size() == 0) {
            return new IntArraySet(intArraySet);
        }
        if (intArraySet.size() == 0) {
            return new IntArraySet(this);
        }
        if (this.equals(intArraySet)) {
            return this;
        }
        int[] nArray = new int[this.size() + intArraySet.size()];
        int[] nArray2 = this.contents;
        int[] nArray3 = intArraySet.contents;
        int n = nArray2.length;
        int n2 = nArray3.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        do {
            if (nArray2[n4] < nArray3[n5]) {
                nArray[n3++] = nArray2[n4++];
            } else if (nArray3[n5] < nArray2[n4]) {
                nArray[n3++] = nArray3[n5++];
            } else {
                nArray[n3++] = nArray2[n4++];
                ++n5;
            }
            if (n4 != n) continue;
            System.arraycopy(nArray3, n5, nArray, n3, n2 - n5);
            return IntArraySet.make(nArray, n3 += n2 - n5);
        } while (n5 != n2);
        System.arraycopy(nArray2, n4, nArray, n3, n - n4);
        return IntArraySet.make(nArray, n3 += n - n4);
    }

    public static IntArraySet make(int[] nArray, int n) {
        int[] nArray2;
        if (nArray.length == n) {
            nArray2 = nArray;
        } else {
            nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        return new IntArraySet(nArray2);
    }

    private IntArraySet(int[] nArray) {
        this.contents = nArray;
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.contents.length * 4);
        for (int i = 0; i < this.contents.length; ++i) {
            if (i == this.contents.length - 1) {
                fastStringBuffer.append(this.contents[i] + "");
                continue;
            }
            if (this.contents[i] + 1 != this.contents[i + 1]) {
                fastStringBuffer.append(this.contents[i] + ",");
                continue;
            }
            int n = i + 1;
            while (this.contents[n] == this.contents[n - 1] + 1 && ++n != this.contents.length) {
            }
            fastStringBuffer.append(this.contents[i] + "-" + this.contents[n - 1] + ",");
            i = n;
        }
        return fastStringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof IntArraySet) {
            IntArraySet intArraySet = (IntArraySet)object;
            if (this.hashCode() != object.hashCode()) {
                return false;
            }
            return Arrays.equals(this.contents, intArraySet.contents);
        }
        if (object instanceof IntSet) {
            return this.contents.length == ((IntSet)object).size() && this.containsAll((IntSet)object);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int n = 936247625;
            IntIterator intIterator = this.iterator();
            while (intIterator.hasNext()) {
                n += intIterator.next();
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public boolean containsAll(IntSet intSet) {
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            if (this.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    private class IntArraySetIterator
    implements IntIterator,
    Serializable {
        private int i = 0;

        public boolean hasNext() {
            return this.i < IntArraySet.this.contents.length;
        }

        public int next() {
            return IntArraySet.this.contents[this.i++];
        }
    }
}

