/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.nifi.controller.ControllerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerServiceApiMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerServiceApiMatcher.class);

    public boolean matches(Class<? extends ControllerService> serviceApi, Class<? extends ControllerService> serviceImplementation) {
        for (Method apiMethod : serviceApi.getMethods()) {
            boolean foundMatchingImplMethod = false;
            for (Method implMethod : serviceImplementation.getMethods()) {
                if (!apiMethod.getName().equals(implMethod.getName()) || Modifier.isAbstract(implMethod.getModifiers())) continue;
                boolean returnTypeMatches = apiMethod.getReturnType().equals(implMethod.getReturnType());
                boolean argsMatch = Arrays.equals(apiMethod.getParameterTypes(), implMethod.getParameterTypes());
                if (!returnTypeMatches || !argsMatch) continue;
                foundMatchingImplMethod = true;
                break;
            }
            if (foundMatchingImplMethod) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} does not implement the API method [{}] from {}", new Object[]{serviceImplementation.getCanonicalName(), apiMethod, serviceApi.getCanonicalName()});
            }
            return false;
        }
        return true;
    }
}

