/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi;

import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.init.ConfigurableComponentInitializer;
import org.apache.nifi.init.ReflectionUtils;
import org.apache.nifi.mock.MockComponentLogger;
import org.apache.nifi.mock.MockConfigurationContext;
import org.apache.nifi.mock.MockFlowRegistryClientInitializationContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.FlowRegistryClientInitializationContext;
import org.apache.nifi.reporting.InitializationException;

public class FlowRegistryClientInitializer
implements ConfigurableComponentInitializer {
    private final ExtensionManager extensionManager;

    public FlowRegistryClientInitializer(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Override
    public void initialize(ConfigurableComponent component) throws InitializationException {
        FlowRegistryClient flowRegistryClient = (FlowRegistryClient)component;
        MockFlowRegistryClientInitializationContext context = new MockFlowRegistryClientInitializationContext();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader(this.extensionManager, component.getClass(), context.getIdentifier());){
            flowRegistryClient.initialize((FlowRegistryClientInitializationContext)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void teardown(ConfigurableComponent component) {
        FlowRegistryClient flowRegistryClient = (FlowRegistryClient)component;
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader(this.extensionManager, component.getClass(), component.getIdentifier());){
            MockConfigurationContext context = new MockConfigurationContext();
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, flowRegistryClient, new MockComponentLogger(), context);
        }
        finally {
            this.extensionManager.removeInstanceClassLoader(component.getIdentifier());
        }
    }
}

