/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.io.Serializable;
import org.apache.mahout.math.Algebra;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;

public class SingularValueDecomposition
implements Serializable {
    private final double[][] u;
    private final double[][] v;
    private final double[] s;
    private final int m;
    private final int n;
    private boolean transpositionNeeded;

    public SingularValueDecomposition(Matrix arg) {
        int i;
        double t;
        int k;
        int j;
        int j2;
        int i2;
        double[][] a;
        if (arg.numRows() < arg.numCols()) {
            this.transpositionNeeded = true;
        }
        if (this.transpositionNeeded) {
            this.m = arg.numCols();
            this.n = arg.numRows();
            a = new double[this.m][this.n];
            for (i2 = 0; i2 < this.m; ++i2) {
                for (j2 = 0; j2 < this.n; ++j2) {
                    a[i2][j2] = arg.get(j2, i2);
                }
            }
        } else {
            this.m = arg.numRows();
            this.n = arg.numCols();
            a = new double[this.m][this.n];
            for (i2 = 0; i2 < this.m; ++i2) {
                for (j2 = 0; j2 < this.n; ++j2) {
                    a[i2][j2] = arg.get(i2, j2);
                }
            }
        }
        int nu = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.u = new double[this.m][nu];
        this.v = new double[this.n][this.n];
        double[] e = new double[this.n];
        double[] work = new double[this.m];
        boolean wantu = true;
        boolean wantv = true;
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        for (int k2 = 0; k2 < Math.max(nct, nrt); ++k2) {
            int i3;
            int i4;
            if (k2 < nct) {
                this.s[k2] = 0.0;
                for (i4 = k2; i4 < this.m; ++i4) {
                    this.s[k2] = Algebra.hypot(this.s[k2], a[i4][k2]);
                }
                if (this.s[k2] != 0.0) {
                    if (a[k2][k2] < 0.0) {
                        this.s[k2] = -this.s[k2];
                    }
                    for (i4 = k2; i4 < this.m; ++i4) {
                        double[] dArray = a[i4];
                        int n = k2;
                        dArray[n] = dArray[n] / this.s[k2];
                    }
                    double[] dArray = a[k2];
                    int n = k2;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.s[k2] = -this.s[k2];
            }
            for (j = k2 + 1; j < this.n; ++j) {
                if (k2 < nct && this.s[k2] != 0.0) {
                    double t2 = 0.0;
                    for (i3 = k2; i3 < this.m; ++i3) {
                        t2 += a[i3][k2] * a[i3][j];
                    }
                    t2 = -t2 / a[k2][k2];
                    for (i3 = k2; i3 < this.m; ++i3) {
                        double[] dArray = a[i3];
                        int n = j;
                        dArray[n] = dArray[n] + t2 * a[i3][k2];
                    }
                }
                e[j] = a[k2][j];
            }
            if (wantu && k2 < nct) {
                for (i4 = k2; i4 < this.m; ++i4) {
                    this.u[i4][k2] = a[i4][k2];
                }
            }
            if (k2 >= nrt) continue;
            e[k2] = 0.0;
            for (i4 = k2 + 1; i4 < this.n; ++i4) {
                e[k2] = Algebra.hypot(e[k2], e[i4]);
            }
            if (e[k2] != 0.0) {
                if (e[k2 + 1] < 0.0) {
                    e[k2] = -e[k2];
                }
                i4 = k2 + 1;
                while (i4 < this.n) {
                    int n = i4++;
                    e[n] = e[n] / e[k2];
                }
                int n = k2 + 1;
                e[n] = e[n] + 1.0;
            }
            e[k2] = -e[k2];
            if (k2 + 1 < this.m && e[k2] != 0.0) {
                for (i4 = k2 + 1; i4 < this.m; ++i4) {
                    work[i4] = 0.0;
                }
                for (j = k2 + 1; j < this.n; ++j) {
                    for (int i5 = k2 + 1; i5 < this.m; ++i5) {
                        int n = i5;
                        work[n] = work[n] + e[j] * a[i5][j];
                    }
                }
                for (j = k2 + 1; j < this.n; ++j) {
                    double t3 = -e[j] / e[k2 + 1];
                    for (i3 = k2 + 1; i3 < this.m; ++i3) {
                        double[] dArray = a[i3];
                        int n = j;
                        dArray[n] = dArray[n] + t3 * work[i3];
                    }
                }
            }
            if (!wantv) continue;
            for (i4 = k2 + 1; i4 < this.n; ++i4) {
                this.v[i4][k2] = e[i4];
            }
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.s[nct] = a[nct][nct];
        }
        if (this.m < p) {
            this.s[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = a[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        if (wantu) {
            for (j = nct; j < nu; ++j) {
                for (int i6 = 0; i6 < this.m; ++i6) {
                    this.u[i6][j] = 0.0;
                }
                this.u[j][j] = 1.0;
            }
            for (k = nct - 1; k >= 0; --k) {
                int i7;
                if (this.s[k] != 0.0) {
                    for (int j3 = k + 1; j3 < nu; ++j3) {
                        t = 0.0;
                        for (i = k; i < this.m; ++i) {
                            t += this.u[i][k] * this.u[i][j3];
                        }
                        t = -t / this.u[k][k];
                        for (i = k; i < this.m; ++i) {
                            double[] dArray = this.u[i];
                            int n = j3;
                            dArray[n] = dArray[n] + t * this.u[i][k];
                        }
                    }
                    for (i7 = k; i7 < this.m; ++i7) {
                        this.u[i7][k] = -this.u[i7][k];
                    }
                    this.u[k][k] = 1.0 + this.u[k][k];
                    for (i7 = 0; i7 < k - 1; ++i7) {
                        this.u[i7][k] = 0.0;
                    }
                    continue;
                }
                for (i7 = 0; i7 < this.m; ++i7) {
                    this.u[i7][k] = 0.0;
                }
                this.u[k][k] = 1.0;
            }
        }
        if (wantv) {
            for (k = this.n - 1; k >= 0; --k) {
                if (k < nrt && e[k] != 0.0) {
                    for (int j4 = k + 1; j4 < nu; ++j4) {
                        t = 0.0;
                        for (i = k + 1; i < this.n; ++i) {
                            t += this.v[i][k] * this.v[i][j4];
                        }
                        t = -t / this.v[k + 1][k];
                        for (i = k + 1; i < this.n; ++i) {
                            double[] dArray = this.v[i];
                            int n = j4;
                            dArray[n] = dArray[n] + t * this.v[i][k];
                        }
                    }
                }
                for (int i8 = 0; i8 < this.n; ++i8) {
                    this.v[i8][k] = 0.0;
                }
                this.v[k][k] = 1.0;
            }
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        double tiny = Math.pow(2.0, -966.0);
        block39: while (p > 0) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e[k3]) <= tiny + eps * (Math.abs(this.s[k3]) + Math.abs(this.s[k3 + 1])))) continue;
                e[k3] = 0.0;
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t4 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (!(Math.abs(this.s[ks]) <= tiny + eps * t4)) continue;
                    this.s[ks] = 0.0;
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i9;
                    double sn;
                    double cs;
                    double t5;
                    double f2 = e[p - 2];
                    e[p - 2] = 0.0;
                    for (int j5 = p - 2; j5 >= k3; --j5) {
                        t5 = Algebra.hypot(this.s[j5], f2);
                        cs = this.s[j5] / t5;
                        sn = f2 / t5;
                        this.s[j5] = t5;
                        if (j5 != k3) {
                            f2 = -sn * e[j5 - 1];
                            e[j5 - 1] = cs * e[j5 - 1];
                        }
                        if (!wantv) continue;
                        for (i9 = 0; i9 < this.n; ++i9) {
                            t5 = cs * this.v[i9][j5] + sn * this.v[i9][p - 1];
                            this.v[i9][p - 1] = -sn * this.v[i9][j5] + cs * this.v[i9][p - 1];
                            this.v[i9][j5] = t5;
                        }
                    }
                    continue block39;
                }
                case 2: {
                    int i9;
                    double sn;
                    double cs;
                    double t5;
                    double f3 = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    for (int j6 = k3; j6 < p; ++j6) {
                        t5 = Algebra.hypot(this.s[j6], f3);
                        cs = this.s[j6] / t5;
                        sn = f3 / t5;
                        this.s[j6] = t5;
                        f3 = -sn * e[j6];
                        e[j6] = cs * e[j6];
                        if (!wantu) continue;
                        for (i9 = 0; i9 < this.m; ++i9) {
                            t5 = cs * this.u[i9][j6] + sn * this.u[i9][k3 - 1];
                            this.u[i9][k3 - 1] = -sn * this.u[i9][j6] + cs * this.u[i9][k3 - 1];
                            this.u[i9][j6] = t5;
                        }
                    }
                    continue block39;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(e[p - 2])), Math.abs(this.s[k3])), Math.abs(e[k3]));
                    double sp2 = this.s[p - 1] / scale;
                    double spm1 = this.s[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = this.s[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp2) * (spm1 - sp2) + epm1 * epm1) / 2.0;
                    double c = sp2 * epm1 * sp2 * epm1;
                    double shift = 0.0;
                    if (b != 0.0 || c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f4 = (sk + sp2) * (sk - sp2) + shift;
                    double g = sk * ek;
                    for (int j7 = k3; j7 < p - 1; ++j7) {
                        int i10;
                        double t6 = Algebra.hypot(f4, g);
                        double cs = f4 / t6;
                        double sn = g / t6;
                        if (j7 != k3) {
                            e[j7 - 1] = t6;
                        }
                        f4 = cs * this.s[j7] + sn * e[j7];
                        e[j7] = cs * e[j7] - sn * this.s[j7];
                        g = sn * this.s[j7 + 1];
                        this.s[j7 + 1] = cs * this.s[j7 + 1];
                        if (wantv) {
                            for (i10 = 0; i10 < this.n; ++i10) {
                                t6 = cs * this.v[i10][j7] + sn * this.v[i10][j7 + 1];
                                this.v[i10][j7 + 1] = -sn * this.v[i10][j7] + cs * this.v[i10][j7 + 1];
                                this.v[i10][j7] = t6;
                            }
                        }
                        t6 = Algebra.hypot(f4, g);
                        cs = f4 / t6;
                        sn = g / t6;
                        this.s[j7] = t6;
                        f4 = cs * e[j7] + sn * this.s[j7 + 1];
                        this.s[j7 + 1] = -sn * e[j7] + cs * this.s[j7 + 1];
                        g = sn * e[j7 + 1];
                        e[j7 + 1] = cs * e[j7 + 1];
                        if (!wantu || j7 >= this.m - 1) continue;
                        for (i10 = 0; i10 < this.m; ++i10) {
                            t6 = cs * this.u[i10][j7] + sn * this.u[i10][j7 + 1];
                            this.u[i10][j7 + 1] = -sn * this.u[i10][j7] + cs * this.u[i10][j7 + 1];
                            this.u[i10][j7] = t6;
                        }
                    }
                    e[p - 2] = f4;
                    ++iter;
                    break;
                }
                case 4: {
                    if (this.s[k3] <= 0.0) {
                        double d = this.s[k3] = this.s[k3] < 0.0 ? -this.s[k3] : 0.0;
                        if (wantv) {
                            for (int i11 = 0; i11 <= pp; ++i11) {
                                this.v[i11][k3] = -this.v[i11][k3];
                            }
                        }
                    }
                    while (k3 < pp && !(this.s[k3] >= this.s[k3 + 1])) {
                        int i12;
                        double t7 = this.s[k3];
                        this.s[k3] = this.s[k3 + 1];
                        this.s[k3 + 1] = t7;
                        if (wantv && k3 < this.n - 1) {
                            for (i12 = 0; i12 < this.n; ++i12) {
                                t7 = this.v[i12][k3 + 1];
                                this.v[i12][k3 + 1] = this.v[i12][k3];
                                this.v[i12][k3] = t7;
                            }
                        }
                        if (wantu && k3 < this.m - 1) {
                            for (i12 = 0; i12 < this.m; ++i12) {
                                t7 = this.u[i12][k3 + 1];
                                this.u[i12][k3 + 1] = this.u[i12][k3];
                                this.u[i12][k3] = t7;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public Matrix getS() {
        double[][] s = new double[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                s[i][j] = 0.0;
            }
            s[i][i] = this.s[i];
        }
        return new DenseMatrix(s);
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public Matrix getU() {
        if (this.transpositionNeeded) {
            return new DenseMatrix(this.v);
        }
        int numCols = Math.min(this.m + 1, this.n);
        DenseMatrix r = new DenseMatrix(this.m, numCols);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < numCols; ++j) {
                r.set(i, j, this.u[i][j]);
            }
        }
        return r;
    }

    public Matrix getV() {
        if (this.transpositionNeeded) {
            int numCols = Math.min(this.m + 1, this.n);
            DenseMatrix r = new DenseMatrix(this.m, numCols);
            for (int i = 0; i < this.m; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    r.set(i, j, this.u[i][j]);
                }
            }
            return r;
        }
        return new DenseMatrix(this.v);
    }

    public double norm2() {
        return this.s[0];
    }

    public int rank() {
        double eps = Math.pow(2.0, -52.0);
        double tol = (double)Math.max(this.m, this.n) * this.s[0] * eps;
        int r = 0;
        for (double value : this.s) {
            if (!(value > tol)) continue;
            ++r;
        }
        return r;
    }

    Matrix getCovariance(double minSingularValue) {
        DenseMatrix j = new DenseMatrix(this.s.length, this.s.length);
        DenseMatrix vMat = new DenseMatrix(this.v);
        for (int i = 0; i < this.s.length; ++i) {
            j.set(i, i, this.s[i] >= minSingularValue ? 1.0 / (this.s[i] * this.s[i]) : 0.0);
        }
        return vMat.times(j).times(vMat.transpose());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("---------------------------------------------------------------------\n");
        buf.append("SingularValueDecomposition(A) --> cond(A), rank(A), norm2(A), U, S, V\n");
        buf.append("---------------------------------------------------------------------\n");
        buf.append("cond = ");
        String unknown = "Illegal operation or error: ";
        try {
            buf.append(String.valueOf(this.cond()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown).append(exc.getMessage());
        }
        buf.append("\nrank = ");
        try {
            buf.append(String.valueOf(this.rank()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown).append(exc.getMessage());
        }
        buf.append("\nnorm2 = ");
        try {
            buf.append(String.valueOf(this.norm2()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown).append(exc.getMessage());
        }
        buf.append("\n\nU = ");
        try {
            buf.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown).append(exc.getMessage());
        }
        buf.append("\n\nS = ");
        try {
            buf.append(String.valueOf(this.getS()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown).append(exc.getMessage());
        }
        buf.append("\n\nV = ");
        try {
            buf.append(String.valueOf(this.getV()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown).append(exc.getMessage());
        }
        return buf.toString();
    }
}

